/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.builder;

import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.builder.DependencyGraph;
import org.eclipse.wst.common.componentcore.resources.ComponentHandle;
import org.eclipse.wst.common.componentcore.resources.IFlexibleProject;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class DependencyGraphManager {
    private static DependencyGraphManager INSTANCE = null;
    private HashMap wtpModuleTimeStamps = null;

    private DependencyGraphManager() {
    }

    public static final DependencyGraphManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DependencyGraphManager();
            INSTANCE.constructIfNecessary();
        }
        return INSTANCE;
    }

    public void construct(IProject project) {
        if (project != null && project.isAccessible() && project.findMember(".wtpmodules") != null) {
            this.constructIfNecessary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructIfNecessary() {
        DependencyGraphManager dependencyGraphManager = this;
        synchronized (dependencyGraphManager) {
            if (this.moduleTimeStampsChanged()) {
                this.cleanDependencyGraph();
                this.buildDependencyGraph();
            }
        }
    }

    private boolean moduleTimeStampsChanged() {
        HashMap workspaceTimeStamps = this.collectModuleTimeStamps();
        return !this.getWtpModuleTimeStamps().equals(workspaceTimeStamps);
    }

    private HashMap collectModuleTimeStamps() {
        HashMap<IProject, Long> timeStamps = new HashMap<IProject, Long>();
        IProject[] projects = ProjectUtilities.getAllProjects();
        int i = 0;
        while (i < projects.length) {
            IResource wtpModulesFile;
            if (projects[i] != null && projects[i].isAccessible() && (wtpModulesFile = projects[i].findMember(".wtpmodules")) != null) {
                Long currentTimeStamp = new Long(wtpModulesFile.getLocalTimeStamp());
                timeStamps.put(projects[i], currentTimeStamp);
            }
            ++i;
        }
        return timeStamps;
    }

    private void buildDependencyGraph() {
        IProject[] projects = ProjectUtilities.getAllProjects();
        int k = 0;
        while (k < projects.length) {
            IFlexibleProject refProject = ComponentCore.createFlexibleProject(projects[k]);
            if (projects[k].isAccessible() && refProject != null && this.addTimeStamp(projects[k])) {
                IVirtualComponent[] components = refProject.getComponents();
                int j = 0;
                while (j < components.length) {
                    this.addDependencyReference(components[j]);
                    ++j;
                }
            }
            ++k;
        }
    }

    private void addDependencyReference(IVirtualComponent component) {
        ComponentHandle componentHandle = component.getComponentHandle();
        IVirtualReference[] depRefs = component.getReferences();
        int i = 0;
        while (i < depRefs.length) {
            IVirtualComponent targetComponent = depRefs[i].getReferencedComponent();
            if (targetComponent != null) {
                ComponentHandle targetHandle = targetComponent.getComponentHandle();
                DependencyGraph.getInstance().addReference(targetHandle, componentHandle);
            }
            ++i;
        }
    }

    private boolean addTimeStamp(IProject project) {
        IResource wtpModulesFile = project.findMember(".wtpmodules");
        if (wtpModulesFile == null) {
            return false;
        }
        Long currentTimeStamp = new Long(wtpModulesFile.getLocalTimeStamp());
        this.getWtpModuleTimeStamps().put(project, currentTimeStamp);
        return true;
    }

    private void cleanDependencyGraph() {
        DependencyGraph.getInstance().clear();
        this.getWtpModuleTimeStamps().clear();
    }

    private HashMap getWtpModuleTimeStamps() {
        if (this.wtpModuleTimeStamps == null) {
            this.wtpModuleTimeStamps = new HashMap();
        }
        return this.wtpModuleTimeStamps;
    }

    public DependencyGraph getDependencyGraph() {
        this.constructIfNecessary();
        return DependencyGraph.getInstance();
    }
}

