/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.resources;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class ComponentHandle {
    private final IProject project;
    private final String name;
    private String toString;
    private int hashCode;

    private ComponentHandle(IProject aProject, String aComponentName) {
        this.project = aProject;
        this.name = aComponentName;
    }

    public String getName() {
        return this.name;
    }

    public IProject getProject() {
        return this.project;
    }

    public static ComponentHandle create(IProject aProject, String aComponentName) {
        return new ComponentHandle(aProject, aComponentName);
    }

    public static ComponentHandle create(IProject aContext, URI aComponentURI) {
        IProject componentProject = null;
        String componentName = null;
        if (aComponentURI == null) {
            return null;
        }
        if (aComponentURI.segmentCount() == 1) {
            componentProject = aContext;
            componentName = aComponentURI.segment(0);
        } else {
            try {
                componentProject = StructureEdit.getContainingProject(aComponentURI);
                componentName = StructureEdit.getDeployedName(aComponentURI);
            }
            catch (UnresolveableURIException unresolveableURIException) {
                return null;
            }
        }
        return new ComponentHandle(componentProject, componentName);
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = this.project != null ? "[" + this.project.getFullPath() + "]:" + this.name : "[NONE]:" + this.name;
        }
        return this.toString;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.toString().hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ComponentHandle) {
            ComponentHandle other = (ComponentHandle)obj;
            return this.getProject().equals((Object)other.getProject()) && (this.getName() == null && other.getName() == null || this.getName().equals(other.getName()));
        }
        return false;
    }

    public IVirtualComponent createComponent() {
        return ComponentCore.createComponent(this.getProject(), this.getName());
    }
}

