/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.jca.internal.deployables;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.internal.deployables.J2EEDeployable;
import org.eclipse.jst.j2ee.internal.project.J2EEModuleNature;
import org.eclipse.jst.j2ee.internal.project.J2EENature;
import org.eclipse.jst.server.core.IConnectorModule;

public class ConnectorDeployable
extends J2EEDeployable
implements IConnectorModule {
    protected static final String SERVER_CONTAINER = "org.eclipse.jst.server.core.container";
    private IJavaModel javaModel;

    public ConnectorDeployable(J2EEModuleNature aNature, String aFactoryId) {
        super((J2EENature)aNature, aFactoryId);
    }

    public IJavaModel getJavaModel() {
        if (this.javaModel == null) {
            this.javaModel = JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot());
        }
        return this.javaModel;
    }

    public IPath getRootFolder() {
        J2EEModuleNature aNature = (J2EEModuleNature)this.getNature();
        if (aNature == null) {
            return super.getRootFolder();
        }
        if (aNature.isBinaryProject()) {
            return null;
        }
        return aNature.getModuleServerRoot().getProjectRelativePath();
    }

    public IPath[] getClasspath() {
        IProject proj = this.getProject();
        if (proj != null && proj.isAccessible()) {
            ArrayList classpath = new ArrayList();
            ArrayList visitedProjects = new ArrayList();
            this.collectClasspathEntries(this.getJavaProject(proj), false, visitedProjects, classpath);
            return this.convertClassPathList(classpath);
        }
        return new IPath[0];
    }

    public IPath[] convertClassPathList(List classPathList) {
        IPath[] classPath = new IPath[classPathList.size()];
        int i = 0;
        Iterator iter = classPathList.iterator();
        while (iter.hasNext()) {
            IPath element = (IPath)iter.next();
            classPath[i++] = element;
        }
        return classPath;
    }

    protected void collectClasspathEntries(IJavaProject javaProject, boolean checkExport, List visitedProjects, List classpath) {
        if (javaProject != null && javaProject.exists() && !visitedProjects.contains(javaProject)) {
            visitedProjects.add(javaProject);
            this.addOutputLocationPath(javaProject, classpath);
            this.traverseClasspathEntries(javaProject, checkExport, visitedProjects, classpath);
        }
    }

    protected void addOutputLocationPath(IJavaProject javaProject, List classpath) {
        IFolder outputFolder;
        IPath outputLoc = null;
        try {
            outputLoc = javaProject.getOutputLocation();
        }
        catch (JavaModelException javaModelException) {}
        if (outputLoc != null && (outputFolder = this.getWorkspaceRoot().getFolder(outputLoc)).isAccessible()) {
            classpath.add(outputFolder.getLocation());
        }
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected void traverseClasspathEntries(IJavaProject javaProject, boolean checkExport, List visitedProjects, List classpath) {
        IClasspathEntry[] entries = null;
        try {
            entries = javaProject.getRawClasspath();
        }
        catch (JavaModelException javaModelException) {}
        if (entries == null) {
            return;
        }
        IClasspathEntry entry = null;
        int i = 0;
        while (i < entries.length) {
            entry = entries[i];
            if (!checkExport || entry.isExported()) {
                switch (entry.getEntryKind()) {
                    case 1: {
                        this.processLibraryEntry(entry, classpath);
                        break;
                    }
                    case 5: {
                        this.processContainerEntry(entry, classpath);
                        break;
                    }
                    case 2: {
                        this.processProjectEntry(entry, visitedProjects, classpath);
                    }
                }
            }
            ++i;
        }
    }

    protected void processLibraryEntry(IClasspathEntry entry, List classpath) {
        this.addClasspathEntryPath(entry, classpath);
    }

    protected void addClasspathEntryPath(IClasspathEntry entry, List classpath) {
        IPath entryPath = entry.getPath();
        if (entryPath.getDevice() == null) {
            classpath.add(this.getWorkspaceRoot().getLocation().append(entryPath));
        } else {
            classpath.add(entryPath);
        }
    }

    protected void processContainerEntry(IClasspathEntry entry, List classpath) {
        if (this.isValidContainerEntry(entry)) {
            IClasspathEntry resolvedEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
            this.addClasspathEntryPath(resolvedEntry, classpath);
        }
    }

    protected void processProjectEntry(IClasspathEntry entry, List visitedProjects, List classpath) {
        String projName = entry.getPath().segment(0);
        IJavaProject javaProj = this.getJavaProject(projName);
        this.collectClasspathEntries(javaProj, true, visitedProjects, classpath);
    }

    protected IJavaProject getJavaProject(IProject proj) {
        return this.getJavaProject(proj.getName());
    }

    protected IJavaProject getJavaProject(String projName) {
        return this.getJavaModel().getJavaProject(projName);
    }

    protected boolean isValidContainerEntry(IClasspathEntry entry) {
        return entry.getPath().segment(0).equals(SERVER_CONTAINER);
    }

    public String getType() {
        return "j2ee.connector";
    }

    public String getVersion() {
        return "1.2";
    }
}

