/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.ui.internal.classpath;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.jst.j2ee.internal.web.classpath.WebAppContainer;
import org.eclipse.jst.servlet.ui.internal.plugin.WEBUIMessages;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IFlexibleProject;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class WebAppContainerPage
extends NewElementWizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension {
    private IProject project;
    private IJavaProject jproject;
    private String component;
    private Label componentLabel;
    private Combo componentCombo;

    public WebAppContainerPage() {
        super(WebAppContainerPage.resource("WEB_CONT_NAME"));
        this.setTitle(WebAppContainerPage.resource("WEB_CONT_PAGE_TITLE"));
        this.setDescription(WebAppContainerPage.resource("WEB_CONT_PAGE_DESCRIPTION"));
        this.setImageDescriptor(JavaPluginImages.DESC_WIZBAN_ADD_LIBRARY);
    }

    public void initialize(IJavaProject jproject, IClasspathEntry[] cp) {
        this.jproject = jproject;
        this.project = jproject.getProject();
    }

    public IClasspathEntry getSelection() {
        int sel = this.componentCombo.getSelectionIndex();
        String cmp = this.componentCombo.getItem(sel).trim();
        return WebAppContainer.convert((String)cmp);
    }

    public void setSelection(IClasspathEntry cpe) {
        if (cpe == null) {
            return;
        }
        this.component = WebAppContainer.convert((IClasspathEntry)cpe);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.componentLabel = new Label(composite, 0);
        this.componentLabel.setText(WebAppContainerPage.resource("WEB_CONT_PAGE_COMP_LABEL"));
        this.componentCombo = new Combo(composite, 8);
        List components = this.components();
        int i = 0;
        int n = components.size();
        while (i < n) {
            String cmp = (String)components.get(i);
            this.componentCombo.add(String.valueOf(cmp) + "        ");
            if (this.component != null && this.component.equals(cmp)) {
                this.componentCombo.select(i);
            }
            ++i;
        }
        this.setControl((Control)composite);
    }

    public boolean finish() {
        return this.componentCombo.getSelectionIndex() != -1;
    }

    private List components() {
        ArrayList<String> used = new ArrayList<String>();
        try {
            IClasspathEntry[] cp = this.jproject.getRawClasspath();
            int i = 0;
            while (i < cp.length) {
                IClasspathEntry cpe = cp[i];
                if (WebAppContainer.check((IClasspathEntry)cpe)) {
                    used.add(WebAppContainer.convert((IClasspathEntry)cpe));
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        ArrayList<String> res = new ArrayList<String>();
        IFlexibleProject fp = ComponentCore.createFlexibleProject((IProject)this.project);
        IVirtualComponent[] components = fp.getComponents();
        int i = 0;
        while (i < components.length) {
            IVirtualComponent vc = components[i];
            String cmp = vc.getName();
            if (this.component != null && this.component.equals(cmp) || !used.contains(vc.getName())) {
                res.add(vc.getName());
            }
            ++i;
        }
        return res;
    }

    private static String resource(String key) {
        return WEBUIMessages.getResourceString(key);
    }
}

