/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.j2ee.applicationclient.internal.creation.AppClientComponentCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.earcreation.EARNatureRuntime;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateEARProjectCommand;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class CreateAppClientProjectCommand
extends SimpleCommand {
    private String appClientProjectName_;
    private String earProjectName_;
    private String serverFactoryId_;
    private String j2eeVersion_;

    public CreateAppClientProjectCommand() {
        super("org.eclipse.jst.ws.internal.consumption.command.common.CreateAppClientProjectCommand", "org.eclipse.jst.ws.internal.consumption.command.common.CreateAppClientProjectCommand");
    }

    public Status execute(Environment env) {
        MessageUtils msgUtils_ = new MessageUtils("org.eclipse.jst.ws.consumption.plugin", (Object)this);
        try {
            IProject appClientProject;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject earProject = root.getProject(this.earProjectName_);
            if (earProject != null && !earProject.exists()) {
                CreateEARProjectCommand c = new CreateEARProjectCommand();
                c.setEarProjectName(this.earProjectName_);
                c.setServerFactoryId(this.serverFactoryId_);
                c.setJ2EEVersion(this.j2eeVersion_);
                c.execute(env);
                earProject = root.getProject(this.earProjectName_);
            }
            if ((appClientProject = root.getProject(this.appClientProjectName_)) != null && !appClientProject.exists()) {
                IDataModel info = DataModelFactory.createDataModel((IDataModelProvider)new AppClientComponentCreationDataModelProvider());
                info.setProperty("IComponentCreationDataModelProperties.COMPONENT_NAME", (Object)this.appClientProjectName_);
                info.setProperty("IJ2EEComponentCreationDataModelProperties.EAR_COMPONENT_NAME", (Object)this.earProjectName_);
                info.setProperty("IJ2EEComponentCreationDataModelProperties.ADD_TO_EAR", (Object)Boolean.TRUE);
                if (this.j2eeVersion_ != null && this.j2eeVersion_.length() > 0) {
                    info.setProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", (Object)new Integer(this.j2eeVersion_));
                } else if (earProject != null && earProject.exists()) {
                    EARNatureRuntime ear = EARNatureRuntime.getRuntime((IProject)earProject);
                    int earVersion = ear.getJ2EEVersion();
                    info.setProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", (Object)new Integer(earVersion));
                    String.valueOf(earVersion);
                } else {
                    info.setProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", (Object)new Integer(13));
                    String.valueOf(13);
                }
                if (this.serverFactoryId_ != null) {
                    this.serverFactoryId_.length();
                }
                IDataModelOperation operation = info.getDefaultOperation();
                operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
        }
        catch (ExecutionException ite) {
            SimpleStatus status = new SimpleStatus("org.eclipse.jst.ws.consumption", msgUtils_.getMessage("MSG_ERROR_CANNOT_CREATE_APP_CLIENT_PROJECT", (Object[])new String[]{this.appClientProjectName_}), 4, (Throwable)ite);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
        return new SimpleStatus("");
    }

    public void setAppClientProjectName(String appClientProjectName) {
        this.appClientProjectName_ = appClientProjectName;
    }

    public void setEarProjectName(String earProjectName) {
        this.earProjectName_ = earProjectName;
    }

    public void setServerFactoryId(String serverFactoryId) {
        this.serverFactoryId_ = serverFactoryId;
    }

    public void setJ2EEVersion(String j2eeVersion) {
        this.j2eeVersion_ = j2eeVersion;
    }
}

