/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.ws.internal.consumption.plugin.WebServiceConsumptionPlugin;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;

public class CreateJavaProjectCommand
extends SimpleCommand {
    private String projectName_;

    public CreateJavaProjectCommand() {
        super("org.eclipse.jst.ws.internal.consumption.command.common.CreateJavaProjectCommand", "org.eclipse.jst.ws.internal.consumption.command.common.CreateJavaProjectCommand");
    }

    public Status execute(Environment env) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName_);
        if (project != null && !project.exists()) {
            try {
                NullProgressMonitor monitor = new NullProgressMonitor();
                project.create(ResourcesPlugin.getWorkspace().newProjectDescription(project.getName()), (IProgressMonitor)monitor);
                project.open((IProgressMonitor)monitor);
                IProjectDescription desc = project.getDescription();
                desc.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
                ICommand cmd = desc.newCommand();
                cmd.setBuilderName("org.eclipse.jdt.core.javabuilder");
                desc.setBuildSpec(new ICommand[]{cmd});
                project.setDescription(desc, (IProgressMonitor)monitor);
                IJavaProject javaProject = JavaCore.create((IProject)project);
                Path projectRoot = new Path(Path.ROOT.append((IPath)new Path(project.getName())).toString());
                javaProject.setRawClasspath(new IClasspathEntry[]{JavaCore.newSourceEntry((IPath)projectRoot), JavaCore.newContainerEntry((IPath)new Path(JavaRuntime.JRE_CONTAINER))}, (IProgressMonitor)monitor);
                javaProject.setOutputLocation((IPath)projectRoot, (IProgressMonitor)monitor);
            }
            catch (CoreException ce) {
                SimpleStatus status = new SimpleStatus("org.eclipse.jst.ws.consumption", WebServiceConsumptionPlugin.getMessage("%MSG_ERROR_CANNOT_CREATE_JAVA_PROJECT", new String[]{this.projectName_}), 4, (Throwable)ce);
                env.getStatusHandler().reportError((Status)status);
                return status;
            }
        }
        return new SimpleStatus("");
    }

    public void setProjectName(String projectName) {
        this.projectName_ = projectName;
    }
}

