/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.application.internal.operations.FlexibleJavaProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.applicationclient.internal.creation.AppClientComponentCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.earcreation.EarComponentCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.ejb.archiveoperations.EjbComponentCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebComponentCreationDataModelProvider;
import org.eclipse.jst.ws.internal.common.EnvironmentUtils;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class CreateModuleCommand
extends SimpleCommand {
    public static final int WEB = 1;
    public static final int EJB = 2;
    public static final int APPCLIENT = 4;
    public static final int EAR = 8;
    private String projectName;
    private String moduleName;
    private int moduleType;
    private String j2eeLevel;
    private String serverFactoryId;
    private String serverInstanceId_;
    private Environment env;
    private MessageUtils msgUtils = new MessageUtils("org.eclipse.jst.ws.consumption.plugin", (Object)this);

    public Status execute(Environment environment) {
        this.env = environment;
        SimpleStatus status = new SimpleStatus("");
        status = this.checkDataReady();
        if (status.getSeverity() == 4) {
            return status;
        }
        IProject project = ProjectUtilities.getProject((String)this.projectName);
        if (!(project != null && project.exists() || (status = this.createFlexibleJavaProject()).getSeverity() != 4)) {
            return status;
        }
        if (this.projectName != null) {
            if (this.moduleName == null ? project.exists() : J2EEUtils.exists((String)this.projectName, (String)this.moduleName)) {
                return status;
            }
        } else {
            return new SimpleStatus("", this.msgUtils.getMessage("MSG_ERROR_COMPONENT_CREATION", (Object[])new String[]{this.projectName, this.moduleName}), 4, null);
        }
        int type = this.getModuleType();
        switch (type) {
            case 1: {
                status = this.createWebComponent();
                break;
            }
            case 2: {
                status = this.createEJBComponent();
                break;
            }
            case 4: {
                status = this.createAppClientComponent();
                break;
            }
            case 8: {
                status = this.createEARComponent();
                break;
            }
            default: {
                return new SimpleStatus("", this.msgUtils.getMessage("MSG_ERROR_COMPONENT_CREATION", (Object[])new String[]{this.moduleName}), 4, null);
            }
        }
        return status;
    }

    private Status checkDataReady() {
        if (this.projectName == null || this.serverFactoryId == null) {
            return new SimpleStatus("", this.msgUtils.getMessage("MSG_ERROR_COMPONENT_CREATION", (Object[])new String[]{this.projectName, this.moduleName}), 4, null);
        }
        return new SimpleStatus("");
    }

    public Status createWebComponent() {
        SimpleStatus status = new SimpleStatus("");
        try {
            IDataModel projectInfo = DataModelFactory.createDataModel((IDataModelProvider)new WebComponentCreationDataModelProvider());
            projectInfo.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)this.projectName);
            if (this.moduleName != null) {
                projectInfo.setProperty("IComponentCreationDataModelProperties.COMPONENT_NAME", (Object)this.moduleName);
            }
            Integer servletLevel = J2EEUtils.getServletVersionForJ2EEVersion((String)this.j2eeLevel);
            if (this.j2eeLevel != null) {
                projectInfo.setProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", (Object)servletLevel);
            }
            IDataModelOperation op = projectInfo.getDefaultOperation();
            if (this.env != null) {
                op.execute(EnvironmentUtils.getIProgressMonitor((Environment)this.env), null);
            } else {
                op.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
        }
        catch (Exception e) {
            status = new SimpleStatus("", e.getMessage(), 4, (Throwable)e);
        }
        return status;
    }

    public Status createEARComponent() {
        SimpleStatus status = new SimpleStatus("");
        try {
            IDataModel projectInfo = DataModelFactory.createDataModel((IDataModelProvider)new EarComponentCreationDataModelProvider());
            projectInfo.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)this.projectName);
            if (this.moduleName != null) {
                projectInfo.setProperty("IComponentCreationDataModelProperties.COMPONENT_NAME", (Object)this.moduleName);
            }
            if (this.j2eeLevel != null) {
                projectInfo.setProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", (Object)Integer.valueOf(this.j2eeLevel));
            }
            IDataModelOperation op = projectInfo.getDefaultOperation();
            if (this.env != null) {
                op.execute(EnvironmentUtils.getIProgressMonitor((Environment)this.env), null);
            } else {
                op.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
        }
        catch (Exception e) {
            status = new SimpleStatus("", e.getMessage(), 4, (Throwable)e);
        }
        return status;
    }

    public Status createEJBComponent() {
        SimpleStatus status = new SimpleStatus("");
        try {
            IDataModel projectInfo = DataModelFactory.createDataModel((IDataModelProvider)new EjbComponentCreationDataModelProvider());
            projectInfo.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)this.projectName);
            if (this.moduleName != null) {
                projectInfo.setProperty("IComponentCreationDataModelProperties.COMPONENT_NAME", (Object)this.moduleName);
            }
            Integer ejbLevel = J2EEUtils.getEJBVersionForJ2EEVersion((String)this.j2eeLevel);
            if (this.j2eeLevel != null) {
                projectInfo.setProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", (Object)ejbLevel);
            }
            projectInfo.setProperty("IJ2EEComponentCreationDataModelProperties.ADD_TO_EAR", (Object)Boolean.FALSE);
            IDataModelOperation op = projectInfo.getDefaultOperation();
            if (this.env != null) {
                op.execute(EnvironmentUtils.getIProgressMonitor((Environment)this.env), null);
            } else {
                op.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
        }
        catch (Exception e) {
            status = new SimpleStatus("", this.msgUtils.getMessage("MSG_ERROR_CREATE_EJB_COMPONENT", (Object[])new String[]{this.projectName}), 4, (Throwable)e);
        }
        return status;
    }

    public Status createAppClientComponent() {
        SimpleStatus status = new SimpleStatus("");
        try {
            IDataModel projectInfo = DataModelFactory.createDataModel((IDataModelProvider)new AppClientComponentCreationDataModelProvider());
            projectInfo.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)this.projectName);
            if (this.moduleName != null) {
                projectInfo.setProperty("IComponentCreationDataModelProperties.COMPONENT_NAME", (Object)this.moduleName);
            }
            if (this.j2eeLevel != null) {
                projectInfo.setProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", (Object)Integer.valueOf(this.j2eeLevel));
            }
            projectInfo.setProperty("IJ2EEComponentCreationDataModelProperties.ADD_TO_EAR", (Object)Boolean.FALSE);
            IDataModelOperation op = projectInfo.getDefaultOperation();
            if (this.env != null) {
                op.execute(EnvironmentUtils.getIProgressMonitor((Environment)this.env), null);
            } else {
                op.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
        }
        catch (Exception e) {
            status = new SimpleStatus("", this.msgUtils.getMessage("MSG_ERROR_CREATE_APPCIENT_PROJET", (Object[])new String[]{this.projectName}), 4, (Throwable)e);
        }
        return status;
    }

    public Status createFlexibleJavaProject() {
        SimpleStatus status = new SimpleStatus("");
        try {
            IDataModel projectInfo = DataModelFactory.createDataModel((IDataModelProvider)new FlexibleJavaProjectCreationDataModelProvider());
            projectInfo.setProperty("IFlexibleProjectCreationDataModelProperties.PROJECT_NAME", (Object)this.projectName);
            String runtimeTargetId = null;
            if (this.serverInstanceId_ == null) {
                runtimeTargetId = ServerUtils.getServerTargetIdFromFactoryId((String)this.serverFactoryId, (String)ServerUtils.getServerTargetModuleType((int)this.moduleType), (String)this.j2eeLevel);
            } else {
                IServer server = ServerCore.findServer((String)this.serverInstanceId_);
                runtimeTargetId = server.getRuntime().getId();
            }
            projectInfo.setProperty("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID", (Object)runtimeTargetId);
            projectInfo.setProperty("IFlexibleProjectCreationDataModelProperties.ADD_SERVER_TARGET", (Object)Boolean.TRUE);
            IDataModelOperation op = projectInfo.getDefaultOperation();
            if (this.env != null) {
                op.execute(EnvironmentUtils.getIProgressMonitor((Environment)this.env), null);
            } else {
                op.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
        }
        catch (Exception e) {
            status = new SimpleStatus("", this.msgUtils.getMessage("MSG_ERROR_CREATE_FLEX_PROJET", (Object[])new String[]{this.projectName}), 4, (Throwable)e);
        }
        return status;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public int getModuleType() {
        return this.moduleType;
    }

    public void setModuleType(int moduleType) {
        this.moduleType = moduleType;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setJ2eeLevel(String level) {
        this.j2eeLevel = level != null && level.indexOf(".") != -1 ? J2EEUtils.getJ2EEIntVersionAsString((String)level) : level;
    }

    public void setServerFactoryId(String serverFactoryId) {
        this.serverFactoryId = serverFactoryId;
    }

    public void setServerInstanceId(String serverInstanceId) {
        this.serverInstanceId_ = serverInstanceId;
    }
}

