/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.plugin.JavaEMFNature;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.impl.JavaClassImpl;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.plugin.WebServiceConsumptionPlugin;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;

public class JavaMofReflectionCommand
extends SimpleCommand {
    public static String LABEL = "JavaMofReflectionCommand";
    public static String DESCRIPTION = "reflection for a given class";
    public static String OK_MESSAGE = "The model has been built ";
    private static String JAVA_EXTENSION = ".java";
    private static String CLASS_EXTENSION = ".class";
    private MessageUtils msgUtils_;
    private String clientProject;
    private ResourceSet resourceSet;
    private JavaHelpers javaClass;
    private String qname;
    private String proxyBean;
    private IProject clientIProject;

    public JavaMofReflectionCommand() {
        String pluginId = "org.eclipse.jst.ws.consumption";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.setDescription(DESCRIPTION);
        this.setName(LABEL);
    }

    public JavaHelpers getJavaClass() {
        return this.javaClass;
    }

    private void processQName() {
        this.qname = this.proxyBean;
        if (this.qname.toLowerCase().endsWith(JAVA_EXTENSION)) {
            this.qname = this.qname.substring(0, this.qname.length() - 5);
        }
        if (this.qname.toLowerCase().endsWith(CLASS_EXTENSION)) {
            this.qname = this.qname.substring(0, this.qname.length() - 6);
        }
    }

    public Status execute(Environment env) {
        SimpleStatus status = new SimpleStatus("");
        IProject clientIProject = (IProject)ResourceUtils.findResource((String)this.clientProject);
        this.processQName();
        if (this.clientProject == null || this.qname == null) {
            return new SimpleStatus("org.eclipse.jst.ws.consumption", WebServiceConsumptionPlugin.getMessage("%MSG_WARN_UNABLE_TO_FIND_PROXY"), 2);
        }
        JavaEMFNature nature = JavaEMFNature.getRuntime((IProject)clientIProject);
        if (nature == null) {
            try {
                nature = JavaEMFNature.createRuntime((IProject)clientIProject);
            }
            catch (CoreException coreException) {}
        }
        this.resourceSet = nature.getResourceSet();
        this.javaClass = JavaClassImpl.reflect((String)this.qname, (ResourceSet)this.resourceSet);
        return status;
    }

    public void setProxyBean(String proxyBean) {
        this.proxyBean = proxyBean;
    }

    public void setClientProject(String clientProject) {
        this.clientProject = clientProject;
    }
}

