/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jst.ws.internal.common.EnvironmentUtils;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.eclipse.EclipseLog;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.Log;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class StartServerCommand
extends SimpleCommand {
    private String DESCRIPTION = "(Re)Start and publish the server";
    private String LABEL = "StartServerCommand";
    private MessageUtils msgUtils_;
    private IProgressMonitor monitor;
    private Log log;
    private boolean forcePublish_;
    private String serverInstanceId;

    public StartServerCommand() {
        String pluginId = "org.eclipse.jst.ws.consumption";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.setDescription(this.DESCRIPTION);
        this.setName(this.LABEL);
        this.log = new EclipseLog();
        this.forcePublish_ = false;
    }

    public StartServerCommand(boolean forcePublish) {
        this();
        this.forcePublish_ = forcePublish;
    }

    public Status execute(Environment env) {
        SimpleStatus status = new SimpleStatus("");
        IServer server = ServerCore.findServer((String)this.serverInstanceId);
        if (server == null) {
            status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_INSTANCE_NOT_FOUND"), 4);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
        this.monitor = EnvironmentUtils.getIProgressMonitor((Environment)env);
        int serverState = server.getServerState();
        int publishState = server.getServerPublishState();
        switch (publishState) {
            case 2: {
                if (server.canPublish().getSeverity() != 0 || (status = this.publish(server, 1)).getSeverity() != 4) break;
                env.getStatusHandler().reportError((Status)status);
                return status;
            }
            case 3: {
                if (server.canPublish().getSeverity() != 0 || (status = this.publish(server, 2)).getSeverity() != 4) break;
                env.getStatusHandler().reportError((Status)status);
                return status;
            }
            case 0: {
                if (server.canPublish().getSeverity() != 0 || (status = this.publish(server, 4)).getSeverity() != 4) break;
                env.getStatusHandler().reportError((Status)status);
                return status;
            }
            case 1: {
                if (!this.forcePublish_ || (status = this.publish(server, 1)).getSeverity() != 4) break;
                env.getStatusHandler().reportError((Status)status);
                return status;
            }
        }
        switch (serverState) {
            case 4: {
                if (server.canStart("run").getSeverity() != 0 || (status = this.start(server)).getSeverity() != 4) break;
                env.getStatusHandler().reportError((Status)status);
                return status;
            }
            case 2: {
                boolean shouldRestart = server.getServerRestartState();
                if (publishState == 1 || !shouldRestart || server.canRestart("run").getSeverity() != 0 || (status = this.restart(server)).getSeverity() != 4) break;
                env.getStatusHandler().reportError((Status)status);
                return status;
            }
        }
        return status;
    }

    private Status publish(final IServer server, final int kind) {
        SimpleStatus status = new SimpleStatus("");
        final IStatus[] istatus = new IStatus[1];
        this.monitor.subTask(this.msgUtils_.getMessage("PROGRESS_INFO_PUBLISHING_SERVER"));
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                istatus[0] = server.publish(kind, monitor);
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, false, runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        if (istatus[0].getSeverity() != 0) {
            status = EnvironmentUtils.convertIStatusToStatus((IStatus)istatus[0]);
            return status;
        }
        this.log.log(1, 5051, (Object)this, "publishProject", (Object)("IServer=" + server + ", Publish command completed"));
        return status;
    }

    private Status restart(IServer server) {
        SimpleStatus status = new SimpleStatus("");
        try {
            this.monitor.subTask(this.msgUtils_.getMessage("PROGRESS_INFO_STARTING_SERVER"));
            server.synchronousRestart("run", this.monitor);
            this.log.log(1, 5052, (Object)this, "execute", (Object)("IServer=" + server + ", Restart command completed"));
            return status;
        }
        catch (CoreException e) {
            status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_SERVER"), 4, (Throwable)e);
            return status;
        }
    }

    private Status start(IServer server) {
        SimpleStatus status = new SimpleStatus("");
        try {
            this.monitor.subTask(this.msgUtils_.getMessage("PROGRESS_INFO_STARTING_SERVER"));
            server.synchronousStart("run", this.monitor);
            this.log.log(1, 5053, (Object)this, "execute", (Object)("IServer=" + server + ", Start command completed"));
            return status;
        }
        catch (CoreException e) {
            status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_SERVER"), 4, (Throwable)e);
            return status;
        }
    }

    public void setServerInstanceId(String serverInstanceId) {
        this.serverInstanceId = serverInstanceId;
    }
}

