/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.actions;

import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.actions.WSDLElementUIAction;
import org.eclipse.wst.wsdl.ui.internal.commands.AddMessageCommand;
import org.eclipse.wst.wsdl.ui.internal.util.NameUtil;
import org.eclipse.wst.wsdl.ui.internal.widgets.NewComponentDialog;

public final class AddMessageUIAction
extends WSDLElementUIAction {
    private Definition definition;
    private String name;
    private IEditorPart editorPart;

    public AddMessageUIAction(Definition definition, String name, boolean createPart) {
        super(new AddMessageCommand(definition, name, createPart), WSDLEditorPlugin.getWSDLString("_UI_ACTION_ADD"), "message", WSDLEditorPlugin.getImageDescriptor("icons/message_obj.gif"));
        this.definition = definition;
        this.name = name;
    }

    protected boolean showDialog() {
        this.name = NameUtil.buildUniqueMessageName(this.definition, this.name);
        this.name = this.showDialogHelper(WSDLEditorPlugin.getWSDLString("_UI_ACTION_NEW_MESSAGE"), this.name);
        return this.name != null;
    }

    protected String showDialogHelper(String title, String defaultName) {
        String result = defaultName;
        NewComponentDialog dialog = new NewComponentDialog(WSDLEditorPlugin.getShell(), title, defaultName);
        int rc = dialog.createAndOpen();
        result = rc == 0 ? dialog.getName() : null;
        return result;
    }

    protected void preRun() {
        ((AddMessageCommand)this.modelAction).setLocalName(this.name);
    }

    protected WSDLElement getOwner() {
        return this.definition;
    }
}

