/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.actions;

import java.util.Hashtable;
import org.eclipse.jface.action.Action;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class AddNamespaceDeclarationsAction
extends Action {
    protected Element ownerElement;
    protected String[] namespaceNames;
    protected String[] preferredPrefixes;

    public AddNamespaceDeclarationsAction(Element ownerElement, String[] namespaceNames, String[] preferredPrefixes) {
        this.ownerElement = ownerElement;
        this.namespaceNames = namespaceNames;
        this.preferredPrefixes = preferredPrefixes;
    }

    public AddNamespaceDeclarationsAction(Element ownerElement, String namespaceName, String preferredPrefix) {
        this.ownerElement = ownerElement;
        this.namespaceNames = new String[1];
        this.namespaceNames[0] = namespaceName;
        this.preferredPrefixes = new String[1];
        this.preferredPrefixes[0] = preferredPrefix;
    }

    public void run() {
        if (this.ownerElement != null) {
            NamedNodeMap map = this.ownerElement.getAttributes();
            Hashtable<String, Boolean> table = new Hashtable<String, Boolean>();
            Hashtable<String, Boolean> prefixTable = new Hashtable<String, Boolean>();
            int mapLength = map.getLength();
            int i = 0;
            while (i < mapLength) {
                Attr attribute = (Attr)map.item(i);
                String attributeName = attribute.getName();
                if (attributeName.startsWith("xmlns:")) {
                    table.put(attribute.getValue(), Boolean.TRUE);
                    prefixTable.put(attributeName.substring(6), Boolean.TRUE);
                } else if (attributeName.equals("xmlns")) {
                    table.put(attribute.getValue(), Boolean.TRUE);
                    prefixTable.put("", Boolean.TRUE);
                }
                ++i;
            }
            i = 0;
            while (i < this.namespaceNames.length) {
                String namespace = this.namespaceNames[i];
                if (table.get(namespace) == null) {
                    String prefix;
                    String string = prefix = i < this.preferredPrefixes.length ? this.preferredPrefixes[i] : "p0";
                    if (prefixTable.get(prefix) != null) {
                        prefix = this.computeUniquePrefix("p", prefixTable);
                    }
                    String attributeName = prefix.length() > 0 ? "xmlns:" + prefix : "xmlns";
                    this.ownerElement.setAttribute(attributeName, namespace);
                }
                ++i;
            }
        }
    }

    protected String computeUniquePrefix(String base, Hashtable table) {
        int i = 0;
        String prefix = base;
        while (table.get(prefix) != null) {
            prefix = String.valueOf(base) + i;
            ++i;
        }
        return prefix;
    }
}

