/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.util;

import org.eclipse.wst.common.ui.internal.UIPlugin;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;

public class ValidateHelper {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String checkXMLLang(String lang) {
        char ch;
        int offset;
        if (lang.length() == 0) {
            return null;
        }
        if (lang.length() == 1) {
            char ch0 = lang.charAt(0);
            if ((ch0 < 'a' || ch0 > 'z') && (ch0 < 'A' || ch0 > 'Z')) return String.valueOf(UIPlugin.getResourceString((String)"_WARN_NAME_INVALID_CHAR")) + ch0 + UIPlugin.getResourceString((String)"_UI_NAME_INVALID_CHAR_END");
            return UIPlugin.getResourceString((String)"_WARN_LANG_TOO_SHORT");
        }
        char ch0 = lang.charAt(0);
        if (lang.charAt(1) == '-') {
            if (ch0 != 'i' && ch0 != 'I' && ch0 != 'x' && ch0 != 'X') return String.valueOf(UIPlugin.getResourceString((String)"_WARN_NAME_INVALID_CHAR")) + ch0 + UIPlugin.getResourceString((String)"_UI_NAME_INVALID_CHAR_END");
            offset = 1;
        } else {
            char ch1 = lang.charAt(1);
            if ((ch0 < 'a' || ch0 > 'z') && (ch0 < 'A' || ch0 > 'Z')) return String.valueOf(UIPlugin.getResourceString((String)"_WARN_NAME_INVALID_CHAR")) + ch0 + UIPlugin.getResourceString((String)"_UI_NAME_INVALID_CHAR_END");
            if ((ch1 < 'a' || ch1 > 'z') && (ch1 < 'A' || ch1 > 'Z')) return String.valueOf(UIPlugin.getResourceString((String)"_WARN_NAME_INVALID_CHAR")) + ch1 + UIPlugin.getResourceString((String)"_UI_NAME_INVALID_CHAR_END");
            offset = 2;
        }
        if (lang.length() <= offset) return null;
        if ((ch = lang.charAt(offset++)) != '-') {
            return String.valueOf(UIPlugin.getResourceString((String)"_WARN_HYPHEN_NEEDED")) + Integer.toString(offset - 1);
        }
        while (true) {
            if (ch == '-') {
                if (lang.length() == offset) {
                    return UIPlugin.getResourceString((String)"_WARN_HYPHEN_ENDING");
                }
                if (!((ch = lang.charAt(offset++)) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z')) {
                    return String.valueOf(UIPlugin.getResourceString((String)"_WARN_NAME_INVALID_CHAR")) + ch + UIPlugin.getResourceString((String)"_UI_NAME_INVALID_CHAR_END");
                }
                if (lang.length() == offset) {
                    return null;
                }
            } else {
                if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z')) {
                    return String.valueOf(UIPlugin.getResourceString((String)"_WARN_NAME_INVALID_CHAR")) + ch + UIPlugin.getResourceString((String)"_UI_NAME_INVALID_CHAR_END");
                }
                if (lang.length() == offset) {
                    return null;
                }
            }
            ch = lang.charAt(offset++);
        }
    }

    public static String isValidMinValue(String minValue, String maxValue) {
        int min;
        if (minValue == null || minValue.equals("")) {
            return null;
        }
        try {
            min = Integer.parseInt(minValue);
        }
        catch (NumberFormatException numberFormatException) {
            return UIPlugin.getResourceString((String)"_ERROR_MIN_NOT_POSITIVE");
        }
        if (min < 0) {
            return UIPlugin.getResourceString((String)"_ERROR_MIN_NOT_POSITIVE");
        }
        try {
            int max = Integer.parseInt(maxValue);
            if (min > max) {
                return UIPlugin.getResourceString((String)"_ERROR_MIN_VALUE");
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return null;
    }

    public static String isValidMaxValue(String maxValue, String minValue) {
        int max;
        if (maxValue == null || maxValue.equals("")) {
            return null;
        }
        if (maxValue.equals("unbounded")) {
            return null;
        }
        try {
            max = Integer.parseInt(maxValue);
        }
        catch (NumberFormatException numberFormatException) {
            return UIPlugin.getResourceString((String)"_ERROR_MAX_NOT_POSITIVE");
        }
        if (max < 0) {
            return UIPlugin.getResourceString((String)"_ERROR_MAX_NOT_POSITIVE");
        }
        try {
            int min = Integer.parseInt(minValue);
            if (max < min) {
                return UIPlugin.getResourceString((String)"_ERROR_MAX_VALUE");
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String checkXMLName(String name, boolean allowEntityRef) {
        int length = name.length();
        if (length == 0) {
            return WSDLEditorPlugin.getWSDLString("_WARN_NAME_MUST_CONTAIN_AT_LEAST_ONE_CHAR");
        }
        if (name.indexOf(" ") >= 0) {
            return WSDLEditorPlugin.getWSDLString("_WARN_NAME_HAS_SPACE");
        }
        int index = 0;
        if (length > 0 && name.charAt(0) == '%') {
            if (!allowEntityRef) {
                return WSDLEditorPlugin.getWSDLString("_WARN_NAME_INVALID_FIRST");
            }
            ++index;
        }
        while (index < length) {
            char character = name.charAt(index);
            if (index == 0) {
                if (!ValidateHelper.isXMLNameStart(character)) {
                    return WSDLEditorPlugin.getWSDLString("_WARN_NAME_INVALID_FIRST");
                }
            } else if (!(ValidateHelper.isXMLNameChar(character) || index == length - 1 && allowEntityRef && character == ';')) {
                return String.valueOf(WSDLEditorPlugin.getWSDLString("_WARN_NAME_INVALID_CHAR")) + character + WSDLEditorPlugin.getWSDLString("_UI_NAME_INVALID_CHAR_END");
            }
            ++index;
        }
        return null;
    }

    public static String checkXMLName(String name) {
        return ValidateHelper.checkXMLName(name, false);
    }

    private static boolean isXMLNameStart(char ch) {
        return ch == '_' || ch == ':' || Character.isLetter(ch);
    }

    private static boolean isXMLNameChar(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '.' || ch == '-' || ch == '_' || ch == ':';
    }

    private static boolean isXMLPrefixStart(char ch) {
        return ch == '_' || Character.isLetter(ch);
    }

    private static boolean isXMLPrefixChar(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '.' || ch == '-' || ch == '_';
    }

    public static String parseElementText(String text) {
        if (text.indexOf(60) != -1 || text.indexOf(62) != -1) {
            return UIPlugin.getResourceString((String)"_WARN_ELEMENT_INVALID_CHAR");
        }
        return null;
    }

    public static String parseAttributeValue(String value) {
        if (value.indexOf(34) != -1 || value.indexOf(60) != -1 || value.indexOf(62) != -1) {
            return UIPlugin.getResourceString((String)"_WARN_ATTRIBUTE_INVALID_CHAR");
        }
        return null;
    }

    public static String parseCDATASection(String section) {
        if (section.indexOf("]]>") != -1) {
            return UIPlugin.getResourceString((String)"_WARN_CDATA_INVALID_STRING");
        }
        return null;
    }

    public static String parseProcessingInstructionData(String data) {
        if (data.indexOf("?>") != -1) {
            return UIPlugin.getResourceString((String)"_WARN_PROCESSING_INVALID_STRING");
        }
        return null;
    }

    public static String parseProcessingInstructionTarget(String target) {
        if (target.length() == 3 && (target.indexOf("XML") != -1 || target.indexOf("XMl") != -1 || target.indexOf("XmL") != -1 || target.indexOf("xML") != -1 || target.indexOf("Xml") != -1 || target.indexOf("xMl") != -1 || target.indexOf("xmL") != -1 || target.indexOf("xml") != -1)) {
            return UIPlugin.getResourceString((String)"_WARN_PROCESSING_TARGET_INVALID_STRING");
        }
        return ValidateHelper.checkXMLName(target);
    }

    public static String parseComment(String comment) {
        if (comment.indexOf("--") != -1) {
            return UIPlugin.getResourceString((String)"_WARN_COMMENT_INVALID_STRING");
        }
        return null;
    }

    public static String checkXMLPrefix(String prefix) {
        int length = prefix.length();
        if (length == 0) {
            return null;
        }
        if (prefix.indexOf(" ") >= 0) {
            return UIPlugin.getResourceString((String)"_WARN_PREFIX_HAS_SPACE");
        }
        int index = 0;
        while (index < length) {
            char character = prefix.charAt(index);
            if (!ValidateHelper.isXMLPrefixChar(character)) {
                UIPlugin.getDefault();
                return UIPlugin.getString((String)"_WARN_PREFIX_INVALID_CHAR", (Object)String.valueOf(character));
            }
            ++index;
        }
        return null;
    }
}

