/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.util.ui;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.wst.common.ui.internal.UIPlugin;

public abstract class BaseDesignWindow
extends Viewer {
    private Font font;
    protected ScrolledComposite mainUIComponent;
    protected Composite controlsContainer;
    protected boolean pageComplete = true;
    protected Object input;
    private IStatusLineManager statusLine;
    private String currentMessage = "";

    public BaseDesignWindow(IStatusLineManager statusLine) {
        this.statusLine = statusLine;
    }

    protected void setStatusLine(IStatusLineManager statusLine) {
        this.statusLine = statusLine;
    }

    protected IStatusLineManager getStatusLine() {
        if (this.statusLine == null) {
            IWorkbench workbench = UIPlugin.getDefault().getWorkbench();
            IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
            IEditorPart editorPart = workbenchWindow.getActivePage().getActiveEditor();
            try {
                EditorActionBarContributor contributor = (EditorActionBarContributor)editorPart.getEditorSite().getActionBarContributor();
                this.statusLine = contributor.getActionBars().getStatusLineManager();
            }
            catch (Exception exception) {}
        }
        return this.statusLine;
    }

    public Object getInput() {
        return this.input;
    }

    public void setInput(Object input) {
        if (this.input != input) {
            this.setErrorMessage("");
        }
        this.input = input;
    }

    public ISelection getSelection() {
        return null;
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    public void refresh() {
    }

    protected Control createDesignPane(Composite parent, int numColumns) {
        this.mainUIComponent = new ScrolledComposite(parent, 768){

            public void setVisible(boolean visible) {
                super.setVisible(visible);
                if (!visible && !BaseDesignWindow.this.currentMessage.equals("")) {
                    BaseDesignWindow.this.showMessageInStatusLine(visible);
                }
            }
        };
        this.controlsContainer = new Composite((Composite)this.mainUIComponent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        this.controlsContainer.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        this.controlsContainer.setLayoutData((Object)data);
        this.mainUIComponent.setContent((Control)this.controlsContainer);
        return this.mainUIComponent;
    }

    public void setScrollComposite() {
        Point p = this.controlsContainer.computeSize(-1, -1);
        this.mainUIComponent.setExpandHorizontal(true);
        this.mainUIComponent.setExpandVertical(true);
        this.mainUIComponent.setMinSize(p);
    }

    public Composite getControlsContainer() {
        return this.controlsContainer;
    }

    public void setPageComplete(boolean complete) {
        this.pageComplete = complete;
    }

    public boolean isPageComplete() {
        return this.pageComplete;
    }

    protected void showMessageInStatusLine(boolean show) {
        if (this.getStatusLine() == null) {
            return;
        }
        if (show) {
            this.getStatusLine().setErrorMessage(this.currentMessage);
        } else {
            this.getStatusLine().setErrorMessage("");
        }
        this.getStatusLine().update(false);
    }

    public void setMessage(String message) {
        this.currentMessage = message;
        if (this.getStatusLine() != null) {
            this.getStatusLine().setErrorMessage(this.currentMessage);
            this.getStatusLine().update(false);
        }
    }

    public void clearMessage() {
        this.currentMessage = "";
        if (this.getStatusLine() != null) {
            this.getStatusLine().setErrorMessage(this.currentMessage);
            this.getStatusLine().update(false);
        }
    }

    public void setErrorMessage(String message) {
        this.setMessage(message);
        this.setPageComplete(false);
    }

    public void clearErrorMessage() {
        this.clearMessage();
        this.setPageComplete(true);
    }

    public String getErrorMessage() {
        return this.currentMessage;
    }
}

