/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.viewers;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditor;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.actions.SmartRenameAction;
import org.eclipse.wst.wsdl.ui.internal.model.ModelAdapterListener;
import org.eclipse.wst.wsdl.ui.internal.model.WSDLModelAdapterFactory;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.eclipse.wst.wsdl.ui.internal.viewers.BaseViewer;
import org.eclipse.wst.wsdl.ui.internal.viewers.TabbedViewer;
import org.w3c.dom.Element;

public abstract class NamedComponentViewer
extends BaseViewer
implements ModelAdapterListener {
    protected Composite control;
    protected Text nameField;
    protected IEditorPart editorPart;

    public NamedComponentViewer(Composite parent, IEditorPart editorPart) {
        super(NamedComponentViewer.getStatusLineManager(editorPart));
        this.editorPart = editorPart;
        this.createControl(parent);
    }

    protected abstract String getHeadingText();

    protected Composite populatePrimaryDetailsSection(Composite parent) {
        Composite group = this.flatViewUtility.createComposite(parent, 2, true);
        group.setLayoutData((Object)new GridData(768));
        Composite nameFieldComposite = this.flatViewUtility.createComposite(group, 2, true);
        ((GridLayout)nameFieldComposite.getLayout()).marginWidth = 0;
        ((GridLayout)nameFieldComposite.getLayout()).marginHeight = 0;
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = false;
        layout.numColumns = 3;
        layout.marginHeight = 4;
        layout.marginWidth = 0;
        nameFieldComposite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.verticalAlignment = 1;
        nameFieldComposite.setLayoutData((Object)gd);
        this.flatViewUtility.createLabel(nameFieldComposite, 0, WSDLEditorPlugin.getWSDLString("_UI_LABEL_NAME"));
        this.nameField = this.flatViewUtility.createTextField(nameFieldComposite);
        this.nameField.addListener(24, (Listener)this);
        Label c = this.flatViewUtility.createLabel(nameFieldComposite, 0, "");
        c.setBackground(new Color(null, 0, 255, 100));
        gd = new GridData();
        gd.grabExcessHorizontalSpace = false;
        gd.heightHint = 0;
        gd.widthHint = 0;
        c.setLayoutData((Object)gd);
        return nameFieldComposite;
    }

    public void createControl(Composite parent) {
        SashForm sashForm = new SashForm(parent, 2048);
        sashForm.setLayoutData((Object)new GridData(1808));
        this.control = sashForm;
        sashForm.setOrientation(256);
        Composite composite = this.flatViewUtility.createComposite((Composite)sashForm, 1, true);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.flatViewUtility.createFlatPageHeader(composite, this.getHeadingText());
        this.populatePrimaryDetailsSection(composite);
        TabbedViewer tabbedViewer = new TabbedViewer((WSDLEditor)this.editorPart);
        Control c = tabbedViewer.createControl((Composite)sashForm);
        c.setLayoutData((Object)new GridData(1808));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSetInput(Object input) {
        this.setListenerEnabled(false);
        try {
            WSDLEditorUtil.getInstance().getNodeForObject(input);
            this.update();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.setListenerEnabled(true);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.setListenerEnabled(true);
        if (oldInput != null) {
            WSDLModelAdapterFactory.getWSDLModelAdapterFactory();
            WSDLModelAdapterFactory.removeModelAdapterListener(oldInput, this);
        }
        WSDLModelAdapterFactory.getWSDLModelAdapterFactory();
        WSDLModelAdapterFactory.addModelAdapterListener(input, this);
        oldInput = input;
    }

    protected void update() {
        Element element = ((WSDLElement)this.input).getElement();
        this.flatViewUtility.updateFlatPageHeaderTitle(this.getHeadingText());
        this.nameField.setText("");
        String nameValue = element.getAttribute("name");
        this.nameField.setText(nameValue != null ? nameValue : "");
    }

    public Control getControl() {
        return this.control;
    }

    public void doHandleEvent(Event event) {
        this.setListenerEnabled(false);
        Element element = WSDLEditorUtil.getInstance().getElementForObject(this.input);
        this.handleEventHelper(element, event);
        this.setListenerEnabled(true);
    }

    protected void handleEventHelper(Element element, Event event) {
        if (event.type == 24 && event.widget == this.nameField) {
            new SmartRenameAction(this.input, this.nameField.getText()).run();
        }
    }

    public void propertyChanged(Object object, String property) {
        if (this.isListenerEnabled()) {
            this.setListenerEnabled(false);
            if (!this.control.isDisposed()) {
                this.update();
            }
            this.setListenerEnabled(true);
        }
    }
}

