/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.preferences;

import java.text.MessageFormat;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.preferences.DebugPreferencesMessages;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class LaunchingPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public LaunchingPreferencePage() {
        super(1);
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        this.setPreferenceStore(store);
        this.setDescription(DebugPreferencesMessages.LaunchingPreferencePage_20);
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new BooleanFieldEditor(IDebugUIConstants.PREF_BUILD_BEFORE_LAUNCH, DebugPreferencesMessages.LaunchingPreferencePage_1, 0, this.getFieldEditorParent()));
        this.createSaveBeforeLaunchEditors();
        this.createWaitForBuildEditor();
        this.createSpacer(this.getFieldEditorParent(), 2);
        this.addField((FieldEditor)new BooleanFieldEditor(IDebugUIConstants.PREF_AUTO_REMOVE_OLD_LAUNCHES, DebugPreferencesMessages.LaunchingPreferencePage_10, 0, this.getFieldEditorParent()));
        this.createSwitchPerspectiveEditor();
        this.createRelaunchInDebugMode();
        this.createContinueWithCompileErrors();
        this.createLaunchHistoryEditor();
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }

    private void createLaunchHistoryEditor() {
        final IntegerFieldEditor editor = new IntegerFieldEditor(IDebugUIConstants.PREF_MAX_HISTORY_SIZE, DebugPreferencesMessages.DebugPreferencePage_10, this.getFieldEditorParent());
        int historyMax = 20;
        editor.setTextLimit(Integer.toString(historyMax).length());
        editor.setErrorMessage(MessageFormat.format(DebugPreferencesMessages.DebugPreferencePage_11, new Integer(1), new Integer(historyMax)));
        editor.setValidateStrategy(0);
        editor.setValidRange(1, historyMax);
        editor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_is_valid")) {
                    LaunchingPreferencePage.this.setValid(editor.isValid());
                }
            }
        });
        this.addField((FieldEditor)editor);
    }

    private void createSaveBeforeLaunchEditors() {
        this.addField((FieldEditor)new RadioGroupFieldEditor(IInternalDebugUIConstants.PREF_SAVE_DIRTY_EDITORS_BEFORE_LAUNCH, DebugPreferencesMessages.LaunchingPreferencePage_2, 3, (String[][])new String[][]{{DebugPreferencesMessages.LaunchingPreferencePage_3, "always"}, {DebugPreferencesMessages.LaunchingPreferencePage_4, "never"}, {DebugPreferencesMessages.LaunchingPreferencePage_5, "prompt"}}, this.getFieldEditorParent(), true));
    }

    private void createWaitForBuildEditor() {
        this.addField((FieldEditor)new RadioGroupFieldEditor(IInternalDebugUIConstants.PREF_WAIT_FOR_BUILD, DebugPreferencesMessages.LaunchingPreferencePage_6, 3, (String[][])new String[][]{{DebugPreferencesMessages.LaunchingPreferencePage_7, "always"}, {DebugPreferencesMessages.LaunchingPreferencePage_8, "never"}, {DebugPreferencesMessages.LaunchingPreferencePage_9, "prompt"}}, this.getFieldEditorParent(), true));
    }

    private void createSwitchPerspectiveEditor() {
        this.addField((FieldEditor)new RadioGroupFieldEditor(IInternalDebugUIConstants.PREF_SWITCH_TO_PERSPECTIVE, DebugPreferencesMessages.LaunchingPreferencePage_11, 3, (String[][])new String[][]{{DebugPreferencesMessages.LaunchingPreferencePage_12, "always"}, {DebugPreferencesMessages.LaunchingPreferencePage_13, "never"}, {DebugPreferencesMessages.LaunchingPreferencePage_14, "prompt"}}, this.getFieldEditorParent(), true));
    }

    private void createRelaunchInDebugMode() {
        this.addField((FieldEditor)new RadioGroupFieldEditor(IInternalDebugUIConstants.PREF_RELAUNCH_IN_DEBUG_MODE, DebugPreferencesMessages.LaunchingPreferencePage_15, 3, (String[][])new String[][]{{DebugPreferencesMessages.LaunchingPreferencePage_16, "always"}, {DebugPreferencesMessages.LaunchingPreferencePage_17, "never"}, {DebugPreferencesMessages.LaunchingPreferencePage_18, "prompt"}}, this.getFieldEditorParent(), true));
    }

    private void createContinueWithCompileErrors() {
        this.addField((FieldEditor)new RadioGroupFieldEditor(IInternalDebugUIConstants.PREF_CONTINUE_WITH_COMPILE_ERROR, DebugPreferencesMessages.LaunchingPreferencePage_21, 2, (String[][])new String[][]{{DebugPreferencesMessages.LaunchingPreferencePage_22, "always"}, {DebugPreferencesMessages.LaunchingPreferencePage_23, "prompt"}}, this.getFieldEditorParent(), true));
    }

    public void init(IWorkbench workbench) {
    }
}

