/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.debug.core.IMemoryBlockListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.IMemoryView;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewPane;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.ViewPaneSelectionProvider;
import org.eclipse.debug.internal.ui.views.memory.ViewTabEnablementManager;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractMemoryViewPane
implements IMemoryBlockListener,
ISelectionListener,
SelectionListener,
IMemoryView,
ISelectionChangedListener,
IMemoryViewPane {
    public static final String BEGINNING_POPUP = "popUpBegin";
    protected static final StructuredSelection EMPTY = new StructuredSelection();
    protected Composite fViewPaneCanvas;
    protected StackLayout fStackLayout;
    protected ViewTabEnablementManager fViewTabEnablementManager;
    protected TabFolder fEmptyTabFolder;
    protected Hashtable fTabFolderForDebugView = new Hashtable();
    protected boolean fVisible;
    protected Hashtable fRenderingInfoTable;
    protected IMemoryBlockRetrieval fKey;
    protected ViewPaneSelectionProvider fSelectionProvider;
    protected IViewPart fParent;
    protected String fPaneId;
    private Composite fCanvas;
    protected String fLabel;
    static /* synthetic */ Class class$0;

    public AbstractMemoryViewPane(IViewPart parent) {
        this.fParent = parent;
        this.fSelectionProvider = new ViewPaneSelectionProvider();
    }

    public Control createViewPane(Composite parent, String paneId, String label) {
        Composite subCanvas;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".MemoryView_context");
        this.fPaneId = paneId;
        this.fLabel = label;
        this.fCanvas = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = false;
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 1;
        data.horizontalAlignment = 1;
        this.fCanvas.setLayout((Layout)layout);
        this.fCanvas.setLayoutData((Object)data);
        Composite memoryViewAreaParent = this.fCanvas;
        this.fViewPaneCanvas = subCanvas = new Composite(memoryViewAreaParent, 0);
        this.fStackLayout = new StackLayout();
        GridData memoryAreaData = new GridData();
        memoryAreaData.grabExcessHorizontalSpace = true;
        memoryAreaData.grabExcessVerticalSpace = true;
        memoryAreaData.verticalAlignment = 4;
        memoryAreaData.horizontalAlignment = 4;
        this.fViewPaneCanvas.setLayout((Layout)this.fStackLayout);
        this.fViewPaneCanvas.setLayoutData((Object)memoryAreaData);
        this.fViewTabEnablementManager = new ViewTabEnablementManager();
        this.fEmptyTabFolder = new TabFolder(this.fViewPaneCanvas, 0);
        this.setTabFolder(this.fEmptyTabFolder);
        this.addListeners();
        ISelection selection = this.fParent.getViewSite().getPage().getSelection("org.eclipse.debug.ui.DebugView");
        if (MemoryViewUtil.isValidSelection(selection)) {
            this.createFolder(selection);
        }
        this.fVisible = true;
        return this.fCanvas;
    }

    protected void addListeners() {
        MemoryViewUtil.getMemoryBlockManager().addListener((IMemoryBlockListener)this);
        this.fParent.getViewSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    protected void removeListeners() {
        TabFolder old;
        MemoryViewUtil.getMemoryBlockManager().removeListener((IMemoryBlockListener)this);
        this.fParent.getViewSite().getPage().removeSelectionListener((ISelectionListener)this);
        if (this.fStackLayout.topControl != null && !(old = (TabFolder)this.fStackLayout.topControl).isDisposed()) {
            old.removeSelectionListener((SelectionListener)this);
            old.removeSelectionListener((SelectionListener)this.fViewTabEnablementManager);
        }
    }

    protected void setTabFolder(TabFolder folder) {
        TabFolder old;
        if (this.fStackLayout.topControl != null && !(old = (TabFolder)this.fStackLayout.topControl).isDisposed()) {
            old.removeSelectionListener((SelectionListener)this);
            old.removeSelectionListener((SelectionListener)this.fViewTabEnablementManager);
        }
        this.fStackLayout.topControl = folder;
        if (folder.getItemCount() > 0) {
            TabItem[] selectedItem = folder.getSelection();
            if (selectedItem.length > 0) {
                Object selected = this.getCurrentSelection();
                if (selected != null) {
                    this.fSelectionProvider.setSelection((ISelection)new StructuredSelection(selected));
                } else {
                    this.fSelectionProvider.setSelection((ISelection)EMPTY);
                }
            }
        } else {
            this.fSelectionProvider.setSelection((ISelection)EMPTY);
        }
        folder.addSelectionListener((SelectionListener)this);
        folder.addSelectionListener((SelectionListener)this.fViewTabEnablementManager);
    }

    private void createFolder(ISelection selection) {
        IMemoryBlockRetrieval memRetrieval;
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        if (selection == null || selection.isEmpty() || ((IStructuredSelection)selection).size() > 1) {
            return;
        }
        Object elem = ((IStructuredSelection)selection).getFirstElement();
        if (!(elem instanceof IDebugElement)) {
            return;
        }
        IDebugTarget debugTarget = ((IDebugElement)elem).getDebugTarget();
        IDebugElement iDebugElement = (IDebugElement)elem;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((memRetrieval = (IMemoryBlockRetrieval)iDebugElement.getAdapter((Class)clazz)) == null) {
            memRetrieval = debugTarget;
        }
        if (memRetrieval == null) {
            return;
        }
        if (this.fTabFolderForDebugView.containsKey(memRetrieval)) {
            if (this.fStackLayout.topControl != (TabFolder)this.fTabFolderForDebugView.get(memRetrieval)) {
                this.setTabFolder((TabFolder)this.fTabFolderForDebugView.get(memRetrieval));
                this.fViewPaneCanvas.layout();
            }
        } else {
            this.fTabFolderForDebugView.put(memRetrieval, new TabFolder(this.fViewPaneCanvas, 0));
            this.setTabFolder((TabFolder)this.fTabFolderForDebugView.get(memRetrieval));
            this.fViewPaneCanvas.layout();
        }
    }

    public IMemoryViewTab getTopMemoryTab() {
        int index;
        TabFolder folder;
        if (this.fStackLayout.topControl instanceof TabFolder && !(folder = (TabFolder)this.fStackLayout.topControl).isDisposed() && (index = folder.getSelectionIndex()) >= 0) {
            TabItem tab = folder.getItem(index);
            return (IMemoryViewTab)tab.getData();
        }
        return null;
    }

    protected void disposeTab(TabItem tabItem) {
        if (tabItem == null) {
            return;
        }
        if (!tabItem.isDisposed()) {
            tabItem.dispose();
        }
    }

    protected void emptyFolder() {
        this.setTabFolder(this.fEmptyTabFolder);
        if (!this.fViewPaneCanvas.isDisposed()) {
            this.fViewPaneCanvas.layout();
        }
    }

    public void addSelectionListener(ISelectionChangedListener listener) {
        if (this.fSelectionProvider == null) {
            this.fSelectionProvider = new ViewPaneSelectionProvider();
        }
        this.fSelectionProvider.addSelectionChangedListener(listener);
    }

    public void removeSelctionListener(ISelectionChangedListener listener) {
        if (this.fSelectionProvider == null) {
            return;
        }
        this.fSelectionProvider.removeSelectionChangedListener(listener);
    }

    public ISelectionProvider getSelectionProvider() {
        return this.fSelectionProvider;
    }

    public void dispose() {
        this.removeListeners();
        this.fEmptyTabFolder.dispose();
        try {
            if (this.fTabFolderForDebugView != null) {
                Enumeration enumeration = this.fTabFolderForDebugView.elements();
                while (enumeration.hasMoreElements()) {
                    TabFolder tabFolder = (TabFolder)enumeration.nextElement();
                    if (tabFolder.isDisposed()) continue;
                    TabItem[] tabs = tabFolder.getItems();
                    int i = 0;
                    while (i < tabs.length) {
                        this.disposeTab(tabs[i]);
                        ++i;
                    }
                    tabFolder.dispose();
                }
                this.fTabFolderForDebugView.clear();
                this.fTabFolderForDebugView = null;
            }
        }
        catch (Exception exception) {
            DebugUIPlugin.logErrorMessage("Exception occurred when the Memory View is disposed.");
        }
    }

    public void setVisible(boolean visible) {
        this.fVisible = visible;
        IMemoryViewTab currentTab = this.getTopMemoryTab();
        if (currentTab != null) {
            currentTab.setEnabled(visible);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        this.selectionChanged((IWorkbenchPart)this.fParent, selection);
        this.fSelectionProvider.setSelection(selection);
    }

    public String getPaneId() {
        return this.fPaneId;
    }

    public Control getControl() {
        return this.fCanvas;
    }

    public boolean isVisible() {
        return this.fVisible;
    }

    public String getLabel() {
        return this.fLabel;
    }

    public abstract void memoryBlocksAdded(IMemoryBlock[] var1);

    public abstract void memoryBlocksRemoved(IMemoryBlock[] var1);

    public abstract void selectionChanged(IWorkbenchPart var1, ISelection var2);

    public abstract Object getCurrentSelection();

    public abstract void restoreViewPane();

    public abstract IAction[] getActions();
}

