/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallChangedListener;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.launching.PropertyChangeEvent;

public class JREContainer
implements IClasspathContainer {
    private IVMInstall fVMInstall = null;
    private IPath fPath = null;
    private static Map fgClasspathEntries = null;
    private static IAccessRule[] EMPTY_RULES = new IAccessRule[0];

    private static IClasspathEntry[] getClasspathEntries(IVMInstall vm) {
        IClasspathEntry[] entries;
        if (fgClasspathEntries == null) {
            fgClasspathEntries = new HashMap(10);
            IVMInstallChangedListener listener = new IVMInstallChangedListener(){

                public void defaultVMInstallChanged(IVMInstall previous, IVMInstall current) {
                }

                public void vmChanged(PropertyChangeEvent event) {
                    if (event.getSource() != null) {
                        fgClasspathEntries.remove(event.getSource());
                    }
                }

                public void vmAdded(IVMInstall newVm) {
                }

                public void vmRemoved(IVMInstall removedVm) {
                    fgClasspathEntries.remove(removedVm);
                }
            };
            JavaRuntime.addVMInstallChangedListener(listener);
        }
        if ((entries = (IClasspathEntry[])fgClasspathEntries.get(vm)) == null) {
            entries = JREContainer.computeClasspathEntries(vm);
            fgClasspathEntries.put(vm, entries);
        }
        return entries;
    }

    private static IClasspathEntry[] computeClasspathEntries(IVMInstall vm) {
        LibraryLocation[] libs = JavaRuntime.getLibraryLocations(vm);
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>(libs.length);
        int i = 0;
        while (i < libs.length) {
            if (!libs[i].getSystemLibraryPath().isEmpty()) {
                URL javadocLocation;
                IPath rootPath;
                IPath sourcePath = libs[i].getSystemLibrarySourcePath();
                if (sourcePath.isEmpty()) {
                    sourcePath = null;
                }
                if ((rootPath = libs[i].getPackageRootPath()).isEmpty()) {
                    rootPath = null;
                }
                if ((javadocLocation = libs[i].getJavadocLocation()) == null) {
                    javadocLocation = vm.getJavadocLocation();
                }
                IClasspathAttribute[] attributes = null;
                attributes = javadocLocation == null ? new IClasspathAttribute[]{} : new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"javadoc_location", (String)javadocLocation.toExternalForm())};
                entries.add(JavaCore.newLibraryEntry((IPath)libs[i].getSystemLibraryPath(), (IPath)sourcePath, (IPath)rootPath, (IAccessRule[])EMPTY_RULES, (IClasspathAttribute[])attributes, (boolean)false));
            }
            ++i;
        }
        return entries.toArray(new IClasspathEntry[entries.size()]);
    }

    public JREContainer(IVMInstall vm, IPath path) {
        this.fVMInstall = vm;
        this.fPath = path;
    }

    public IClasspathEntry[] getClasspathEntries() {
        return JREContainer.getClasspathEntries(this.fVMInstall);
    }

    public String getDescription() {
        StringBuffer desc = new StringBuffer(LaunchingMessages.JREContainer_JRE_System_Library_1);
        desc.append(" [");
        desc.append(this.fVMInstall.getName());
        desc.append("]");
        return desc.toString();
    }

    public int getKind() {
        return 3;
    }

    public IPath getPath() {
        return this.fPath;
    }
}

