/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.text;

import java.util.Locale;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.wst.sse.core.internal.parser.ForeignRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredTextPartitioner;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.text.rules.IStructuredTypedRegion;
import org.eclipse.wst.sse.core.internal.util.ScriptLanguageKeys;
import org.eclipse.wst.sse.core.internal.util.StringUtils;
import org.eclipse.wst.xml.core.internal.text.rules.StructuredTextPartitionerForXML;

public class StructuredTextPartitionerForHTML
extends StructuredTextPartitionerForXML
implements IStructuredTextPartitioner {
    private static final String[] configuredContentTypes = new String[]{"org.eclipse.wst.html.HTML_DEFAULT", "org.eclipse.wst.html.HTML_DECLARATION", "org.eclipse.wst.html.HTML_COMMENT", "org.eclipse.wst.html.SCRIPT", "org.eclipse.wst.css.STYLE"};
    public static final String JAVASCRIPT = "javascript";
    public static final String JAVASCRIPT_APPLICATION = "application/x-javascript";

    public IStructuredTypedRegion createPartition(int offset, int length, String type) {
        IStructuredDocumentRegion node;
        if (type == "org.eclipse.wst.html.SCRIPT" && (node = this.structuredDocument.getRegionAtCharacterOffset(offset)) != null) {
            String stype = this.getScriptingPartitionType(node);
            return super.createPartition(offset, length, stype);
        }
        return super.createPartition(offset, length, type);
    }

    protected void setInternalPartition(int offset, int length, String type) {
        IStructuredDocumentRegion node;
        String localType = type;
        if (type == "org.eclipse.wst.html.SCRIPT" && (node = this.structuredDocument.getRegionAtCharacterOffset(offset)) != null) {
            localType = this.getScriptingPartitionType(node);
        }
        super.setInternalPartition(offset, length, localType);
    }

    private String getScriptingPartitionType(IStructuredDocumentRegion coreNode) {
        ITextRegion potentialLanguageRegion;
        String potentialLanguageString;
        String language = null;
        String type = null;
        String result = "org.eclipse.wst.html.SCRIPT";
        IStructuredDocumentRegion node = coreNode;
        ITextRegion attrNameRegion = null;
        while (node != null && this.isValidScriptingRegionType(node.getType())) {
            node = node.getPrevious();
        }
        ITextRegionList regions = node.getRegions();
        if (regions.size() > 4 && regions.get(1).getType() == "XML_TAG_NAME" && (potentialLanguageString = node.getText(potentialLanguageRegion = regions.get(1))).equalsIgnoreCase("SCRIPT")) {
            int i = 0;
            while (i < regions.size()) {
                ITextRegion region = regions.get(i);
                String regionType = region.getType();
                if (regionType == "XML_TAG_ATTRIBUTE_NAME") {
                    attrNameRegion = region;
                } else if (regionType == "XML_TAG_ATTRIBUTE_VALUE") {
                    String attrName = node.getText(attrNameRegion);
                    if (attrName.equalsIgnoreCase("language")) {
                        language = StringUtils.strip((String)node.getText(region));
                    } else if (attrName.equalsIgnoreCase("type")) {
                        type = StringUtils.strip((String)node.getText(region));
                        break;
                    }
                    attrNameRegion = null;
                }
                ++i;
            }
        }
        if (type != null) {
            result = this.lookupScriptType(type);
        } else if (language != null) {
            result = this.lookupScriptLanguage(language);
        }
        return result;
    }

    private boolean isValidScriptingRegionType(String type) {
        return type == "BLOCK_TEXT" || type == "XML_CDATA_OPEN" || type == "XML_CDATA_TEXT" || type == "XML_CDATA_CLOSE";
    }

    protected void initLegalContentTypes() {
        this.fSupportedTypes = StructuredTextPartitionerForHTML.getConfiguredContentTypes();
    }

    private String lookupScriptType(String type) {
        int i = 0;
        while (i < ScriptLanguageKeys.JAVASCRIPT_MIME_TYPE_KEYS.length) {
            if (ScriptLanguageKeys.JAVASCRIPT_MIME_TYPE_KEYS[i].equalsIgnoreCase(type)) {
                return "org.eclipse.wst.html.SCRIPT";
            }
            ++i;
        }
        return "org.eclipse.wst.html.SCRIPT.type." + type.toUpperCase(Locale.ENGLISH);
    }

    private String lookupScriptLanguage(String language) {
        int i = 0;
        while (i < ScriptLanguageKeys.JAVASCRIPT_LANGUAGE_KEYS.length) {
            if (ScriptLanguageKeys.JAVASCRIPT_LANGUAGE_KEYS[i].equalsIgnoreCase(language)) {
                return "org.eclipse.wst.html.SCRIPT";
            }
            ++i;
        }
        return "org.eclipse.wst.html.SCRIPT.language." + language.toUpperCase(Locale.ENGLISH);
    }

    public String getPartitionType(ITextRegion region, int offset) {
        String result = null;
        result = region.getType() == "XML_COMMENT_TEXT" || region.getType() == "XML_COMMENT_OPEN" ? "org.eclipse.wst.html.HTML_COMMENT" : (region.getType() == "XML_DOCTYPE_DECLARATION" || region.getType() == "XML_DECLARATION_OPEN" ? "org.eclipse.wst.html.HTML_DECLARATION" : super.getPartitionType(region, offset));
        return result;
    }

    public String getPartitionTypeBetween(IStructuredDocumentRegion previousNode, IStructuredDocumentRegion nextNode) {
        ITextRegion previousStartTagNameRegion = null;
        ITextRegion nextEndTagNameRegion = null;
        ITextRegion[] regions = previousNode.getRegions().toArray();
        int i = 0;
        while (i < regions.length) {
            if (regions[i].getType() == "XML_TAG_NAME") {
                previousStartTagNameRegion = regions[i];
                break;
            }
            ++i;
        }
        regions = nextNode.getRegions().toArray();
        i = 0;
        while (i < regions.length) {
            if (regions[i].getType() == "XML_TAG_NAME") {
                nextEndTagNameRegion = regions[i];
                break;
            }
            ++i;
        }
        if (previousStartTagNameRegion == null || nextEndTagNameRegion == null) {
            return "org.eclipse.wst.html.HTML_DEFAULT";
        }
        String name1 = previousNode.getText(previousStartTagNameRegion);
        String name2 = nextNode.getText(nextEndTagNameRegion);
        if (name1.equalsIgnoreCase("SCRIPT") && name2.equalsIgnoreCase("SCRIPT")) {
            return this.getScriptingPartitionType(this.structuredDocument.getRegionAtCharacterOffset(previousNode.getStartOffset(previousStartTagNameRegion)));
        }
        if (name1.equalsIgnoreCase("STYLE") && name2.equalsIgnoreCase("STYLE")) {
            return "org.eclipse.wst.css.STYLE";
        }
        return super.getPartitionTypeBetween(previousNode, nextNode);
    }

    protected String getPartitionType(ForeignRegion region, int offset) {
        String tagname = region.getSurroundingTag();
        String result = null;
        result = tagname == null ? this.getUnknown() : (tagname.equalsIgnoreCase("SCRIPT") ? "org.eclipse.wst.html.SCRIPT" : (tagname.equalsIgnoreCase("STYLE") ? "org.eclipse.wst.css.STYLE" : super.getPartitionType(region, offset)));
        return result;
    }

    public String getDefaultPartitionType() {
        return "org.eclipse.wst.html.HTML_DEFAULT";
    }

    public IDocumentPartitioner newInstance() {
        return new StructuredTextPartitionerForHTML();
    }

    public static String[] getConfiguredContentTypes() {
        return configuredContentTypes;
    }
}

