/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.server.core.internal.IMemento;
import org.eclipse.jst.server.core.internal.JavaServerPlugin;
import org.eclipse.jst.server.core.internal.RuntimeClasspathContainer;
import org.eclipse.jst.server.core.internal.Trace;
import org.eclipse.jst.server.core.internal.XMLMemento;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.model.RuntimeTargetHandlerDelegate;

public abstract class ClasspathRuntimeTargetHandler
extends RuntimeTargetHandlerDelegate {
    private List sourceAttachments;

    public void setRuntimeTarget(IProject project, IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        if (project == null || runtime == null) {
            return;
        }
        IJavaProject javaProject = null;
        try {
            javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
        }
        catch (Exception exception) {}
        if (javaProject == null) {
            return;
        }
        try {
            String[] ids;
            ArrayList<Object> list = new ArrayList<Object>();
            IClasspathEntry[] cp = javaProject.getRawClasspath();
            int size = cp.length;
            int i = 0;
            while (i < size) {
                if (cp[i].getEntryKind() == 5) {
                    if (!cp[i].getPath().segment(0).equals("org.eclipse.jst.server.core.container")) {
                        list.add(cp[i]);
                    }
                } else {
                    list.add(cp[i]);
                }
                ++i;
            }
            ArrayList<IClasspathEntry> add = new ArrayList<IClasspathEntry>();
            IClasspathEntry[] entries = this.getDelegateClasspathEntries(runtime, monitor);
            if (entries != null) {
                size = entries.length;
                int i2 = 0;
                while (i2 < size) {
                    add.add(entries[i2]);
                    ++i2;
                }
            }
            if ((ids = this.getClasspathEntryIds()) != null) {
                size = ids.length;
                int i3 = 0;
                while (i3 < size) {
                    String id2 = this.getRuntimeTargetHandler().getId();
                    IPath path = new Path("org.eclipse.jst.server.core.container").append(id2).append(runtime.getId());
                    if (ids[i3] != null) {
                        path.append(ids[i3]);
                    }
                    add.add(JavaCore.newContainerEntry((IPath)path));
                    String id = "";
                    if (path.segmentCount() > 3) {
                        id = path.segment(3);
                    }
                    RuntimeClasspathContainer rcc = new RuntimeClasspathContainer(path, this, runtime, id);
                    JavaCore.setClasspathContainer((IPath)path, (IJavaProject[])new IJavaProject[]{javaProject}, (IClasspathContainer[])new IClasspathContainer[]{rcc}, (IProgressMonitor)monitor);
                    ++i3;
                }
            }
            this.cleanupDuplicateClasspath(javaProject, list, add);
            Iterator iterator = add.iterator();
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
            cp = new IClasspathEntry[list.size()];
            list.toArray(cp);
            javaProject.setRawClasspath(cp, monitor);
        }
        catch (Exception e) {
            Trace.trace(Trace.WARNING, "Error setting runtime target", e);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.core", 0, e.getLocalizedMessage(), (Throwable)e));
        }
    }

    private void cleanupDuplicateClasspath(IJavaProject project, List current, List add) {
        IClasspathEntry entry;
        if (project == null || current == null || add == null) {
            throw new IllegalArgumentException();
        }
        boolean sourceOnly = true;
        Iterator iterator = current.iterator();
        while (iterator.hasNext()) {
            IClasspathEntry entry2 = (IClasspathEntry)iterator.next();
            if (entry2.getEntryKind() == 3) continue;
            sourceOnly = false;
        }
        if (sourceOnly) {
            return;
        }
        ArrayList<IClasspathEntry> remove = new ArrayList<IClasspathEntry>();
        iterator = current.iterator();
        while (iterator.hasNext()) {
            IClasspathEntry entry3 = (IClasspathEntry)iterator.next();
            if (entry3.getEntryKind() != 5) continue;
            try {
                if (!"org.eclipse.jst.server.core.container".equals(entry3.getPath().segment(0)) && !JavaRuntime.JRE_CONTAINER.equals(entry3.getPath().segment(0))) continue;
                remove.add(entry3);
            }
            catch (Exception e) {
                Trace.trace(Trace.FINEST, "Error resolving classpath container", e);
            }
        }
        ArrayList<IClasspathEntry> addExpanded = new ArrayList<IClasspathEntry>();
        iterator = add.iterator();
        while (iterator.hasNext()) {
            entry = (IClasspathEntry)iterator.next();
            if (entry.getEntryKind() == 5) {
                try {
                    IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project);
                    IClasspathEntry[] entries = container.getClasspathEntries();
                    int size = entries.length;
                    int i = 0;
                    while (i < size) {
                        if (entries[i] != null) {
                            addExpanded.add(entries[i]);
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    Trace.trace(Trace.FINEST, "Error resolving classpath container 2", e);
                }
                continue;
            }
            if (entry.getEntryKind() == 4) {
                if ((entry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry)) == null) continue;
                addExpanded.add(entry);
                continue;
            }
            addExpanded.add(entry);
        }
        iterator = current.iterator();
        while (iterator.hasNext()) {
            entry = (IClasspathEntry)iterator.next();
            ArrayList<IClasspathEntry> currentExpanded = new ArrayList<IClasspathEntry>();
            if (entry.getEntryKind() == 5) {
                try {
                    IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project);
                    IClasspathEntry[] entries = container.getClasspathEntries();
                    int size = entries.length;
                    int i = 0;
                    while (i < size) {
                        if (entries[i] != null) {
                            currentExpanded.add(entries[i]);
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    Trace.trace(Trace.FINEST, "Error resolving classpath container 3", e);
                }
            } else if (entry.getEntryKind() == 4) {
                if ((entry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry)) != null) {
                    currentExpanded.add(entry);
                }
            } else {
                currentExpanded.add(entry);
            }
            boolean dup = false;
            Iterator iterator2 = currentExpanded.iterator();
            while (!dup && iterator2.hasNext()) {
                IClasspathEntry entry2 = (IClasspathEntry)iterator2.next();
                Iterator iterator3 = addExpanded.iterator();
                while (iterator3.hasNext()) {
                    IClasspathEntry entry3 = (IClasspathEntry)iterator3.next();
                    if (!entry3.getPath().equals((Object)entry2.getPath())) continue;
                    dup = true;
                }
            }
            if (!dup || remove.contains(entry)) continue;
            remove.add(entry);
        }
        iterator = remove.iterator();
        while (iterator.hasNext()) {
            current.remove(iterator.next());
        }
    }

    public void removeRuntimeTarget(IProject project, IRuntime runtime, IProgressMonitor monitor) {
        Trace.trace(Trace.FINEST, "Removing runtime target");
        if (project == null || runtime == null) {
            return;
        }
        IJavaProject javaProject = null;
        try {
            javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
        }
        catch (Exception exception) {}
        if (javaProject == null) {
            return;
        }
        try {
            IClasspathEntry[] delegates = this.getDelegateClasspathEntries(runtime, monitor);
            int delegateSize = 0;
            if (delegates != null) {
                delegateSize = delegates.length;
            }
            ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
            IClasspathEntry[] cp = javaProject.getRawClasspath();
            int size = cp.length;
            int i = 0;
            while (i < size) {
                boolean remove = false;
                if (cp[i].getPath().segment(0).equals("org.eclipse.jst.server.core.container")) {
                    remove = true;
                }
                int j = 0;
                while (j < delegateSize) {
                    if (cp[i].equals(delegates[j])) {
                        remove = true;
                    }
                    ++j;
                }
                if (!remove) {
                    list.add(cp[i]);
                }
                ++i;
            }
            cp = new IClasspathEntry[list.size()];
            list.toArray(cp);
            javaProject.setRawClasspath(cp, monitor);
        }
        catch (Exception e) {
            Trace.trace(Trace.WARNING, "Error removing runtime target", e);
        }
    }

    private static void addJarFiles(File dir, List list, boolean includeSubdirectories) {
        int depth = 0;
        if (includeSubdirectories) {
            depth = 2;
        }
        ClasspathRuntimeTargetHandler.addJarFiles(dir, list, depth);
    }

    private static void addJarFiles(File dir, List list, int depth) {
        if (dir == null) {
            throw new IllegalArgumentException();
        }
        File[] files = dir.listFiles();
        if (files != null) {
            int size = files.length;
            int i = 0;
            while (i < size) {
                if (files[i].isDirectory() && depth > 0) {
                    ClasspathRuntimeTargetHandler.addJarFiles(files[i], list, depth - 1);
                } else if (files[i].getAbsolutePath().endsWith(".jar") || files[i].getAbsolutePath().endsWith(".zip")) {
                    Path path = new Path(files[i].getAbsolutePath());
                    list.add(JavaCore.newLibraryEntry((IPath)path, null, null));
                }
                ++i;
            }
        }
    }

    protected static void addLibraryEntries(List list, File dir, boolean includeSubdirectories) {
        if (dir == null) {
            throw new IllegalArgumentException();
        }
        ClasspathRuntimeTargetHandler.addJarFiles(dir, list, includeSubdirectories);
    }

    public IClasspathEntry[] getDelegateClasspathEntries(IRuntime runtime, IProgressMonitor monitor) {
        return null;
    }

    public String[] getClasspathEntryIds() {
        return new String[1];
    }

    public void requestClasspathContainerUpdate(IRuntime runtime, String id, IClasspathEntry[] entries) {
        if (runtime == null || entries == null) {
            return;
        }
        this.sourceAttachments = new ArrayList();
        int size = entries.length;
        int i = 0;
        while (i < size) {
            if (entries[i].getSourceAttachmentPath() != null || entries[i].getExtraAttributes() != null) {
                SourceAttachmentUpdate sau = new SourceAttachmentUpdate();
                sau.runtimeId = runtime.getId();
                sau.id = id;
                sau.entry = entries[i].getPath();
                sau.sourceAttachmentPath = entries[i].getSourceAttachmentPath();
                sau.sourceAttachmentRootPath = entries[i].getSourceAttachmentRootPath();
                sau.attributes = entries[i].getExtraAttributes();
                this.sourceAttachments.add(sau);
            }
            ++i;
        }
        this.save();
    }

    public abstract String getClasspathContainerLabel(IRuntime var1, String var2);

    public IClasspathEntry[] resolveClasspathContainerImpl(IRuntime runtime, String id) {
        IClasspathEntry[] entries = this.resolveClasspathContainer(runtime, id);
        if (entries == null) {
            entries = new IClasspathEntry[]{};
        }
        if (this.sourceAttachments == null) {
            this.load();
        }
        int size = entries.length;
        int size2 = this.sourceAttachments.size();
        int i = 0;
        while (i < size) {
            int j = 0;
            while (j < size2) {
                SourceAttachmentUpdate sau = (SourceAttachmentUpdate)this.sourceAttachments.get(j);
                if ((id != null && sau.id.equals(id) || id == null && sau.id == null) && sau.runtimeId.equals(runtime.getId()) && sau.entry.equals((Object)entries[i].getPath())) {
                    entries[i] = JavaCore.newLibraryEntry((IPath)entries[i].getPath(), (IPath)sau.sourceAttachmentPath, (IPath)sau.sourceAttachmentRootPath, (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])sau.attributes, (boolean)false);
                }
                ++j;
            }
            ++i;
        }
        return entries;
    }

    private void save() {
        if (this.sourceAttachments == null) {
            return;
        }
        String id = this.getRuntimeTargetHandler().getId();
        String filename = JavaServerPlugin.getInstance().getStateLocation().append(String.valueOf(id) + ".xml").toOSString();
        try {
            XMLMemento memento = XMLMemento.createWriteRoot("classpath");
            Iterator iterator = this.sourceAttachments.iterator();
            while (iterator.hasNext()) {
                SourceAttachmentUpdate sau = (SourceAttachmentUpdate)iterator.next();
                IMemento child = memento.createChild("source-attachment");
                child.putString("runtime-id", sau.runtimeId);
                if (sau.id != null) {
                    child.putString("id", sau.id);
                }
                if (sau.entry != null) {
                    child.putString("entry", sau.entry.toPortableString());
                }
                if (sau.sourceAttachmentPath != null) {
                    child.putString("source-attachment-path", sau.sourceAttachmentPath.toPortableString());
                }
                if (sau.sourceAttachmentRootPath != null) {
                    child.putString("source-attachment-root-path", sau.sourceAttachmentRootPath.toPortableString());
                }
                if (sau.attributes == null) continue;
                int size = sau.attributes.length;
                int i = 0;
                while (i < size) {
                    IClasspathAttribute attr = sau.attributes[i];
                    IMemento attrChild = child.createChild("attribute");
                    attrChild.putString("name", attr.getName());
                    attrChild.putString("value", attr.getValue());
                    ++i;
                }
            }
            memento.saveToFile(filename);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error saving source path info", e);
        }
    }

    private void load() {
        this.sourceAttachments = new ArrayList();
        if (this.getRuntimeTargetHandler() == null) {
            return;
        }
        String id = this.getRuntimeTargetHandler().getId();
        String filename = JavaServerPlugin.getInstance().getStateLocation().append(String.valueOf(id) + ".xml").toOSString();
        try {
            IMemento memento = XMLMemento.loadMemento(filename);
            IMemento[] children = memento.getChildren("source-attachment");
            int size = children.length;
            int i = 0;
            while (i < size) {
                try {
                    IMemento[] attrChildren;
                    SourceAttachmentUpdate sau = new SourceAttachmentUpdate();
                    sau.runtimeId = children[i].getString("runtime-id");
                    sau.id = children[i].getString("id");
                    String temp = children[i].getString("entry");
                    if (temp != null) {
                        sau.entry = new Path(temp);
                    }
                    if ((temp = children[i].getString("source-attachment-path")) != null) {
                        sau.sourceAttachmentPath = new Path(temp);
                    }
                    if ((temp = children[i].getString("source-attachment-root-path")) != null) {
                        sau.sourceAttachmentRootPath = new Path(temp);
                    }
                    if ((attrChildren = children[i].getChildren("attribute")) != null) {
                        int size2 = attrChildren.length;
                        sau.attributes = new IClasspathAttribute[size2];
                        int j = 0;
                        while (j < size2) {
                            String name = attrChildren[j].getString("name");
                            String value = attrChildren[j].getString("value");
                            sau.attributes[j] = JavaCore.newClasspathAttribute((String)name, (String)value);
                            ++j;
                        }
                    }
                    this.sourceAttachments.add(sau);
                }
                catch (Exception e) {
                    Trace.trace(Trace.WARNING, "Could not load monitor: " + e);
                }
                ++i;
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.WARNING, "Could not load source path info: " + e.getMessage());
        }
    }

    public abstract IClasspathEntry[] resolveClasspathContainer(IRuntime var1, String var2);

    private class SourceAttachmentUpdate {
        String runtimeId;
        String id;
        IPath entry;
        IPath sourceAttachmentPath;
        IPath sourceAttachmentRootPath;
        IClasspathAttribute[] attributes;

        SourceAttachmentUpdate() {
        }
    }
}

