/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.internal.cactus;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jst.server.core.internal.cactus.WebTestableResource;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.ModuleArtifactAdapterDelegate;

public class CactusModuleArtifactAdapterDelegate
extends ModuleArtifactAdapterDelegate {
    private static final String SERVLET_TEST_CASE_TYPE = "org.apache.cactus.ServletTestCase";
    static /* synthetic */ Class class$0;

    public IModuleArtifact getModuleArtifact(Object obj) {
        String methodName = "";
        if (obj instanceof IMethod) {
            IMethod method = (IMethod)obj;
            methodName = method.getElementName();
            obj = method.getCompilationUnit();
        }
        if (obj instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)obj;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IResource resource = (IResource)iAdaptable.getAdapter((Class)clazz);
            String testClassName = CactusModuleArtifactAdapterDelegate.getClassNameForType(resource, SERVLET_TEST_CASE_TYPE);
            String projectName = resource.getProject().getName();
            if (testClassName != null) {
                return new WebTestableResource(CactusModuleArtifactAdapterDelegate.getModule(resource.getProject()), false, projectName, testClassName, methodName);
            }
        }
        return null;
    }

    public static String getClassNameForType(IResource resource, String superType) {
        if (resource == null) {
            return null;
        }
        try {
            IJavaElement javaElement;
            IType[] types;
            IClasspathEntry[] classPathEntry;
            IPath outputPath;
            IProject project = resource.getProject();
            IPath path = resource.getFullPath();
            if (!project.hasNature("org.eclipse.jdt.core.javanature") || path == null) {
                return null;
            }
            IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
            if (!javaProject.isOpen()) {
                javaProject.open((IProgressMonitor)new NullProgressMonitor());
            }
            if ((outputPath = javaProject.getOutputLocation()) != null && "class".equals(path.getFileExtension()) && outputPath.isPrefixOf(path)) {
                int count = outputPath.segmentCount();
                path = path.removeFirstSegments(count);
            }
            if ((classPathEntry = javaProject.getResolvedClasspath(true)) != null) {
                int size = classPathEntry.length;
                int i = 0;
                while (i < size) {
                    IPath classPath = classPathEntry[i].getPath();
                    if (classPath.isPrefixOf(path)) {
                        int count = classPath.segmentCount();
                        path = path.removeFirstSegments(count);
                        i += size;
                    }
                    ++i;
                }
            }
            if ((types = CactusModuleArtifactAdapterDelegate.getTypes(javaElement = javaProject.findElement(path))) != null) {
                int size2 = types.length;
                int i = 0;
                while (i < size2) {
                    if (CactusModuleArtifactAdapterDelegate.hasSuperclass(types[i], superType)) {
                        return types[i].getFullyQualifiedName();
                    }
                    ++i;
                }
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static IType[] getTypes(IJavaElement element) {
        try {
            if (element.getElementType() != 5) {
                return null;
            }
            return ((ICompilationUnit)element).getAllTypes();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean hasSuperclass(IType type, String superClassName) {
        try {
            ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
            IType[] superClasses = hierarchy.getAllSuperclasses(type);
            int size = superClasses.length;
            int i = 0;
            while (i < size) {
                if (superClassName.equals(superClasses[i].getFullyQualifiedName())) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected static IModule getModule(IProject project) {
        IModule deployable = null;
        Iterator<IModule> iterator = Arrays.asList(ServerUtil.getModules((String)"j2ee.web")).iterator();
        while (iterator.hasNext()) {
            IModule next = iterator.next();
            if (!(next instanceof IModule) || !(deployable = next).getProject().equals((Object)project)) continue;
            return deployable;
        }
        return null;
    }
}

