/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.model.translator.application;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.j2ee.application.ApplicationFactory;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.internal.application.ApplicationPackage;
import org.eclipse.jst.j2ee.internal.model.translator.common.CommonTranslators;
import org.eclipse.jst.j2ee.internal.xml.EarDeploymentDescriptorXmlMapperI;
import org.eclipse.wst.common.internal.emf.resource.IDTranslator;
import org.eclipse.wst.common.internal.emf.resource.ReadAheadHelper;
import org.eclipse.wst.common.internal.emf.resource.Translator;

public class ModuleTranslator
extends Translator
implements EarDeploymentDescriptorXmlMapperI {
    private static final ApplicationPackage APPLICATION_PKG = ApplicationPackage.eINSTANCE;
    private static final Translator ALT_DD_TRANSLATOR = ModuleTranslator.createAltDDTranslator();
    private static final Translator[] WEB_TRANSLATORS = ModuleTranslator.createWebModuleTranslators();
    private static final Translator[] EJB_TRANSLATORS = ModuleTranslator.createEJBModuleTranslators();
    private static final Translator[] JAVA_TRANSLATORS = ModuleTranslator.createJavaModuleTranslators();
    private static final Translator[] CONNECTOR_TRANSLATORS = ModuleTranslator.createConnectorModuleTranslators();

    public ModuleTranslator() {
        super("module", (EStructuralFeature)APPLICATION_PKG.getApplication_Modules());
        this.addReadAheadHelper(new ReadAheadHelper("module", new String[]{"ejb", "java", "web", "connector"}, null));
    }

    private static Translator[] createConnectorModuleTranslators() {
        return new Translator[]{IDTranslator.INSTANCE, new Translator("connector", (EStructuralFeature)APPLICATION_PKG.getModule_Uri()), ALT_DD_TRANSLATOR};
    }

    private static Translator[] createJavaModuleTranslators() {
        return new Translator[]{IDTranslator.INSTANCE, new Translator("java", (EStructuralFeature)APPLICATION_PKG.getModule_Uri()), ALT_DD_TRANSLATOR};
    }

    private static Translator[] createEJBModuleTranslators() {
        return new Translator[]{IDTranslator.INSTANCE, new Translator("ejb", (EStructuralFeature)APPLICATION_PKG.getModule_Uri()), ALT_DD_TRANSLATOR};
    }

    private static Translator[] createWebModuleTranslators() {
        return new Translator[]{IDTranslator.INSTANCE, new Translator("web/web-uri", (EStructuralFeature)APPLICATION_PKG.getModule_Uri()), new Translator("web/context-root", (EStructuralFeature)APPLICATION_PKG.getWebModule_ContextRoot()), ALT_DD_TRANSLATOR};
    }

    private static Translator createAltDDTranslator() {
        return new Translator("alt-dd", (EStructuralFeature)ApplicationPackage.eINSTANCE.getModule_AltDD());
    }

    public Translator[] getChildren(Object o, int versionID) {
        if (o == null) {
            return CommonTranslators.EMPTY_CHILDREN;
        }
        if (((Module)o).isEjbModule()) {
            return EJB_TRANSLATORS;
        }
        if (((Module)o).isConnectorModule()) {
            return CONNECTOR_TRANSLATORS;
        }
        if (((Module)o).isWebModule()) {
            return WEB_TRANSLATORS;
        }
        if (((Module)o).isJavaModule()) {
            return JAVA_TRANSLATORS;
        }
        throw new IllegalStateException("Internal error: Module Type excepted");
    }

    public EObject createEMFObject(String nodeName, String readAheadName) {
        ApplicationFactory fact = ApplicationFactory.eINSTANCE;
        if ("ejb".equals(readAheadName)) {
            return fact.createEjbModule();
        }
        if ("web".equals(readAheadName)) {
            return fact.createWebModule();
        }
        if ("java".equals(readAheadName)) {
            return fact.createJavaClientModule();
        }
        if ("connector".equals(readAheadName)) {
            return fact.createConnectorModule();
        }
        return fact.createModule();
    }

    public boolean isManagedByParent() {
        return false;
    }
}

