/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.ui.eclipse;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.wsdl.validation.internal.resolver.IExtensibleURIResolver;
import org.eclipse.wst.wsdl.validation.internal.resolver.URIResolverDelegate;

class URIResolverRegistryReader {
    protected static final String PLUGIN_ID = "org.eclipse.wst.wsdl.validation";
    protected static final String EXTENSION_POINT_ID = "uriresolver";
    protected static final String ATT_CLASS = "class";
    protected String tagName;

    public List readRegistry() {
        ArrayList<IExtensibleURIResolver> resolverList = new ArrayList<IExtensibleURIResolver>();
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = pluginRegistry.getExtensionPoint(PLUGIN_ID, EXTENSION_POINT_ID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IExtensibleURIResolver resolver = this.readElement(elements[i]);
                if (resolver != null) {
                    resolverList.add(resolver);
                }
                ++i;
            }
        }
        return resolverList;
    }

    protected IExtensibleURIResolver readElement(IConfigurationElement element) {
        String resolverClass;
        if (element.getName().equals(EXTENSION_POINT_ID) && (resolverClass = element.getAttribute(ATT_CLASS)) != null) {
            try {
                ClassLoader pluginLoader = element.getDeclaringExtension().getDeclaringPluginDescriptor().getPluginClassLoader();
                return new URIResolverDelegate(resolverClass, pluginLoader).getURIResolver();
            }
            catch (Exception exception) {}
        }
        return null;
    }
}

