/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.ui.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jst.server.generic.servertype.definition.Property;
import org.eclipse.jst.server.generic.servertype.definition.ServerRuntime;
import org.eclipse.jst.server.generic.ui.internal.GenericServerComposite;
import org.eclipse.jst.server.generic.ui.internal.GenericServerCompositeDecorator;
import org.eclipse.jst.server.generic.ui.internal.GenericServerUIMessages;
import org.eclipse.jst.server.generic.ui.internal.SWTUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public abstract class ServerTypeDefinitionDecorator
implements GenericServerCompositeDecorator {
    protected static final String CONTEXT_RUNTIME = "runtime";
    protected static final String CONTEXT_SERVER = "server";
    private ServerRuntime fDefinition;
    private Map fProperties;
    private String fContext;
    private GenericServerComposite fComposite;
    private Map fStatusMap = new HashMap();
    private String fLastMessage = null;
    protected IWizardHandle fWizard;
    private List fPropertyControls = new ArrayList();

    public ServerTypeDefinitionDecorator(ServerRuntime definition, Map initialProperties, String context, IWizardHandle handle) {
        this.fDefinition = definition;
        this.fProperties = initialProperties;
        this.fContext = context;
        this.fWizard = handle;
    }

    public void decorate(GenericServerComposite composite) {
        this.fComposite = composite;
        ArrayList properties = null;
        properties = this.fDefinition == null ? new ArrayList(0) : this.fDefinition.getProperty();
        int i = 0;
        while (i < properties.size()) {
            Property property = (Property)properties.get(i);
            if (this.fContext.equals(property.getContext())) {
                this.createPropertyControl(composite, property);
            }
            ++i;
        }
    }

    private void createPropertyControl(Composite parent, Property property) {
        if ("directory".equals(property.getType())) {
            Text path = this.createLabeledPath(property.getLabel(), this.getPropertyValue(property), parent);
            path.setData((Object)property);
            this.registerControl((Control)path);
        } else if ("file".equals(property.getType())) {
            Text file = this.createLabeledFile(property.getLabel(), this.getPropertyValue(property), parent);
            file.setData((Object)property);
            this.registerControl((Control)file);
        } else if ("string".equals(property.getType())) {
            Text str = this.createLabeledText(property.getLabel(), this.getPropertyValue(property), parent);
            str.setData((Object)property);
            this.registerControl((Control)str);
        } else if ("boolean".equals(property.getType())) {
            Button bool = this.createLabeledCheck(property.getLabel(), "true".equals(this.getPropertyValue(property)), parent);
            bool.setData((Object)property);
            this.registerControl((Control)bool);
        } else {
            Text defaultText = this.createLabeledText(property.getLabel(), this.getPropertyValue(property), parent);
            defaultText.setData((Object)property);
            this.registerControl((Control)defaultText);
        }
    }

    private void registerControl(Control control) {
        this.fPropertyControls.add(control);
    }

    private Button createLabeledCheck(String title, boolean value, Composite defPanel) {
        Label label = new Label(defPanel, 64);
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(title);
        Button fButton = new Button(defPanel, 32);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        fButton.setLayoutData((Object)gridData);
        fButton.setSelection(value);
        fButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return fButton;
    }

    private Text createLabeledFile(String title, String value, final Composite defPanel) {
        Label label = new Label(defPanel, 64);
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(title);
        final Text text = new Text(defPanel, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        text.setLayoutData((Object)gridData);
        text.setText(value);
        text.addModifyListener((ModifyListener)new PathModifyListener());
        Button fButton = SWTUtil.createButton(defPanel, GenericServerUIMessages.serverTypeGroup_label_browse);
        fButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(defPanel.getShell());
                dlg.setFileName(text.getText().replace('\\', '/'));
                String res = dlg.open();
                if (res != null) {
                    text.setText(res.replace('\\', '/'));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return text;
    }

    private Text createLabeledPath(String title, String value, final Composite parent) {
        Label label = new Label(parent, 64);
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(title);
        final Text text = new Text(parent, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        text.setLayoutData((Object)gridData);
        text.setText(value);
        text.addModifyListener((ModifyListener)new PathModifyListener());
        Button fButton = SWTUtil.createButton(parent, GenericServerUIMessages.serverTypeGroup_label_browse);
        fButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dlg = new DirectoryDialog(parent.getShell());
                dlg.setFilterPath(text.getText().replace('\\', '/'));
                String res = dlg.open();
                if (res != null) {
                    text.setText(res.replace('\\', '/'));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return text;
    }

    private Text createLabeledText(String title, String value, Composite defPanel) {
        Label label = new Label(defPanel, 64);
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(title);
        Text text = new Text(defPanel, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        text.setLayoutData((Object)gridData);
        text.setText(value);
        return text;
    }

    private String getPropertyValue(Property property) {
        String value = property.getDefault();
        if (this.fProperties != null && !this.fProperties.isEmpty()) {
            value = (String)this.fProperties.get(property.getId());
        }
        return value;
    }

    public Map getValues() {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        int i = 0;
        while (i < this.fPropertyControls.size()) {
            Property prop;
            if (this.fPropertyControls.get(i) instanceof Button) {
                Button button = (Button)this.fPropertyControls.get(i);
                prop = (Property)button.getData();
                propertyMap.put(prop.getId(), Boolean.toString(button.getSelection()));
            } else {
                Text text = (Text)this.fPropertyControls.get(i);
                prop = (Property)text.getData();
                propertyMap.put(prop.getId(), text.getText());
            }
            ++i;
        }
        return propertyMap;
    }

    private final class PathModifyListener
    implements ModifyListener {
        PathModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            String path = ((Text)e.widget).getText();
            if (!this.pathExist(path)) {
                ServerTypeDefinitionDecorator.this.fLastMessage = GenericServerUIMessages.bind((String)GenericServerUIMessages.invalidPath, (Object)path);
                ServerTypeDefinitionDecorator.this.fWizard.setMessage(ServerTypeDefinitionDecorator.this.fLastMessage, 3);
            } else {
                if (ServerTypeDefinitionDecorator.this.fLastMessage != null && ServerTypeDefinitionDecorator.this.fLastMessage.equals(ServerTypeDefinitionDecorator.this.fWizard.getMessage())) {
                    ServerTypeDefinitionDecorator.this.fLastMessage = null;
                    ServerTypeDefinitionDecorator.this.fWizard.setMessage(null, 0);
                }
                ServerTypeDefinitionDecorator.this.validate();
            }
        }

        private boolean pathExist(String path) {
            File f = new File(path);
            return f.exists();
        }
    }
}

