/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.creation.ui.widgets.bean;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.plugin.JavaEMFNature;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.impl.JavaClassImpl;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.common.JavaResourceFilter;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;

public class ValidateObjectSelectionCommand
extends SimpleCommand {
    private String JAVA_EXTENSION = ".java";
    private String CLASS_EXTENSION = ".class";
    private MessageUtils msgUtils_;
    private IStructuredSelection objectSelection;
    private String serviceProjectName;

    public ValidateObjectSelectionCommand() {
        String pluginId = "org.eclipse.jst.ws.axis.creation.ui";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
    }

    public Status execute(Environment env) {
        String javaBeanName = null;
        if (this.objectSelection != null && !this.objectSelection.isEmpty()) {
            Object object = this.objectSelection.getFirstElement();
            if (object instanceof String) {
                javaBeanName = (String)object;
            } else {
                try {
                    System.out.println(object.getClass().toString());
                    javaBeanName = this.getJavaBeanFromObjectSelection(this.objectSelection);
                }
                catch (CoreException coreException) {
                    SimpleStatus errorStatus = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_CANNOT_NO_JAVA_BEAN"), 4);
                    env.getStatusHandler().reportError((Status)errorStatus);
                    return errorStatus;
                }
            }
        }
        if (javaBeanName == null || javaBeanName.length() == 0) {
            SimpleStatus errorStatus = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_CANNOT_NO_JAVA_BEAN"), 4);
            env.getStatusHandler().reportError((Status)errorStatus);
            return errorStatus;
        }
        IProject serviceProject = ProjectUtilities.getProject((String)this.serviceProjectName);
        if (serviceProject == null) {
            SimpleStatus errorStatus = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_NO_PROJECT"), 4);
            env.getStatusHandler().reportError((Status)errorStatus);
            return errorStatus;
        }
        if (javaBeanName.toLowerCase().endsWith(this.JAVA_EXTENSION) || javaBeanName.toLowerCase().endsWith(this.CLASS_EXTENSION)) {
            javaBeanName = javaBeanName.substring(0, javaBeanName.lastIndexOf(46));
        }
        try {
            JavaEMFNature jMOF = JavaEMFNature.createRuntime((IProject)serviceProject);
            JavaClass javaClass = (JavaClass)JavaClassImpl.reflect((String)javaBeanName, (ResourceSet)jMOF.getResourceSet());
            if (!javaClass.isExistingType()) {
                SimpleStatus errorStatus = new SimpleStatus("JavaToWSDLMethodCommand", this.msgUtils_.getMessage("MSG_ERROR_CANNOT_LOAD_JAVA_BEAN", (Object[])new String[]{javaBeanName, this.serviceProjectName}), 4);
                env.getStatusHandler().reportError((Status)errorStatus);
                return errorStatus;
            }
        }
        catch (CoreException coreException) {
            SimpleStatus errorStatus = new SimpleStatus("JavaToWSDLMethodCommand", this.msgUtils_.getMessage("MSG_ERROR_CANNOT_LOAD_JAVA_BEAN", (Object[])new String[]{javaBeanName, this.serviceProjectName}), 4);
            env.getStatusHandler().reportError((Status)errorStatus);
            return errorStatus;
        }
        return new SimpleStatus("");
    }

    public void setServiceProjectName(String serviceProjectName) {
        this.serviceProjectName = serviceProjectName;
    }

    public void setObjectSelection(IStructuredSelection objectSelection) {
        this.objectSelection = objectSelection;
    }

    private String getJavaBeanFromObjectSelection(IStructuredSelection objectSelection) throws CoreException {
        Object obj;
        String beanClass = "";
        JavaResourceFilter filter = new JavaResourceFilter();
        if (objectSelection != null && (obj = objectSelection.getFirstElement()) != null) {
            String beanPackage;
            IResource res = null;
            res = ResourceUtils.getResourceFromSelection((Object)obj);
            if (filter.accepts((Object)res) && ((beanClass = String.valueOf(beanPackage = (beanPackage = ResourceUtils.getJavaResourcePackageName((IPath)res.getFullPath())) == null ? "" : String.valueOf(beanPackage) + ".") + res.getName()).toLowerCase().endsWith(".java") || beanClass.toLowerCase().endsWith(".class"))) {
                beanClass = beanClass.substring(0, beanClass.lastIndexOf(46));
            }
        }
        return beanClass;
    }
}

