/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.ResourceVariantTreeSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteResource;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.MutableFolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.MutableResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Assert;

public class CVSSyncInfo
extends SyncInfo {
    private static final int INVALID_RESOURCE_TYPE = 1;
    private static final int INVALID_SYNC_KIND = 2;
    private static final int PARENT_NOT_MANAGED = 3;
    private static final int REMOTE_DOES_NOT_EXIST = 4;
    private static final int SYNC_INFO_CONFLICTS = 5;
    private Subscriber subscriber;

    public CVSSyncInfo(IResource local, IResourceVariant base, IResourceVariant remote, Subscriber subscriber) {
        super(local, base, remote, ((ResourceVariantTreeSubscriber)subscriber).getResourceComparator());
        this.subscriber = subscriber;
    }

    public Subscriber getSubscriber() {
        return this.subscriber;
    }

    protected int calculateKind() throws TeamException {
        IResource local = this.getLocal();
        if (local.getType() != 1) {
            int folderKind = 0;
            ICVSRemoteFolder remote = (ICVSRemoteFolder)this.getRemote();
            ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)local);
            boolean isCVSFolder = false;
            try {
                isCVSFolder = cvsFolder.isCVSFolder();
            }
            catch (CVSException cVSException) {}
            if (!local.exists()) {
                if (remote != null) {
                    folderKind = isCVSFolder ? 0 : 9;
                }
            } else if (remote == null) {
                folderKind = isCVSFolder ? 0 : 5;
            } else if (!isCVSFolder) {
                folderKind = 13;
            }
            return folderKind;
        }
        int kind = super.calculateKind();
        IResourceVariant remote = this.getRemote();
        if (remote != null && (kind & 0x10) == 0) {
            RemoteResource cvsRemote = (RemoteResource)remote;
            int type = cvsRemote.getWorkspaceSyncState();
            switch (type) {
                case 6: {
                    return kind | 0x40;
                }
                case 7: {
                    return kind | 0x20;
                }
            }
        }
        kind = this.handleDeletionConflicts(kind);
        return kind;
    }

    protected int handleDeletionConflicts(int kind) {
        if (kind == 30) {
            try {
                IResource local = this.getLocal();
                ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor(local);
                if (!cvsResource.isFolder() && cvsResource.isManaged()) {
                    cvsResource.unmanage(null);
                }
                return 0;
            }
            catch (CVSException e) {
                CVSProviderPlugin.log((CoreException)((Object)e));
                return 14;
            }
        }
        return kind;
    }

    public IStatus makeOutgoing(IProgressMonitor monitor) throws TeamException {
        if (this.getLocal().getType() == 2) {
            return this.makeInSync();
        }
        int syncKind = this.getKind();
        boolean incoming = (syncKind & 0xC) == 8;
        boolean outgoing = (syncKind & 0xC) == 4;
        ICVSResource local = CVSWorkspaceRoot.getCVSResourceFor(this.getLocal());
        RemoteResource remote = (RemoteResource)this.getRemote();
        ResourceSyncInfo origInfo = local.getSyncInfo();
        MutableResourceSyncInfo info = null;
        if (origInfo != null) {
            info = origInfo.cloneMutable();
        }
        if (outgoing) {
            return Status.OK_STATUS;
        }
        if (incoming) {
            if (local.exists()) {
                if (remote == null) {
                    info.setAdded();
                } else {
                    info.setRevision(remote.getSyncInfo().getRevision());
                    info.setTimeStamp(null);
                }
            } else {
                info = remote.getSyncInfo().cloneMutable();
                info.setDeleted(true);
            }
        } else if (local.exists()) {
            if (this.getRemote() != null) {
                if (this.getBase() != null) {
                    info.setRevision(remote.getSyncInfo().getRevision());
                } else {
                    try {
                        remote.getStorage(Policy.monitorFor(monitor)).getContents();
                        info = remote.getSyncInfo().cloneMutable();
                    }
                    catch (CoreException e) {
                        throw TeamException.asTeamException((CoreException)e);
                    }
                }
            } else if (this.getBase() != null) {
                info.setAdded();
            } else {
                Assert.isTrue(false);
            }
        } else if (this.getRemote() != null) {
            info.setRevision(remote.getSyncInfo().getRevision());
            info.setDeleted(true);
        } else {
            info = null;
            return Status.OK_STATUS;
        }
        if (info != null) {
            FolderSyncInfo parentInfo = local.getParent().getFolderSyncInfo();
            if (parentInfo == null) {
                return new CVSStatus(4, 3, NLS.bind((String)CVSMessages.CVSSyncInfo_9, (Object[])new String[]{this.getLocal().getFullPath().toString()}));
            }
            info.setTag(parentInfo.getTag());
        }
        ((ICVSFile)local).setSyncInfo(info, 0);
        return Status.OK_STATUS;
    }

    public IStatus makeInSync() throws CVSException {
        boolean outgoing;
        if (this.getLocal().getType() == 1) {
            return new CVSStatus(2, 1, NLS.bind((String)CVSMessages.CVSSyncInfo_7, (Object[])new String[]{this.getLocal().getFullPath().toString()}));
        }
        boolean bl = outgoing = (this.getKind() & 0xC) == 4;
        if (outgoing) {
            return new CVSStatus(2, 2, NLS.bind((String)CVSMessages.CVSSyncInfo_8, (Object[])new String[]{this.getLocal().getFullPath().toString()}));
        }
        ICVSFolder local = CVSWorkspaceRoot.getCVSFolderFor((IContainer)this.getLocal());
        if (this.getLocal().getType() == 2 && !local.getParent().isCVSFolder()) {
            return new CVSStatus(4, 3, NLS.bind((String)CVSMessages.CVSSyncInfo_9, (Object[])new String[]{this.getLocal().getFullPath().toString()}));
        }
        if (!local.exists()) {
            local.mkdir();
        }
        RemoteFolder remote = (RemoteFolder)this.getRemote();
        if ((local.isManaged() || this.getLocal().getType() == 4) && local.isCVSFolder()) {
            if (remote == null) {
                return Status.OK_STATUS;
            }
            FolderSyncInfo remoteInfo = remote.getFolderSyncInfo();
            FolderSyncInfo localInfo = local.getFolderSyncInfo();
            if (!localInfo.getRoot().equals(remoteInfo.getRoot())) {
                return new CVSStatus(4, 5, NLS.bind((String)CVSMessages.CVSRemoteSyncElement_rootDiffers, (Object[])new Object[]{local.getName(), remoteInfo.getRoot(), localInfo.getRoot()}));
            }
            if (!localInfo.getRepository().equals(remoteInfo.getRepository())) {
                return new CVSStatus(4, 5, NLS.bind((String)CVSMessages.CVSRemoteSyncElement_repositoryDiffers, (Object[])new Object[]{local.getName(), remoteInfo.getRepository(), localInfo.getRepository()}));
            }
            return Status.OK_STATUS;
        }
        if (remote == null) {
            return new CVSStatus(4, 4, NLS.bind((String)CVSMessages.CVSSyncInfo_10, (Object[])new String[]{this.getLocal().getFullPath().toString()}));
        }
        FolderSyncInfo remoteInfo = remote.getFolderSyncInfo();
        FolderSyncInfo localInfo = local.getParent().getFolderSyncInfo();
        MutableFolderSyncInfo newInfo = remoteInfo.cloneMutable();
        newInfo.setTag(localInfo.getTag());
        newInfo.setStatic(false);
        local.setFolderSyncInfo(newInfo);
        return Status.OK_STATUS;
    }

    public String toString() {
        IResourceVariant base = this.getBase();
        IResourceVariant remote = this.getRemote();
        StringBuffer result = new StringBuffer(super.toString());
        result.append("Local: ");
        result.append(this.getLocal().toString());
        result.append(" Base: ");
        if (base == null) {
            result.append("none");
        } else {
            result.append(base.toString());
        }
        result.append(" Remote: ");
        if (remote == null) {
            result.append("none");
        } else {
            result.append(remote.toString());
        }
        return result.toString();
    }

    public String getLocalContentIdentifier() {
        try {
            ICVSFile cvsFile;
            ResourceSyncInfo info;
            IResource local = this.getLocal();
            if (local != null && local.getType() == 1 && (info = (cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)local)).getSyncInfo()) != null) {
                return info.getRevision();
            }
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
            return null;
        }
        return null;
    }
}

