/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client.listeners;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.client.CommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.ILogEntryListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.LogEntry;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.util.Util;

public class LogListener
extends CommandOutputListener {
    private static final String LOG_TIMESTAMP_FORMAT_OLD = "yyyy/MM/dd HH:mm:ss zzz";
    private static final String LOG_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss zzz";
    private static final Locale LOG_TIMESTAMP_LOCALE = Locale.US;
    private static final String NOTHING_KNOWN_ABOUT = "nothing known about ";
    private final int DONE = 4;
    private final int COMMENT = 3;
    private final int REVISION = 2;
    private final int SYMBOLIC_NAMES = 1;
    private final int BEGIN = 0;
    private RemoteFile currentFile;
    private int state = 0;
    private StringBuffer comment;
    private String fileState;
    private String revision;
    private String author;
    private String creationDate;
    private List tagRevisions = new ArrayList(5);
    private List tagNames = new ArrayList(5);
    private final ILogEntryListener listener;

    public LogListener(ILogEntryListener listener) {
        this.listener = listener;
    }

    public LogListener(RemoteFile file, ILogEntryListener listener) {
        this(listener);
        this.currentFile = file;
    }

    private String getRelativeFilePath(ICVSRepositoryLocation location, String fileName) {
        String rootDirectory;
        if (fileName.endsWith(",v")) {
            fileName = fileName.substring(0, fileName.length() - 2);
        }
        if ((fileName = Util.removeAtticSegment(fileName)).startsWith(rootDirectory = location.getRootDirectory())) {
            try {
                fileName = Util.getRelativePath(rootDirectory, fileName);
            }
            catch (CVSException e) {
                CVSProviderPlugin.log((CoreException)((Object)e));
                return null;
            }
        }
        return fileName;
    }

    public IStatus errorLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
        String serverMessage = this.getServerMessage(line, location);
        if (serverMessage != null && serverMessage.startsWith(NOTHING_KNOWN_ABOUT)) {
            return new CVSStatus(4, -17, commandRoot, line);
        }
        return OK;
    }

    public IStatus messageLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
        switch (this.state) {
            case 0: {
                if (line.startsWith("RCS file: ")) {
                    String fileName = this.getRelativeFilePath(location, line.substring(10).trim());
                    if (fileName == null) {
                        this.currentFile = null;
                        this.handleInvalidFileName(location, fileName);
                        break;
                    }
                    if (this.currentFile != null && this.currentFile.getRepositoryRelativePath().equals(fileName)) break;
                    this.beginFile(location, fileName);
                    break;
                }
                if (line.startsWith("symbolic names:")) {
                    this.state = 1;
                    break;
                }
                if (!line.startsWith("revision ")) break;
                this.revision = line.substring(9);
                this.state = 2;
                break;
            }
            case 1: {
                if (line.startsWith("keyword substitution:")) {
                    this.state = 0;
                    break;
                }
                int firstColon = line.indexOf(58);
                String tagName = line.substring(1, firstColon);
                String tagRevision = line.substring(firstColon + 2);
                this.tagNames.add(tagName);
                this.tagRevisions.add(tagRevision);
                break;
            }
            case 2: {
                int endOfDateIndex = line.indexOf(59, 6);
                this.creationDate = String.valueOf(line.substring(6, endOfDateIndex)) + " GMT";
                int endOfAuthorIndex = line.indexOf(59, endOfDateIndex + 1);
                this.author = line.substring(endOfDateIndex + 11, endOfAuthorIndex);
                this.fileState = line.substring(endOfAuthorIndex + 10, line.indexOf(59, endOfAuthorIndex + 1));
                this.comment = new StringBuffer();
                this.state = 3;
                break;
            }
            case 3: {
                if (line.startsWith("branches:")) break;
                if (line.equals("=============================================================================") || line.equals("----------------------------")) {
                    this.state = 4;
                    break;
                }
                if (this.comment.length() != 0) {
                    this.comment.append('\n');
                }
                this.comment.append(line);
            }
        }
        if (this.state == 4) {
            ArrayList<CVSTag> thisRevisionTags = new ArrayList<CVSTag>(3);
            int i = 0;
            while (i < this.tagNames.size()) {
                String tagName = (String)this.tagNames.get(i);
                String tagRevision = (String)this.tagRevisions.get(i);
                boolean isBranch = this.isBranchTag(tagRevision);
                if (isBranch) {
                    int lastDot = tagRevision.lastIndexOf(46);
                    if (lastDot == -1) {
                        CVSProviderPlugin.log(4, NLS.bind((String)CVSMessages.LogListener_invalidRevisionFormat, (Object[])new String[]{tagName, tagRevision}), null);
                    } else {
                        if (tagRevision.charAt(lastDot - 1) == '0' && tagRevision.charAt(lastDot - 2) == '.') {
                            lastDot -= 2;
                        }
                        tagRevision = tagRevision.substring(0, lastDot);
                    }
                }
                if (tagRevision.equals(this.revision)) {
                    int type = isBranch ? 1 : 2;
                    thisRevisionTags.add(new CVSTag(tagName, type));
                }
                ++i;
            }
            Date date = this.convertFromLogTime(this.creationDate);
            if (this.currentFile != null) {
                LogEntry entry = new LogEntry(this.currentFile, this.revision, this.author, date, this.comment.toString(), this.fileState, thisRevisionTags.toArray(new CVSTag[0]));
                this.addEntry(entry);
            }
            this.state = 0;
        }
        return OK;
    }

    protected void beginFile(ICVSRepositoryLocation location, String fileName) {
        this.currentFile = RemoteFile.create(fileName, location);
        this.tagNames.clear();
        this.tagRevisions.clear();
    }

    protected void addEntry(LogEntry entry) {
        this.listener.handleLogEntryReceived(entry);
    }

    protected void handleInvalidFileName(ICVSRepositoryLocation location, String badFilePath) {
        CVSProviderPlugin.log(2, "Invalid file path '" + badFilePath + "' received from " + location.toString(), null);
    }

    protected boolean isBranchTag(String tagName) {
        int numberOfDots = 0;
        int lastDot = 0;
        int i = 0;
        while (i < tagName.length()) {
            if (tagName.charAt(i) == '.') {
                ++numberOfDots;
                lastDot = i;
            }
            ++i;
        }
        if (numberOfDots % 2 == 0) {
            return true;
        }
        if (numberOfDots == 1) {
            return false;
        }
        return tagName.charAt(lastDot - 1) == '0' && tagName.charAt(lastDot - 2) == '.';
    }

    private Date convertFromLogTime(String modTime) {
        String timestampFormat = LOG_TIMESTAMP_FORMAT;
        if (modTime.length() > 4 && modTime.charAt(4) == '/') {
            timestampFormat = LOG_TIMESTAMP_FORMAT_OLD;
        }
        SimpleDateFormat format = new SimpleDateFormat(timestampFormat, LOG_TIMESTAMP_LOCALE);
        try {
            return format.parse(modTime);
        }
        catch (ParseException parseException) {
            return null;
        }
    }
}

