/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import org.eclipse.core.internal.indexing.IndexCursor;
import org.eclipse.core.internal.indexing.IndexedStoreException;
import org.eclipse.core.internal.indexing.ObjectID;
import org.eclipse.core.internal.localstore.ILocalStoreConstants;
import org.eclipse.core.internal.properties.IndexedStoreWrapper;
import org.eclipse.core.internal.utils.Convert;
import org.eclipse.core.internal.utils.UniversalUniqueIdentifier;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class HistoryStoreEntry
implements ILocalStoreConstants {
    private IndexCursor cursor;
    private UniversalUniqueIdentifier uuid;
    private byte[] key;

    private HistoryStoreEntry(byte[] key, byte[] value, IndexCursor cursor) {
        this.cursor = cursor;
        this.key = key;
        this.uuid = new UniversalUniqueIdentifier(value);
    }

    public HistoryStoreEntry(IPath path, UniversalUniqueIdentifier uuid, long lastModified, byte count) {
        this.key = this.keyToBytes(path, lastModified, count);
        this.uuid = uuid;
    }

    protected boolean compare(byte[] one, byte[] another) {
        if (one.length != another.length) {
            return false;
        }
        int i = 0;
        while (i < one.length) {
            if (one[i] != another[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static HistoryStoreEntry create(IndexedStoreWrapper store, IndexCursor cursor) throws CoreException, IndexedStoreException {
        byte[] key = cursor.getKey();
        ObjectID valueID = cursor.getValueAsObjectID();
        byte[] value = store.getObject(valueID);
        return new HistoryStoreEntry(key, value, cursor);
    }

    public byte getCount() {
        return this.key[this.key.length - 1];
    }

    public byte[] getKey() {
        return this.key;
    }

    public long getLastModified() {
        byte[] lastModifiedBytes = new byte[8];
        int position = this.key.length - 9;
        System.arraycopy(this.key, position, lastModifiedBytes, 0, 8);
        return Convert.bytesToLong((byte[])lastModifiedBytes);
    }

    public IPath getPath() {
        byte[] pathBytes = new byte[this.key.length - 9];
        System.arraycopy(this.key, 0, pathBytes, 0, pathBytes.length);
        return new Path(Convert.fromUTF8((byte[])pathBytes));
    }

    public UniversalUniqueIdentifier getUUID() {
        return this.uuid;
    }

    public static byte[] keyPrefixToBytes(IPath path, long lastModified) {
        byte[] pathBytes = Convert.toUTF8((String)path.toString());
        byte[] lastModifiedBytes = Convert.longToBytes((long)lastModified);
        byte[] keyPrefixBytes = new byte[pathBytes.length + lastModifiedBytes.length];
        System.arraycopy(pathBytes, 0, keyPrefixBytes, 0, pathBytes.length);
        System.arraycopy(lastModifiedBytes, 0, keyPrefixBytes, pathBytes.length, lastModifiedBytes.length);
        return keyPrefixBytes;
    }

    protected byte[] keyToBytes(IPath path, long lastModified, byte count) {
        byte[] keyPrefix = HistoryStoreEntry.keyPrefixToBytes(path, lastModified);
        byte[] key = new byte[keyPrefix.length + 1];
        int destPosition = 0;
        System.arraycopy(keyPrefix, 0, key, destPosition, keyPrefix.length);
        key[destPosition += keyPrefix.length] = count;
        return key;
    }

    public void remove() throws IndexedStoreException {
        if (this.cursor == null) {
            return;
        }
        this.reposition();
        if (!this.cursor.isSet()) {
            return;
        }
        this.cursor.remove();
    }

    protected void reposition() throws IndexedStoreException {
        if (this.cursor.isSet() && this.compare(this.cursor.getKey(), this.key)) {
            return;
        }
        this.cursor.find(this.key);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("Path: ").append(this.getPath()).append("\n");
        s.append("Last Modified: ").append(this.getLastModified()).append("\n");
        s.append("Count: ").append(this.getCount()).append("\n");
        s.append("UUID: ").append(this.uuid.toStringAsBytes()).append("\n");
        return s.toString();
    }

    public byte[] valueToBytes() {
        return this.uuid.toBytes();
    }
}

