/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.creation.ui.extension;

import org.eclipse.jst.ws.internal.consumption.command.common.CreateModuleCommand;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.context.ResourceContext;
import org.eclipse.wst.ws.internal.provisional.wsrt.IContext;
import org.eclipse.wst.ws.internal.provisional.wsrt.ISelection;
import org.eclipse.wst.ws.internal.provisional.wsrt.IWebService;
import org.eclipse.wst.ws.internal.provisional.wsrt.IWebServiceRuntime;
import org.eclipse.wst.ws.internal.provisional.wsrt.WebServiceInfo;
import org.eclipse.wst.ws.internal.provisional.wsrt.WebServiceScenario;
import org.eclipse.wst.ws.internal.provisional.wsrt.WebServiceState;
import org.eclipse.wst.ws.internal.wsrt.SimpleContext;

public class PreServiceDevelopCommand
extends SimpleCommand {
    private TypeRuntimeServer typeRuntimeServer_;
    private Environment environment_;
    private IContext context_;
    private ISelection selection_;
    private String project_;
    private String module_;
    private String moduleType_;
    private String earProject_;
    private String ear_;
    private IWebService webService_;
    private String j2eeLevel_;
    private ResourceContext resourceContext_;
    private boolean run_;
    private boolean client_;
    private boolean test_;
    private boolean publish_;

    public Status execute(Environment environment) {
        int earIndex;
        int index = this.module_.indexOf("/");
        if (index != -1) {
            this.project_ = this.module_.substring(0, index);
            this.module_ = this.module_.substring(index + 1);
        }
        if (this.ear_ != null && this.ear_.length() > 0 && (earIndex = this.ear_.indexOf("/")) != -1) {
            this.earProject_ = this.ear_.substring(0, earIndex);
            this.ear_ = this.ear_.substring(earIndex + 1);
        }
        IWebServiceRuntime wsrt = WebServiceRuntimeExtensionUtils.getWebServiceRuntime((String)this.typeRuntimeServer_.getRuntimeId());
        WebServiceInfo wsInfo = new WebServiceInfo();
        System.out.println("In Pre service develop command.");
        wsInfo.setJ2eeLevel(this.j2eeLevel_);
        wsInfo.setServerFactoryId(this.typeRuntimeServer_.getServerId());
        wsInfo.setServerInstanceId(this.typeRuntimeServer_.getServerInstanceId());
        wsInfo.setState(WebServiceState.UNKNOWN_LITERAL);
        wsInfo.setWebServiceRuntimeId(this.typeRuntimeServer_.getRuntimeId());
        this.environment_ = environment;
        this.webService_ = wsrt.getWebService(wsInfo);
        WebServiceScenario scenario = null;
        int scenarioInt = WebServiceRuntimeExtensionUtils.getScenarioFromTypeId((String)this.typeRuntimeServer_.getTypeId());
        if (scenarioInt == 0) {
            scenario = WebServiceScenario.BOTTOMUP_LITERAL;
            String impl = (String)this.selection_.getSelection()[0];
            wsInfo.setImplURL(impl);
        } else if (scenarioInt == 1) {
            scenario = WebServiceScenario.TOPDOWN_LITERAL;
            String wsdlURL = (String)this.selection_.getSelection()[0];
            wsInfo.setWsdlURL(wsdlURL);
        }
        this.context_ = new SimpleContext(true, true, true, true, this.run_, this.client_, this.test_, this.publish_, scenario, this.resourceContext_.isOverwriteFilesEnabled(), this.resourceContext_.isCreateFoldersEnabled(), this.resourceContext_.isCheckoutFilesEnabled());
        int intModuleType = this.convertModuleType(this.moduleType_);
        CreateModuleCommand command = new CreateModuleCommand();
        command.setProjectName(this.project_);
        command.setModuleName(this.module_);
        command.setModuleType(intModuleType);
        command.setServerFactoryId(this.typeRuntimeServer_.getServerId());
        command.setServerInstanceId(this.typeRuntimeServer_.getServerInstanceId());
        command.setJ2eeLevel(this.j2eeLevel_);
        Status status = command.execute(environment);
        if (status.getSeverity() == 4) {
            environment.getStatusHandler().reportError(status);
        }
        return status;
    }

    private int convertModuleType(String type) {
        if (type.equals("jst.web")) {
            return 1;
        }
        if (type.equals("jst.ejb")) {
            return 2;
        }
        if (type.equals("jst.appclient")) {
            return 4;
        }
        if (type.equals("jst.ear")) {
            return 8;
        }
        return -1;
    }

    public void setServiceTypeRuntimeServer(TypeRuntimeServer typeRuntimeServer) {
        this.typeRuntimeServer_ = typeRuntimeServer;
    }

    public void setServiceJ2EEVersion(String j2eeLevel) {
        this.j2eeLevel_ = j2eeLevel;
    }

    public String getJ2eeLevel() {
        return this.j2eeLevel_;
    }

    public IWebService getWebService() {
        return this.webService_;
    }

    public Environment getEnvironment() {
        return this.environment_;
    }

    public IContext getContext() {
        return this.context_;
    }

    public void setResourceContext(ResourceContext resourceContext) {
        this.resourceContext_ = resourceContext;
    }

    public ISelection getSelection() {
        return this.selection_;
    }

    public void setSelection(ISelection selection) {
        this.selection_ = selection;
    }

    public String getProject() {
        return this.project_;
    }

    public String getModule() {
        return this.module_;
    }

    public void setModule(String module) {
        this.module_ = module;
    }

    public void setModuleType(String type) {
        this.moduleType_ = type;
    }

    public String getEarProject() {
        return this.earProject_;
    }

    public String getEar() {
        return this.ear_;
    }

    public void setEar(String ear) {
        this.ear_ = ear;
    }

    public void setStartService(boolean startService) {
        this.run_ = startService;
    }

    public void setTestService(boolean testService) {
        this.test_ = testService;
    }

    public void setPublishService(boolean publishService) {
        this.publish_ = publishService;
    }

    public void setGenerateProxy(boolean genProxy) {
        this.client_ = genProxy;
    }
}

