/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.provisional.env.core.uri;

import java.io.File;
import java.util.LinkedList;
import org.eclipse.wst.command.internal.provisional.env.core.Command;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.uri.URI;
import org.eclipse.wst.command.internal.provisional.env.core.uri.URIException;

public abstract class NativeFileCommand
implements Command {
    protected String name;
    protected String description;
    protected URI[] urisToRead;
    protected URI[] urisToWrite;

    protected NativeFileCommand() {
        this(null, null);
    }

    protected NativeFileCommand(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setURIsToRead(URI[] urisToRead) {
        this.urisToRead = urisToRead;
    }

    public URI[] getURIsToRead() {
        return this.urisToRead;
    }

    public void setURIsToWrite(URI[] urisToWrite) {
        this.urisToWrite = urisToWrite;
    }

    public URI[] getURIsToWrite() {
        return this.urisToWrite;
    }

    public Status execute(Environment environment) {
        File[] filesToRead = this.getFiles(this.urisToRead);
        File[] filesToWrite = this.getFiles(this.urisToWrite);
        this.preProcess(filesToRead, filesToWrite);
        Status status = this.execute(environment, filesToRead, filesToWrite);
        this.postProcess(filesToRead, filesToWrite);
        return status;
    }

    public abstract Status execute(Environment var1, File[] var2, File[] var3);

    public boolean isUndoable() {
        return false;
    }

    public Status undo(Environment environment) {
        return null;
    }

    public boolean isRedoable() {
        return false;
    }

    public Status redo(Environment environment) {
        return null;
    }

    private void preProcess(File[] filesToRead, File[] filesToWrite) {
    }

    private void postProcess(File[] filesToRead, File[] filesToWrite) {
    }

    private File[] getFiles(URI[] uris) {
        LinkedList<File> list = new LinkedList<File>();
        if (uris != null) {
            int i = 0;
            while (i < uris.length) {
                if (uris[i].isAvailableAsFile()) {
                    try {
                        list.add(uris[i].asFile());
                    }
                    catch (URIException uRIException) {}
                }
                ++i;
            }
        }
        return list.toArray(new File[0]);
    }
}

