/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.datatransfer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.datatransfer.BuildFileCreator;
import org.eclipse.ant.internal.ui.datatransfer.DataTransferMessages;
import org.eclipse.ant.internal.ui.datatransfer.EclipseClasspath;
import org.eclipse.ant.internal.ui.datatransfer.ExportUtil;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class AntBuildfileExportPage
extends WizardPage {
    private CheckboxTableViewer fTableViewer;
    private List fSelectedJavaProjects = new ArrayList();

    public AntBuildfileExportPage() {
        super("AntBuildfileExportWizardPage");
        this.setPageComplete(false);
        this.setTitle(DataTransferMessages.AntBuildfileExportPage_0);
        this.setDescription(DataTransferMessages.AntBuildfileExportPage_1);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)data);
        this.initializeDialogUnits((Control)composite);
        Label label = new Label(composite, 16384);
        label.setText(DataTransferMessages.AntBuildfileExportPage_2);
        Table table = new Table(composite, 2848);
        this.fTableViewer = new CheckboxTableViewer(table);
        table.setLayout((Layout)new TableLayout());
        data = new GridData(4, 4, true, true);
        data.heightHint = 300;
        table.setLayoutData((Object)data);
        this.fTableViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider(){

            public Object[] getElements(Object element) {
                if (element instanceof IJavaProject[]) {
                    return (IJavaProject[])element;
                }
                return null;
            }
        });
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    AntBuildfileExportPage.this.fSelectedJavaProjects.add(event.getElement());
                } else {
                    AntBuildfileExportPage.this.fSelectedJavaProjects.remove(event.getElement());
                }
                AntBuildfileExportPage.this.updateEnablement();
            }
        });
        this.initializeProjects();
        this.setControl((Control)composite);
        this.updateEnablement();
        Dialog.applyDialogFont((Control)parent);
    }

    private void initializeProjects() {
        IJavaProject[] javaProjects;
        IWorkspaceRoot rootWorkspace = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)rootWorkspace);
        try {
            javaProjects = javaModel.getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            javaProjects = new IJavaProject[]{};
        }
        this.fTableViewer.setInput((Object)javaProjects);
        if (this.fSelectedJavaProjects != null) {
            this.fTableViewer.setCheckedElements((Object[])this.fSelectedJavaProjects.toArray(new IJavaProject[this.fSelectedJavaProjects.size()]));
        }
    }

    private void updateEnablement() {
        boolean complete = true;
        if (this.fSelectedJavaProjects.size() == 0) {
            this.setMessage(null);
            complete = false;
        }
        if (complete) {
            this.setMessage(null);
        }
        this.setPageComplete(complete);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fTableViewer.getTable().setFocus();
        }
    }

    protected void setSelectedProjects(List selectedJavaProjects) {
        this.fSelectedJavaProjects.addAll(selectedJavaProjects);
    }

    public boolean generateBuildfiles() {
        this.setErrorMessage(null);
        TreeSet<IJavaProject> projects = new TreeSet<IJavaProject>(ExportUtil.getJavaProjectComparator());
        Iterator javaProjects = this.fSelectedJavaProjects.iterator();
        while (javaProjects.hasNext()) {
            IJavaProject javaProject = (IJavaProject)javaProjects.next();
            try {
                projects.addAll(ExportUtil.getClasspathProjectsRecursive(javaProject));
            }
            catch (JavaModelException e) {
                AntUIPlugin.log(e);
                return false;
            }
            projects.add(javaProject);
        }
        List confirmOverwrite = this.getConfirmOverwriteSet(projects);
        if (confirmOverwrite.size() > 0) {
            String message = String.valueOf(DataTransferMessages.AntBuildfileExportPage_3) + ExportUtil.NEWLINE + EclipseClasspath.toString(confirmOverwrite, ExportUtil.NEWLINE);
            if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)DataTransferMessages.AntBuildfileExportPage_4, (String)message)) {
                return true;
            }
        }
        ArrayList<String> cyclicProjects = new ArrayList<String>();
        javaProjects = projects.iterator();
        Throwable problem = null;
        while (javaProjects.hasNext()) {
            IJavaProject javaProject = (IJavaProject)javaProjects.next();
            try {
                BuildFileCreator.create(javaProject);
            }
            catch (JavaModelException e) {
                problem = e;
            }
            catch (TransformerConfigurationException e) {
                problem = e;
            }
            catch (ParserConfigurationException e) {
                problem = e;
            }
            catch (TransformerException e) {
                problem = e;
            }
            catch (IOException e) {
                problem = e;
            }
            catch (CoreException e) {
                problem = e;
            }
            if (problem != null) {
                AntUIPlugin.log(problem);
                this.setErrorMessage(MessageFormat.format(DataTransferMessages.AntBuildfileExportPage_10, problem.toString()));
                return false;
            }
            try {
                if (!ExportUtil.hasCyclicDependency(javaProject)) continue;
                cyclicProjects.add(javaProject.getProject().getName());
            }
            catch (CoreException e) {
                AntUIPlugin.log(e);
                this.setErrorMessage(MessageFormat.format(DataTransferMessages.AntBuildfileExportPage_10, e.toString()));
                return false;
            }
        }
        if (cyclicProjects.size() > 0) {
            String warningMessage = MessageFormat.format(String.valueOf(DataTransferMessages.AntBuildfileExportPage_6) + ExportUtil.NEWLINE + ExportUtil.NEWLINE + DataTransferMessages.AntBuildfileExportPage_7 + DataTransferMessages.AntBuildfileExportPage_8, String.valueOf(ExportUtil.NEWLINE) + EclipseClasspath.toString(cyclicProjects, ExportUtil.NEWLINE));
            MessageDialog.openWarning((Shell)this.getShell(), (String)DataTransferMessages.AntBuildfileExportPage_9, (String)warningMessage);
        }
        ArrayList<String> projectNames = new ArrayList<String>();
        Iterator iter = projects.iterator();
        while (iter.hasNext()) {
            IJavaProject project = (IJavaProject)iter.next();
            projectNames.add(project.getProject().getName());
        }
        String message = MessageFormat.format(String.valueOf(DataTransferMessages.AntBuildfileExportPage_5) + ExportUtil.NEWLINE, String.valueOf(ExportUtil.NEWLINE) + EclipseClasspath.toString(projectNames, ExportUtil.NEWLINE));
        MessageDialog.openInformation((Shell)this.getShell(), (String)DataTransferMessages.AntBuildfileExportPage_0, (String)message);
        return true;
    }

    private List getConfirmOverwriteSet(Set javaProjects) {
        ArrayList<String> result = new ArrayList<String>(javaProjects.size());
        Iterator iter = javaProjects.iterator();
        while (iter.hasNext()) {
            IJavaProject project = (IJavaProject)iter.next();
            if (!this.existsBuildFile(project)) continue;
            result.add(project.getProject().getName());
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean existsBuildFile(IJavaProject project) {
        BufferedReader in;
        block12: {
            String projectRoot = ExportUtil.getProjectRoot(project);
            File buildFile = new File(String.valueOf(projectRoot) + File.separator + "build.xml");
            if (!buildFile.exists()) return false;
            in = null;
            try {
                try {
                    String line;
                    in = new BufferedReader(new FileReader(buildFile));
                    int i = BuildFileCreator.WARNING.indexOf(ExportUtil.NEWLINE);
                    String warning = BuildFileCreator.WARNING.substring(0, i);
                    do {
                        if ((line = in.readLine()) != null) continue;
                        break block12;
                    } while (line.indexOf(warning) == -1);
                    Object var8_8 = null;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Object var8_10 = null;
                    try {
                        if (in == null) return false;
                        in.close();
                        return false;
                    }
                    catch (IOException iOException) {}
                    return false;
                }
                catch (IOException iOException) {
                    Object var8_11 = null;
                    try {}
                    catch (IOException iOException2) {}
                    if (in == null) return false;
                    in.close();
                    return false;
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                try {}
                catch (IOException iOException) {}
                if (in == null) throw throwable;
                in.close();
                throw throwable;
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            if (in == null) return false;
            in.close();
            return false;
        }
        Object var8_9 = null;
        try {}
        catch (IOException iOException) {}
        if (in == null) return true;
        in.close();
        return true;
    }
}

