/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class ResourceUtil {
    public static IFile getFileFor(IStructuredModel model) {
        if (model == null) {
            return null;
        }
        String path = model.getBaseLocation();
        if (path == null || path.length() == 0) {
            String id = model.getId();
            if (id == null) {
                return null;
            }
            path = id.toString();
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFileForLocation((IPath)new Path(path));
        return file;
    }

    public static IFile[] getFilesFor(IStructuredModel model) {
        IFile[] files = new IFile[]{};
        if (model != null) {
            String path = model.getBaseLocation();
            if (path == null || path.length() == 0) {
                String id = model.getId();
                if (id == null) {
                    return files;
                }
                path = id.toString();
            }
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            files = root.findFilesForLocation((IPath)new Path(path));
        }
        return files;
    }
}

