/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.internal.common.util.CommonUtil;
import org.eclipse.jst.j2ee.internal.delete.DeleteModuleOperation;
import org.eclipse.jst.j2ee.internal.delete.DeleteOptions;
import org.eclipse.jst.j2ee.internal.dialogs.DeleteEARDialog;
import org.eclipse.jst.j2ee.internal.dialogs.DeleteModuleDialog;
import org.eclipse.jst.j2ee.internal.dialogs.J2EEDeleteDialog;
import org.eclipse.jst.j2ee.internal.dialogs.J2EEDeleteUIConstants;
import org.eclipse.jst.j2ee.internal.earcreation.EAREditModel;
import org.eclipse.jst.j2ee.internal.earcreation.EARNatureRuntime;
import org.eclipse.jst.j2ee.internal.ejb.project.EJBNatureRuntime;
import org.eclipse.jst.j2ee.internal.plugin.CommonEditorUtility;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.frameworks.internal.operations.IHeadlessRunnableWithProgress;
import org.eclipse.wst.common.frameworks.internal.ui.WTPUIPlugin;

public class J2EEDeleteAction
extends SelectionDispatchAction
implements J2EEDeleteUIConstants {
    protected Shell shell;
    protected Set referencedProjects;
    protected List projects;
    protected DeleteOptions options;
    protected ISelectionProvider provider = null;
    protected DeleteModuleOperation deleteModuleOperation;

    public J2EEDeleteAction(IWorkbenchSite site, Shell parent) {
        super(site);
        this.setText(DELETE);
        this.shell = parent;
    }

    public J2EEDeleteAction(IWorkbenchSite site, ISelectionProvider newProvider) {
        super(site);
        this.setText(DELETE);
        this.shell = J2EEUIPlugin.getActiveWorkbenchWindow().getShell();
        this.provider = newProvider;
    }

    protected void reset() {
        this.referencedProjects = null;
        this.projects = null;
        this.options = null;
        if (this.deleteModuleOperation != null) {
            this.deleteModuleOperation.release();
            this.deleteModuleOperation = null;
        }
    }

    protected boolean getEnableStateBasedOnSelection(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        return this.isSelectionApplicable() && this.isSelectionSomeJ2EE();
    }

    protected void updateSelection(IStructuredSelection selection) {
        this.update((ISelection)selection);
    }

    protected boolean isSelectionApplicable() {
        StructuredSelection sel = (StructuredSelection)this.getSelection();
        Iterator it = sel.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (this.isJ2EEModule(o) || this.isApplication(o) || this.isProjectOrJavaProject(o)) continue;
            return false;
        }
        return true;
    }

    protected boolean isSelectionSomeJ2EE() {
        StructuredSelection sel = (StructuredSelection)this.getSelection();
        Iterator it = sel.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!this.isJ2EEModule(o) && !this.isApplication(o)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSelectionAllDDRoots() {
        StructuredSelection sel = (StructuredSelection)this.getSelection();
        Iterator it = sel.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (this.isJ2EEModule(o)) continue;
            return false;
        }
        return true;
    }

    protected boolean isSelectionAllApplications() {
        StructuredSelection sel = (StructuredSelection)this.getSelection();
        Iterator it = sel.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (this.isApplication(o)) continue;
            return false;
        }
        return true;
    }

    protected boolean isJ2EEModule(Object o) {
        if (o instanceof WorkbenchComponent) {
            WorkbenchComponent module = (WorkbenchComponent)o;
            String moduleType = module.getComponentType().getComponentTypeId();
            return moduleType.equals("jst.web") || moduleType.equals("jst.ejb");
        }
        return CommonUtil.isDeploymentDescriptorRoot((Object)o, (boolean)false);
    }

    protected boolean isApplication(Object o) {
        return o instanceof Application || this.isJ2EEApplicationProject(o);
    }

    protected boolean isProjectOrJavaProject(Object o) {
        return o instanceof IProject || o instanceof IJavaProject;
    }

    protected List getProjects() {
        if (this.projects == null) {
            this.projects = new ArrayList();
            StructuredSelection sel = (StructuredSelection)this.getSelection();
            Iterator iterator = sel.iterator();
            IProject project = null;
            IProject o = null;
            while (iterator.hasNext()) {
                o = (IProject)iterator.next();
                if (o instanceof JavaProject) {
                    o = ((JavaProject)o).getProject();
                }
                if (o instanceof IProject) {
                    this.projects.add(o);
                    this.addEJBClientProjectIfNecessary(o, this.projects);
                    continue;
                }
                if (o instanceof EObject) {
                    EObject obj = (EObject)o;
                    project = ProjectUtilities.getProject((EObject)obj);
                    if (project == null) {
                        throw new RuntimeException(J2EEUIMessages.getResourceString("Project_should_not_be_null_1_EXC_"));
                    }
                    this.projects.add(project);
                    this.addEJBClientProjectIfNecessary(project, this.projects);
                    continue;
                }
                throw new RuntimeException(J2EEUIMessages.getResourceString("Non-project_in_selection_2_EXC_"));
            }
        }
        return this.projects;
    }

    private void addEJBClientProjectIfNecessary(IProject project, List localProjects) {
        EJBNatureRuntime nature = EJBNatureRuntime.getRuntime((IProject)project);
        if (nature != null && nature.hasEJBClientJARProject()) {
            localProjects.add(nature.getEJBClientJARProject());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block13: {
            block12: {
                block11: {
                    block10: {
                        try {
                            J2EEDeleteDialog dlg = null;
                            if (this.isSelectionAllApplications()) {
                                dlg = new DeleteEARDialog(this.shell, this.getReferencedProjects());
                            } else if (this.isSelectionAllDDRoots()) {
                                dlg = new DeleteModuleDialog(this.shell);
                            } else {
                                if (this.confirmStandardDelete()) {
                                    this.runResourceDeleteAction();
                                }
                                Object var2_2 = null;
                                this.reset();
                                return;
                            }
                            dlg.open();
                            if (dlg.getReturnCode() == 1) {
                                break block10;
                            }
                            this.options = dlg.getDeleteOptions();
                            if (this.options == null) break block11;
                            this.options.setSelectedProjects(this.getProjects());
                            if (!this.ensureEditorsSaved()) break block12;
                            if (!this.validateState()) {
                                break block12;
                            }
                            this.deleteProjectsIfNecessary();
                            this.deleteMetadataIfNecessary();
                            this.presentStatusIfNeccessary();
                            break block13;
                        }
                        catch (Throwable throwable) {
                            Object var2_6 = null;
                            this.reset();
                            throw throwable;
                        }
                    }
                    Object var2_3 = null;
                    this.reset();
                    return;
                }
                Object var2_4 = null;
                this.reset();
                return;
            }
            Object var2_5 = null;
            this.reset();
            return;
        }
        Object var2_7 = null;
        this.reset();
    }

    private boolean ensureEditorsSaved() {
        return CommonEditorUtility.promptToSaveAllDirtyEditors();
    }

    protected boolean confirmStandardDelete() {
        return MessageDialog.openConfirm((Shell)this.shell, (String)DELETE_PROJECTS, (String)CUSTOM_DELETE_MIX_MATCH);
    }

    protected Set getReferencedProjects() {
        if (this.referencedProjects == null) {
            this.computeReferencedProjects();
        }
        return this.referencedProjects;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void computeReferencedProjects() {
        this.getProjects();
        this.referencedProjects = new HashSet();
        int i = 0;
        while (i < this.projects.size()) {
            IProject project = (IProject)this.projects.get(i);
            EARNatureRuntime runtime = EARNatureRuntime.getRuntime((IProject)project);
            if (runtime != null) {
                Object var5_5;
                EAREditModel editModel = runtime.getEarEditModelForRead((Object)this);
                try {
                    this.referencedProjects.addAll(editModel.getModuleMappedProjects());
                }
                catch (Throwable throwable) {
                    var5_5 = null;
                    editModel.releaseAccess((Object)this);
                    throw throwable;
                }
                {
                    var5_5 = null;
                }
                editModel.releaseAccess((Object)this);
            }
            ++i;
        }
        return;
    }

    protected DeleteModuleOperation getDeleteModuleOperation() {
        if (this.deleteModuleOperation == null) {
            this.deleteModuleOperation = new DeleteModuleOperation(this.options);
        }
        return this.deleteModuleOperation;
    }

    protected void deleteMetadataIfNecessary() {
        if (!this.shouldDeleteMetaData()) {
            return;
        }
        IRunnableWithProgress runnable = WTPUIPlugin.getRunnableWithProgress((IHeadlessRunnableWithProgress)this.getDeleteModuleOperation());
        ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(this.shell);
        try {
            monitorDialog.run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            this.handleException(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected boolean shouldDeleteMetaData() {
        if (this.deleteProjectsFailedOrCancelled()) {
            return false;
        }
        return this.primShouldDeleteMetaData();
    }

    protected boolean primShouldDeleteMetaData() {
        return this.options != null && (this.options.shouldDeleteModules() || this.options.shouldDeleteModuleDependencies());
    }

    protected boolean deleteProjectsFailedOrCancelled() {
        if (this.options == null || !this.options.shouldDeleteProjects()) {
            return false;
        }
        return this.deletedProjectsExist();
    }

    protected boolean deletedProjectsExist() {
        List deletedProjects = this.options.getAllProjectsToDelete();
        int i = 0;
        while (i < deletedProjects.size()) {
            IProject project = (IProject)deletedProjects.get(i);
            if (project.exists()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void deleteProjectsIfNecessary() {
        if (this.options.shouldDeleteProjects()) {
            this.runResourceDeleteAction();
        }
    }

    protected void runResourceDeleteAction() {
        DeleteResourceAction action = new DeleteResourceAction(this.shell);
        List localProjects = null;
        localProjects = this.options == null ? this.getProjects() : this.options.getAllProjectsToDelete();
        Iterator it = localProjects.iterator();
        while (it.hasNext()) {
            IProject p = (IProject)it.next();
            if (p.exists()) continue;
            it.remove();
        }
        StructuredSelection sel = new StructuredSelection(localProjects);
        action.selectionChanged((IStructuredSelection)sel);
        action.run();
    }

    public void handleException(InvocationTargetException e) {
        Logger.getLogger().logError((Throwable)e);
        IStatus status = J2EEPlugin.newErrorStatus((int)4, (String)DELETE_ERROR, (Throwable)e);
        ErrorDialog.openError((Shell)this.shell, (String)DELETE_ERROR, (String)DELETE_NOT_COMPLETED, (IStatus)status);
    }

    public void update() {
        IStructuredSelection selection = null;
        if (this.provider != null) {
            selection = (IStructuredSelection)this.provider.getSelection();
            this.selectionChanged((ISelection)selection);
        } else {
            selection = (IStructuredSelection)this.getSelection();
            if (selection == null) {
                this.setEnabled(false);
            } else {
                this.updateSelection(selection);
            }
        }
    }

    protected boolean isJ2EEApplicationProject(Object o) {
        IProject project;
        boolean retVal = false;
        if (o instanceof IProject && EARNatureRuntime.hasRuntime((IProject)(project = (IProject)o))) {
            retVal = true;
        }
        return retVal;
    }

    protected void setEnabledFromSelection(IStructuredSelection selection) {
        if (selection == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(this.getEnableStateBasedOnSelection(selection));
        }
    }

    public void selectionChanged(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.setEnabledFromSelection((IStructuredSelection)selection);
        } else {
            super.selectionChanged(selection);
        }
    }

    protected boolean validateState() {
        return true;
    }

    protected void presentStatusIfNeccessary() {
        IStatus status = null;
        if (this.deleteModuleOperation != null) {
            status = this.deleteModuleOperation.getStatus();
        }
        if (status == null || status.isOK()) {
            return;
        }
        ErrorDialog.openError((Shell)this.shell, null, null, (IStatus)status, (int)4);
    }
}

