/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.wizard;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.internal.project.J2EENature;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class AvailableModuleProjectsProvider
implements IStructuredContentProvider,
ITableLabelProvider {
    private IDataModel model;

    public AvailableModuleProjectsProvider(IDataModel dataModel) {
        this.model = dataModel;
    }

    public Object[] getElements(Object inputElement) {
        IProject[] projects;
        ArrayList<IProject> validModuleProjects = null;
        if (inputElement instanceof IWorkspaceRoot && (projects = ((IWorkspaceRoot)inputElement).getProjects()).length > 0) {
            int j2eeVersion = this.model.getIntProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION");
            int i = 0;
            while (i < projects.length) {
                if (this.isValid(projects[i], j2eeVersion)) {
                    if (validModuleProjects == null) {
                        validModuleProjects = new ArrayList<IProject>();
                    }
                    validModuleProjects.add(projects[i]);
                }
                ++i;
            }
        }
        if (validModuleProjects == null) {
            return new Object[0];
        }
        return validModuleProjects.toArray();
    }

    private boolean isValid(IProject project, int j2eeVersion) {
        try {
            if (project.hasNature("org.eclipse.jst.j2ee.EARNature")) {
                return false;
            }
            J2EENature j2eeNature = J2EENature.getRegisteredRuntime((IProject)project);
            if (j2eeNature != null) {
                return j2eeNature.getJ2EEVersion() <= j2eeVersion;
            }
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        return ((IProject)element).getName();
    }

    public void dispose() {
        this.model = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

