/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.wizard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.j2ee.datamodel.properties.IEarComponentCreationDataModelProperties;
import org.eclipse.jst.j2ee.internal.earcreation.DefaultJ2EEComponentCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.jst.j2ee.internal.wizard.AvailableJ2EEComponentsContentProvider;
import org.eclipse.jst.j2ee.internal.wizard.DefaultJ2EEComponentCreationWizard;
import org.eclipse.jst.j2ee.internal.wizard.J2EEComponentLabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wst.common.componentcore.resources.ComponentHandle;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public class EARComponentCreationSecondPage
extends DataModelWizardPage
implements IEarComponentCreationDataModelProperties {
    private Button selectAllButton;
    private Button deselectAllButton;
    private Button newModuleButton;
    private CheckboxTableViewer moduleProjectsViewer;
    private boolean ignoreCheckedState = false;

    public EARComponentCreationSecondPage(IDataModel model, String pageName) {
        super(model, pageName);
        this.setTitle(J2EEUIMessages.getResourceString("EARComponentCreationWizard.secondPage.title"));
        this.setDescription(J2EEUIMessages.getResourceString("EARComponentCreationWizard.secondPage.desc"));
        this.setImageDescriptor(J2EEUIPlugin.getDefault().getImageDescriptor("ear_wiz"));
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IEarComponentCreationDataModel.J2EE_COMPONENT_LIST"};
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite modulesGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        modulesGroup.setLayout((Layout)layout);
        this.setInfopopID("org.eclipse.jst.j2ee.ui.NEW_EAR_ADD_MODULES_PAGE");
        GridData gridData = new GridData(768);
        modulesGroup.setLayoutData((Object)gridData);
        this.createModuleProjectOptions(modulesGroup);
        this.createButtonsGroup(modulesGroup);
        return modulesGroup;
    }

    private void createModuleProjectOptions(Composite modulesGroup) {
        this.moduleProjectsViewer = CheckboxTableViewer.newCheckList((Composite)modulesGroup, (int)2816);
        GridData gData = new GridData(1808);
        gData.widthHint = 200;
        gData.heightHint = 80;
        this.moduleProjectsViewer.getControl().setLayoutData((Object)gData);
        int j2eeVersion = this.getDataModel().getIntProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION");
        AvailableJ2EEComponentsContentProvider provider = new AvailableJ2EEComponentsContentProvider(j2eeVersion);
        this.moduleProjectsViewer.setContentProvider((IContentProvider)provider);
        this.moduleProjectsViewer.setLabelProvider((IBaseLabelProvider)new J2EEComponentLabelProvider());
        this.setCheckedItemsFromModel();
        this.moduleProjectsViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (!EARComponentCreationSecondPage.this.ignoreCheckedState) {
                    EARComponentCreationSecondPage.this.getDataModel().setProperty("IEarComponentCreationDataModel.J2EE_COMPONENT_LIST", (Object)EARComponentCreationSecondPage.this.getCheckedJ2EEElementsAsList());
                    EARComponentCreationSecondPage.this.getDataModel().setProperty("IEarComponentCreationDataModel.JAVA_PROJECT_LIST", (Object)EARComponentCreationSecondPage.this.getCheckedJavaProjectsAsList());
                }
            }
        });
        TableLayout tableLayout = new TableLayout();
        this.moduleProjectsViewer.getTable().setLayout((Layout)tableLayout);
        this.moduleProjectsViewer.getTable().setHeaderVisible(false);
        this.moduleProjectsViewer.getTable().setLinesVisible(false);
        this.moduleProjectsViewer.setSorter(null);
    }

    private void setCheckedItemsFromModel() {
        List components = (List)this.getDataModel().getProperty("IEarComponentCreationDataModel.J2EE_COMPONENT_LIST");
        this.moduleProjectsViewer.setCheckedElements(components.toArray());
    }

    private void refreshModules() {
        this.moduleProjectsViewer.refresh();
        this.setCheckedItemsFromModel();
    }

    protected List getCheckedJ2EEElementsAsList() {
        ArrayList<Object> list;
        Object[] elements = this.moduleProjectsViewer.getCheckedElements();
        if (elements == null || elements.length == 0) {
            list = Collections.EMPTY_LIST;
        } else {
            list = new ArrayList<Object>();
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof ComponentHandle) {
                    list.add(elements[i]);
                }
                ++i;
            }
        }
        return list;
    }

    protected List getCheckedJavaProjectsAsList() {
        ArrayList<Object> list;
        Object[] elements = this.moduleProjectsViewer.getCheckedElements();
        if (elements == null || elements.length == 0) {
            list = Collections.EMPTY_LIST;
        } else {
            list = new ArrayList<Object>();
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof IProject) {
                    list.add(elements[i]);
                }
                ++i;
            }
        }
        return list;
    }

    protected void createButtonsGroup(Composite parent) {
        Composite buttonGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        buttonGroup.setLayout((Layout)layout);
        buttonGroup.setLayoutData((Object)new GridData(1808));
        this.selectAllButton = new Button(buttonGroup, 8);
        this.selectAllButton.setText(J2EEUIMessages.getResourceString("10"));
        this.selectAllButton.addListener(13, (Listener)this);
        GridData gd = new GridData(256);
        gd.heightHint = 22;
        gd.widthHint = 120;
        this.selectAllButton.setLayoutData((Object)gd);
        this.deselectAllButton = new Button(buttonGroup, 8);
        this.deselectAllButton.setText(J2EEUIMessages.getResourceString("11"));
        this.deselectAllButton.addListener(13, (Listener)this);
        gd = new GridData(256);
        gd.heightHint = 22;
        gd.widthHint = 120;
        this.deselectAllButton.setLayoutData((Object)gd);
        this.newModuleButton = new Button(buttonGroup, 8);
        this.newModuleButton.setText(J2EEUIMessages.getResourceString("12"));
        this.newModuleButton.addListener(13, (Listener)this);
        gd = new GridData(256);
        gd.heightHint = 22;
        gd.widthHint = 120;
        this.newModuleButton.setLayoutData((Object)gd);
    }

    public void handleEvent(Event evt) {
        if (evt.widget == this.selectAllButton) {
            this.handleSelectAllButtonPressed();
        } else if (evt.widget == this.deselectAllButton) {
            this.handleDeselectAllButtonPressed();
        } else if (evt.widget == this.newModuleButton) {
            this.handleNewModuleButtonPressed();
        } else {
            super.handleEvent(evt);
        }
    }

    private void handleNewModuleButtonPressed() {
        IDataModel aModel = this.createNewModuleModel();
        DefaultJ2EEComponentCreationWizard wizard = new DefaultJ2EEComponentCreationWizard(aModel);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.create();
        if (dialog.open() != 1) {
            IWorkspaceRoot input = ResourcesPlugin.getWorkspace().getRoot();
            this.moduleProjectsViewer.setInput((Object)input);
            this.setNewModules(aModel);
            this.refreshModules();
        }
    }

    private void setNewModules(IDataModel defaultModel) {
        ArrayList newComponents = new ArrayList();
        this.collectNewComponents(defaultModel, newComponents);
        List oldComponents = (List)this.getDataModel().getProperty("IEarComponentCreationDataModel.J2EE_COMPONENT_LIST");
        newComponents.addAll(oldComponents);
        this.getDataModel().setProperty("IEarComponentCreationDataModel.J2EE_COMPONENT_LIST", newComponents);
    }

    private void collectNewComponents(IDataModel defaultModel, List newProjects) {
        this.collectComponents(defaultModel.getNestedModel("DefaultJ2EEComponentCreationDataModel.NESTED_MODEL_EJB"), newProjects);
        this.collectComponents(defaultModel.getNestedModel("DefaultJ2EEComponentCreationDataModel.NESTED_MODEL_WEB"), newProjects);
        this.collectComponents(defaultModel.getNestedModel("DefaultJ2EEComponentCreationDataModel.NESTED_MODEL_CLIENT"), newProjects);
        this.collectComponents(defaultModel.getNestedModel("DefaultJ2EEComponentCreationDataModel.NESTED_MODEL_JCA"), newProjects);
    }

    private void collectComponents(IDataModel compDM, List newProjects) {
        if (compDM != null) {
            String projectName = compDM.getStringProperty("IComponentCreationDataModelProperties.PROJECT_NAME");
            if (projectName == null) {
                return;
            }
            IProject project = ProjectUtilities.getProject((String)projectName);
            String compName = compDM.getStringProperty("IComponentCreationDataModelProperties.COMPONENT_NAME");
            if (project != null && project.exists()) {
                newProjects.add(ComponentHandle.create((IProject)project, (String)compName));
            }
        }
    }

    private IDataModel createNewModuleModel() {
        IDataModel defaultModel = DataModelFactory.createDataModel((IDataModelProvider)new DefaultJ2EEComponentCreationDataModelProvider());
        String projectName = this.model.getStringProperty("IComponentCreationDataModelProperties.PROJECT_NAME");
        defaultModel.setProperty("DefaultJ2EEComponentCreationDataModel.PROJECT_NAME", (Object)projectName);
        String earName = this.model.getStringProperty("IComponentCreationDataModelProperties.COMPONENT_NAME");
        defaultModel.setProperty("DefaultJ2EEComponentCreationDataModel.EAR_NAME", (Object)earName);
        int j2eeVersion = this.model.getIntProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION");
        defaultModel.setProperty("DefaultJ2EEComponentCreationDataModel.J2EE_VERSION", (Object)new Integer(j2eeVersion));
        return defaultModel;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleDeselectAllButtonPressed() {
        this.ignoreCheckedState = true;
        try {
            this.moduleProjectsViewer.setAllChecked(false);
            this.getDataModel().setProperty("IEarComponentCreationDataModel.J2EE_COMPONENT_LIST", null);
            this.getDataModel().setProperty("IEarComponentCreationDataModel.JAVA_PROJECT_LIST", null);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.ignoreCheckedState = false;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.ignoreCheckedState = false;
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleSelectAllButtonPressed() {
        this.ignoreCheckedState = true;
        try {
            this.moduleProjectsViewer.setAllChecked(true);
            this.getDataModel().setProperty("IEarComponentCreationDataModel.J2EE_COMPONENT_LIST", (Object)this.getCheckedJ2EEElementsAsList());
            this.getDataModel().setProperty("IEarComponentCreationDataModel.JAVA_PROJECT_LIST", (Object)this.getCheckedJavaProjectsAsList());
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.ignoreCheckedState = false;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.ignoreCheckedState = false;
            return;
        }
    }

    protected void enter() {
        IWorkspaceRoot input = ResourcesPlugin.getWorkspace().getRoot();
        this.moduleProjectsViewer.setInput((Object)input);
        super.enter();
    }
}

