/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.wizard;

import java.io.File;
import org.eclipse.core.internal.localstore.CoreFileSystemLibrary;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ApplicationClientFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.CommonarchiveFactoryImpl;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class ImportUtil {
    public static final int UNKNOWN = 0;
    public static final int EARFILE = 1;
    public static final int EJBJARFILE = 2;
    public static final int WARFILE = 3;
    public static final int CLIENTJARFILE = 4;
    public static final int RARFILE = 5;
    public static final int IMPORTCLASSTYPE = 6;
    public static final int J2EE14 = 256;
    public static final int J2EE13 = 128;
    public static final int J2EE12 = 64;
    public static final int J2EESpec = 448;
    public static final String EAR = "EAR";
    public static final String EJB = "EJB";
    public static final String WAR = "WEB";
    public static final String JAR = "CLIENT";
    public static final String RAR = "RAR";
    public static final String[] SUFFIXES = new String[]{"", "EAR", "EJB", "WEB", "CLIENT", "RAR", ""};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getFileType(String fileName) {
        int n;
        Archive anArchive;
        block7: {
            block6: {
                anArchive = null;
                try {
                    try {
                        anArchive = CommonarchiveFactoryImpl.getActiveFactory().openArchive(fileName);
                        int archiveType = ImportUtil.getArchiveType(anArchive);
                        if (archiveType == 0 && ImportUtil.isImportClassType(fileName)) {
                            Object var3_3 = null;
                            if (anArchive == null) return 6;
                            break block6;
                        }
                        n = archiveType;
                        break block7;
                    }
                    catch (Exception exception) {
                        if (ImportUtil.isImportClassType(fileName)) {
                            Object var3_5 = null;
                            if (anArchive == null) return 6;
                            if (!anArchive.isOpen()) return 6;
                            anArchive.close();
                            return 6;
                        }
                        Object var3_6 = null;
                        if (anArchive == null) return 0;
                        if (!anArchive.isOpen()) return 0;
                        anArchive.close();
                        return 0;
                    }
                }
                catch (Throwable throwable) {
                    Object var3_7 = null;
                    if (anArchive == null) throw throwable;
                    if (!anArchive.isOpen()) throw throwable;
                    anArchive.close();
                    throw throwable;
                }
            }
            if (!anArchive.isOpen()) return 6;
            anArchive.close();
            return 6;
        }
        Object var3_4 = null;
        if (anArchive == null) return n;
        if (!anArchive.isOpen()) return n;
        anArchive.close();
        return n;
    }

    public static int getVersionedFileType(String fileName) {
        int n;
        Archive anArchive = null;
        try {
            int archiveType = 0;
            try {
                anArchive = CommonarchiveFactoryImpl.getActiveFactory().openArchive(fileName);
                try {
                    if (anArchive.isEJBJarFile()) {
                        archiveType = 2;
                        EJBJar ejbJar = ((EJBJarFile)anArchive).getDeploymentDescriptor();
                        if (ejbJar.getVersionID() == 11) {
                            archiveType |= 0x40;
                        } else if (ejbJar.getVersionID() == 20) {
                            archiveType |= 0x80;
                        } else if (ejbJar.getVersionID() == 21) {
                            archiveType |= 0x100;
                        }
                    } else if (anArchive.isWARFile()) {
                        archiveType = 3;
                        WebApp war = ((WARFile)anArchive).getDeploymentDescriptor();
                        if (war.getVersionID() == 22) {
                            archiveType |= 0x40;
                        } else if (war.getVersionID() == 23) {
                            archiveType |= 0x80;
                        } else if (war.getVersionID() == 24) {
                            archiveType |= 0x100;
                        }
                    } else if (anArchive.isApplicationClientFile()) {
                        archiveType = 4;
                        ApplicationClient appClient = ((ApplicationClientFile)anArchive).getDeploymentDescriptor();
                        if (appClient.getVersionID() == 12) {
                            archiveType |= 0x40;
                        } else if (appClient.getVersionID() == 13) {
                            archiveType |= 0x80;
                        } else if (appClient.getVersionID() == 14) {
                            archiveType |= 0x100;
                        }
                    } else if (anArchive.isRARFile()) {
                        archiveType = 133;
                    } else if (anArchive.isEARFile()) {
                        archiveType = 1;
                        Application app = ((EARFile)anArchive).getDeploymentDescriptor();
                        if (app.getVersionID() == 12) {
                            archiveType |= 0x40;
                        } else if (app.getVersionID() == 13) {
                            archiveType |= 0x80;
                        } else if (app.getVersionID() == 14) {
                            archiveType |= 0x100;
                        }
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {}
            if (archiveType == 0 && ImportUtil.isImportClassType(fileName)) {
                archiveType = 6;
            }
            n = archiveType;
            Object var4_8 = null;
        }
        catch (Throwable throwable) {
            block38: {
                Object var4_9 = null;
                if (anArchive == null || !anArchive.isOpen()) break block38;
                anArchive.close();
            }
            throw throwable;
        }
        if (anArchive != null && anArchive.isOpen()) {
            anArchive.close();
        }
        return n;
    }

    public static int getArchiveType(Archive anArchive) {
        int type = 0;
        try {
            if (anArchive.isEJBJarFile()) {
                type = 2;
            } else if (anArchive.isWARFile()) {
                type = 3;
            } else if (anArchive.isApplicationClientFile()) {
                type = 4;
            } else if (anArchive.isRARFile()) {
                type = 5;
            } else if (anArchive.isEARFile()) {
                type = 1;
            }
        }
        catch (Exception exception) {}
        return type;
    }

    public static boolean isImportClassType(String fileName) {
        File file = new File(fileName);
        String fileExtension = ImportUtil.getExtension(file);
        if (file.isFile()) {
            if (fileExtension.equalsIgnoreCase("jar") || fileExtension.equalsIgnoreCase("zip") || fileExtension.equalsIgnoreCase("class")) {
                return true;
            }
        } else if (file.isDirectory()) {
            return false;
        }
        return false;
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static String findMatchingProjectName(String projectName) {
        if (projectName.trim().length() > 0) {
            IWorkspaceRoot root = J2EEPlugin.getWorkspace().getRoot();
            IProject[] projects = root.getProjects();
            String lowerCaseName = projectName.toLowerCase();
            if (projectName == null || projectName.length() == 0) {
                if (projects.length == 1) {
                    return projects[0].getName();
                }
                return null;
            }
            int i = 0;
            while (i < projects.length) {
                if (projects[i].exists() && (CoreFileSystemLibrary.isCaseSensitive() ? projects[i].getName().equals(projectName) : projects[i].getName().toLowerCase().equals(lowerCaseName))) {
                    return projects[i].getName();
                }
                ++i;
            }
        }
        return projectName;
    }
}

