/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.wizard;

import java.util.List;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jst.j2ee.application.internal.operations.ClassPathSelection;
import org.eclipse.jst.j2ee.application.internal.operations.ClasspathElement;
import org.eclipse.jst.j2ee.application.internal.operations.UpdateManifestDataModel;
import org.eclipse.jst.j2ee.datamodel.properties.IJ2EEComponentCreationDataModelProperties;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.wizard.AvailableJarsProvider;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperationDataModel;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperationDataModelEvent;

public class J2EEModulesDependencyPage
extends DataModelWizardPage
implements IJ2EEComponentCreationDataModelProperties {
    private CheckboxTableViewer availableJarsViewer;

    public J2EEModulesDependencyPage(IDataModel model, String pageName) {
        super(model, pageName);
        this.setTitle(J2EEUIMessages.getResourceString("27"));
        this.setDescription(J2EEUIMessages.getResourceString("28"));
    }

    protected void enter() {
        super.enter();
        this.updateJarViewer();
    }

    private void updateJarViewer() {
        ClassPathSelection classPathSelection = (ClassPathSelection)this.getDataModel().getProperty("IComponentCreationDataModelProperties.CLASSPATH_SELECTION");
        if (this.availableJarsViewer.getInput() != classPathSelection) {
            this.availableJarsViewer.setInput((Object)classPathSelection);
        }
    }

    protected String[] getValidationPropertyNames() {
        return null;
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        this.setInfopopID("org.eclipse.jst.j2ee.ui.EJB_NEW_EJB_WIZARD_PAGE3");
        Label projectLabel = new Label(composite, 0);
        projectLabel.setText(WorkbenchMessages.NewProject_title);
        Text projectText = new Text(composite, 2056);
        this.synchHelper.synchText(projectText, "IComponentCreationDataModelProperties.PROJECT_NAME", null);
        GridData gd = new GridData(768);
        projectText.setLayoutData((Object)gd);
        Label earLabel = new Label(composite, 0);
        earLabel.setText(J2EEUIMessages.getResourceString("13"));
        Text earText = new Text(composite, 2056);
        this.synchHelper.synchText(earText, "IJ2EEComponentCreationDataModelProperties.EAR_COMPONENT_NAME", null);
        gd = new GridData(768);
        earText.setLayoutData((Object)gd);
        Label spacerLabel = new Label(composite, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        spacerLabel.setLayoutData((Object)gd);
        Label jarsLabel = new Label(composite, 0);
        jarsLabel.setText(J2EEUIMessages.getResourceString("29"));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        jarsLabel.setLayoutData((Object)gd);
        Composite tableComposite = new Composite(composite, 0);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 0;
        gd.heightHint = 60;
        gd.widthHint = 200;
        tableComposite.setLayoutData((Object)gd);
        GridLayout tableLayout = new GridLayout();
        tableLayout.marginWidth = 0;
        tableComposite.setLayout((Layout)tableLayout);
        this.createAvailableJarsList(tableComposite);
        spacerLabel = new Label(composite, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        spacerLabel.setLayoutData((Object)gd);
        Label classpathLabel = new Label(composite, 0);
        classpathLabel.setText(J2EEUIMessages.getResourceString("30"));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        classpathLabel.setLayoutData((Object)gd);
        Text classpathText = new Text(composite, 2122);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.heightHint = 30;
        classpathText.setLayoutData((Object)gd);
        return composite;
    }

    protected void createAvailableJarsList(Composite listGroup) {
        this.availableJarsViewer = CheckboxTableViewer.newCheckList((Composite)listGroup, (int)67616);
        this.addResizeListenerToTable();
        AvailableJarsProvider provider = new AvailableJarsProvider();
        this.availableJarsViewer.setContentProvider((IContentProvider)provider);
        this.availableJarsViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.availableJarsViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                J2EEModulesDependencyPage.this.availableJARCheckStateChanged(event);
            }
        });
        Table table = this.availableJarsViewer.getTable();
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(200, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(200, true));
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.availableJarsViewer.setSorter(null);
        GridData gd = new GridData(1808);
        table.setLayoutData((Object)gd);
        TableColumn fileNameColumn = new TableColumn(table, 0);
        fileNameColumn.setText(J2EEUIMessages.getResourceString("31"));
        fileNameColumn.setResizable(true);
        TableColumn projectColumn = new TableColumn(table, 0);
        projectColumn.setText(J2EEUIMessages.getResourceString("32"));
        projectColumn.setResizable(true);
        this.updateJarViewer();
    }

    public void availableJARCheckStateChanged(CheckStateChangedEvent event) {
        ClasspathElement element = (ClasspathElement)event.getElement();
        element.setSelected(event.getChecked());
        String classEntry = element.getText();
        UpdateManifestDataModel updateManifest = (UpdateManifestDataModel)this.model.getProperty("IComponentCreationDataModelProperties.NESTED_UPDATE_MANIFEST_DM");
        List classpathList = (List)updateManifest.getProperty("UpdateManifestDataModel.CLASSPATH_LIST");
        if (event.getChecked()) {
            if (!classpathList.contains(classEntry)) {
                classpathList.add(classEntry);
            }
        } else if (classpathList.contains(classEntry)) {
            classpathList.remove(classEntry);
        }
        updateManifest.setProperty("UpdateManifestDataModel.CLASSPATH_LIST", (Object)classpathList);
        updateManifest.propertyChanged(new WTPOperationDataModelEvent((WTPOperationDataModel)updateManifest, "UpdateManifestDataModel.CLASSPATH_LIST", 1));
    }

    protected void addResizeListenerToTable() {
        Table aTable = this.availableJarsViewer.getTable();
        aTable.addControlListener((ControlListener)new ControlAdapter(){
            boolean fResized = false;

            public void controlResized(ControlEvent e) {
                if (e.widget instanceof Table && !this.fResized) {
                    Table table = (Table)e.widget;
                    Display.getDefault().asyncExec(new Runnable(this, table){
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ Table val$table;
                        {
                            this.this$1 = var1_1;
                            this.val$table = table;
                        }

                        public void run() {
                            if (this.val$table.isDisposed() || this.this$1.fResized) {
                                return;
                            }
                            Point size = this.val$table.getSize();
                            if (size.x > 4) {
                                this.this$1.setResized(this.val$table);
                                int newSize = size.x / 2 - 2;
                                TableColumn column = this.val$table.getColumn(0);
                                if (column != null && !column.isDisposed()) {
                                    column.setWidth(newSize);
                                }
                                if ((column = this.val$table.getColumn(1)) != null && !column.isDisposed()) {
                                    column.setWidth(newSize);
                                }
                            }
                        }
                    });
                }
            }

            public void setResized(Table table) {
                this.fResized = true;
                table.removeControlListener((ControlListener)this);
            }
        });
    }
}

