/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.tabletree;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.SourceEditingRuntimeException;
import org.eclipse.wst.sse.ui.internal.StructuredTextEditor;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.provisional.StructuredTextEditorXML;
import org.eclipse.wst.xml.ui.internal.tabletree.IDesignViewer;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLEditorMessages;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorActionBarContributor;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLTableTreeViewer;

public class XMLMultiPageEditorPart
extends MultiPageEditorPart {
    private int fDesignPageIndex;
    private IDesignViewer fDesignViewer;
    private PartListener fPartListener;
    IPropertyListener fPropertyListener = null;
    private int fSourcePageIndex;
    private StructuredTextEditor fTextEditor;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    void _firePropertyChange(int property) {
        super.firePropertyChange(property);
    }

    private void addSourcePage() throws PartInitException {
        try {
            this.fSourcePageIndex = this.addPage((IEditorPart)this.fTextEditor, this.getEditorInput());
            this.setPageText(this.fSourcePageIndex, XMLEditorMessages.XMLMultiPageEditorPart_0);
            this.fTextEditor.update();
            this.firePropertyChange(1);
            this.fTextEditor.getTextViewer().addTextInputListener((ITextInputListener)new TextInputListener());
        }
        catch (PartInitException exception) {
            this.dispose();
            Logger.logException(exception);
            throw new SourceEditingRuntimeException((Throwable)exception, XMLEditorMessages.An_error_has_occurred_when1_ERROR_);
        }
    }

    private void connectDesignPage() {
        if (this.fDesignViewer != null) {
            this.fDesignViewer.setViewerSelectionManager(this.fTextEditor.getViewerSelectionManager());
            this.fDesignViewer.setModel(this.getModel());
        }
    }

    private void createAndAddDesignPage() {
        IDesignViewer tableTreeViewer;
        this.fDesignViewer = tableTreeViewer = this.createDesignPage();
        this.fDesignPageIndex = this.addPage(tableTreeViewer.getControl());
        this.setPageText(this.fDesignPageIndex, tableTreeViewer.getTitle());
    }

    protected IDesignViewer createDesignPage() {
        XMLTableTreeViewer tableTreeViewer = new XMLTableTreeViewer(this.getContainer());
        XMLUIPlugin.getInstance().getWorkbench().getHelpSystem().setHelp(tableTreeViewer.getControl(), "org.eclipse.wst.xml.ui.design.xmlm3000");
        return tableTreeViewer;
    }

    protected void createPages() {
        try {
            this.createSourcePage();
            this.createAndAddDesignPage();
            this.addSourcePage();
            this.connectDesignPage();
            int activePageIndex = this.getPreferenceStore().getInt("lastActivePage");
            if (activePageIndex >= 0 && activePageIndex < this.getPageCount()) {
                this.setActivePage(activePageIndex);
            }
        }
        catch (PartInitException e) {
            Logger.logException(e);
            throw new RuntimeException(e);
        }
    }

    protected IEditorSite createSite(IEditorPart editor) {
        Object site = null;
        site = editor == this.fTextEditor ? new MultiPageEditorSite(this, editor){

            public IEditorActionBarContributor getActionBarContributor() {
                IEditorActionBarContributor contributor = super.getActionBarContributor();
                IEditorActionBarContributor multiContributor = XMLMultiPageEditorPart.this.getEditorSite().getActionBarContributor();
                if (multiContributor instanceof XMLMultiPageEditorActionBarContributor) {
                    contributor = ((XMLMultiPageEditorActionBarContributor)multiContributor).sourceViewerActionContributor;
                }
                return contributor;
            }
        } : super.createSite(editor);
        return site;
    }

    protected void createSourcePage() throws PartInitException {
        this.fTextEditor = this.createTextEditor();
        this.fTextEditor.setEditorPart((IEditorPart)this);
        if (this.fPropertyListener == null) {
            this.fPropertyListener = new PropertyListener();
        }
        this.fTextEditor.addPropertyListener(this.fPropertyListener);
    }

    private StructuredTextEditor createTextEditor() {
        return new StructuredTextEditorXML();
    }

    private void disconnectDesignPage() {
        if (this.fDesignViewer != null) {
            this.fDesignViewer.setModel(null);
            this.fDesignViewer.setViewerSelectionManager(null);
        }
    }

    public void dispose() {
        Logger.trace("Source Editor", "StructuredTextMultiPageEditorPart::dispose entry");
        this.disconnectDesignPage();
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        window.getPartService().removePartListener((IPartListener)this.fPartListener);
        window.getShell().removeShellListener((ShellListener)this.fPartListener);
        if (this.fTextEditor != null && this.fPropertyListener != null) {
            this.fTextEditor.removePropertyListener(this.fPropertyListener);
        }
        super.dispose();
        Logger.trace("Source Editor", "StructuredTextMultiPageEditorPart::dispose exit");
    }

    public void doSave(IProgressMonitor monitor) {
        this.fTextEditor.doSave(monitor);
    }

    public void doSaveAs() {
        this.fTextEditor.doSaveAs();
    }

    public Object getAdapter(Class key) {
        Object result = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.ui.internal.tabletree.IDesignViewer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz) {
            result = this.fDesignViewer;
        } else {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.ui.ide.IGotoMarker");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (key.equals(clazz2)) {
                result = new IGotoMarker(){

                    public void gotoMarker(IMarker marker) {
                        XMLMultiPageEditorPart.this.gotoMarker(marker);
                    }
                };
            } else if (this.fTextEditor != null) {
                result = this.fTextEditor.getAdapter(key);
            }
        }
        return result;
    }

    private IStructuredModel getModel() {
        IStructuredModel model = null;
        if (this.fTextEditor != null) {
            model = this.fTextEditor.getModel();
        }
        return model;
    }

    private IPreferenceStore getPreferenceStore() {
        return XMLUIPlugin.getDefault().getPreferenceStore();
    }

    StructuredTextEditor getTextEditor() {
        return this.fTextEditor;
    }

    public String getTitle() {
        String title = null;
        if (this.getTextEditor() == null) {
            if (this.getEditorInput() != null) {
                title = this.getEditorInput().getName();
            }
        } else {
            title = this.getTextEditor().getTitle();
        }
        if (title == null) {
            title = this.getPartName();
        }
        return title;
    }

    void gotoMarker(IMarker marker) {
        this.setActivePage(this.fSourcePageIndex);
        IDE.gotoMarker((IEditorPart)this.fTextEditor, (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        try {
            super.init(site, input);
            if (this.fPartListener == null) {
                this.fPartListener = new PartListener();
            }
            IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
            window.getPartService().addPartListener((IPartListener)this.fPartListener);
            window.getShell().addShellListener((ShellListener)this.fPartListener);
        }
        catch (Exception e) {
            Logger.logException("exception initializing " + ((Object)((Object)this)).getClass().getName(), e);
        }
        this.setPartName(input.getName());
    }

    public boolean isSaveAsAllowed() {
        return this.fTextEditor != null && this.fTextEditor.isSaveAsAllowed();
    }

    public boolean isSaveOnCloseNeeded() {
        if (this.fTextEditor != null) {
            return this.fTextEditor.isSaveOnCloseNeeded();
        }
        return this.isDirty();
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        this.saveLastActivePageIndex(newPageIndex);
    }

    void postOnDisplayQue(Runnable runnable) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        if (windows != null && windows.length > 0) {
            Display display = windows[0].getShell().getDisplay();
            display.asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    void safelySanityCheckState() {
        if (this.getTextEditor() != null) {
            this.getTextEditor().safelySanityCheckState(this.getEditorInput());
        }
    }

    private void saveLastActivePageIndex(int newPageIndex) {
        this.getPreferenceStore().setValue("lastActivePage", newPageIndex);
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (this.fDesignViewer != null) {
            this.fDesignViewer.setModel(this.getModel());
        }
        this.setPartName(input.getName());
    }

    class PartListener
    extends ShellAdapter
    implements IPartListener {
        private IWorkbenchPart fActivePart;
        private boolean fIsHandlingActivation = false;

        PartListener() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void handleActivation() {
            if (this.fIsHandlingActivation) {
                return;
            }
            if (this.fActivePart != XMLMultiPageEditorPart.this) return;
            this.fIsHandlingActivation = true;
            try {
                XMLMultiPageEditorPart.this.safelySanityCheckState();
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                this.fIsHandlingActivation = false;
                throw throwable;
            }
            {
                Object var1_3 = null;
                this.fIsHandlingActivation = false;
                return;
            }
        }

        public void partActivated(IWorkbenchPart part) {
            this.fActivePart = part;
            this.handleActivation();
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            this.fActivePart = null;
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void shellActivated(ShellEvent e) {
            this.handleActivation();
        }
    }

    class PropertyListener
    implements IPropertyListener {
        PropertyListener() {
        }

        public void propertyChanged(Object source, int propId) {
            switch (propId) {
                case 257: 
                case 258: {
                    if (source != XMLMultiPageEditorPart.this.getTextEditor() || XMLMultiPageEditorPart.this.getTextEditor().getEditorInput() == XMLMultiPageEditorPart.this.getEditorInput()) break;
                    XMLMultiPageEditorPart.this.setInput(XMLMultiPageEditorPart.this.getTextEditor().getEditorInput());
                    Runnable runnable = new Runnable(this){
                        final /* synthetic */ PropertyListener this$1;
                        {
                            this.this$1 = propertyListener;
                        }

                        public void run() {
                            PropertyListener.access$0(this.this$1)._firePropertyChange(1);
                        }
                    };
                    XMLMultiPageEditorPart.this.postOnDisplayQue(runnable);
                    break;
                }
                case 1: {
                    if (source != XMLMultiPageEditorPart.this.getTextEditor() || XMLMultiPageEditorPart.this.getTextEditor().getEditorInput() == XMLMultiPageEditorPart.this.getEditorInput()) break;
                    XMLMultiPageEditorPart.this.setInput(XMLMultiPageEditorPart.this.getTextEditor().getEditorInput());
                    break;
                }
                default: {
                    if (source != XMLMultiPageEditorPart.this.getTextEditor()) break;
                    XMLMultiPageEditorPart.this._firePropertyChange(propId);
                }
            }
        }

        static /* synthetic */ XMLMultiPageEditorPart access$0(PropertyListener propertyListener) {
            return propertyListener.XMLMultiPageEditorPart.this;
        }
    }

    class TextInputListener
    implements ITextInputListener {
        TextInputListener() {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (XMLMultiPageEditorPart.this.fDesignViewer != null && newInput != null) {
                XMLMultiPageEditorPart.this.fDesignViewer.setModel(XMLMultiPageEditorPart.this.getModel());
            }
        }
    }
}

