/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.apache.wsil.Abstract;
import org.apache.wsil.Description;
import org.apache.wsil.Inspection;
import org.apache.wsil.Link;
import org.apache.wsil.Service;
import org.apache.wsil.WSILDocument;
import org.eclipse.wst.ws.internal.datamodel.Model;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.ListElement;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.ListManager;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.util.Validator;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel.WsilUddiBusinessElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel.WsilUddiServiceElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel.WsilWsdlServiceElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel.WsilWsilLinkElement;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.datatype.service.BusinessService;

public class WsilElement
extends TreeElement {
    private WSILDocument wsilDoc_;
    private String thisWsilUrl_;
    private static final String NAMESPACE_WSDL = "http://schemas.xmlsoap.org/wsdl/";
    private static final String NAMESPACE_UDDI_V1 = "urn:uddi-org:api";
    private static final String NAMESPACE_UDDI_V2 = "urn:uddi-org:api_v2";
    private static final String NAMESPACE_UDDI_BINDING = "http://schemas.xmlsoap.org/ws/2001/10/inspection/uddi/";
    private static final String NAMESPACE_WSIL_INSPECTION = "http://schemas.xmlsoap.org/ws/2001/10/inspection/";
    public static final String REL_WSIL_LINK = "wsil link nodes";

    public WsilElement(String name, Model model, WSILDocument wsilDocument, String wsilURL) {
        super(name, model);
        this.wsilDoc_ = wsilDocument;
        this.thisWsilUrl_ = wsilURL;
        Object wsdlServices_ = null;
        Object uddiServices_ = null;
        Object wsilLinks_ = null;
        Object uddiLinks_ = null;
        this.setPropertyAsObject("wsdlServices", wsdlServices_);
        this.setPropertyAsObject("uddiServices", uddiServices_);
        this.setPropertyAsObject("uddiLinks", wsilLinks_);
        this.setPropertyAsObject("wsilLinks", uddiLinks_);
    }

    public boolean refresh() {
        try {
            WSILDocument newWSILDoc = WSILDocument.newInstance();
            newWSILDoc.read(this.getWsilUrl());
            this.wsilDoc_ = newWSILDoc;
            Object wsdlServices_ = null;
            Object uddiServices_ = null;
            Object wsilLinks_ = null;
            Object uddiLinks_ = null;
            this.setPropertyAsObject("wsdlServices", wsdlServices_);
            this.setPropertyAsObject("uddiServices", uddiServices_);
            this.setPropertyAsObject("uddiLinks", wsilLinks_);
            this.setPropertyAsObject("wsilLinks", uddiLinks_);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getWsilUrl() {
        return this.thisWsilUrl_;
    }

    public WSILDocument getWSILDocument() {
        return this.wsilDoc_;
    }

    public Vector getWSILAbstractLangs() {
        Vector<String> v = new Vector<String>();
        Abstract[] abstracts = this.wsilDoc_.getInspection().getAbstracts();
        int i = 0;
        while (i < abstracts.length) {
            v.add(abstracts[i].getLang());
            ++i;
        }
        return v;
    }

    public Vector getWSILAbstracts() {
        Vector<String> v = new Vector<String>();
        Abstract[] abstracts = this.wsilDoc_.getInspection().getAbstracts();
        int i = 0;
        while (i < abstracts.length) {
            v.add(abstracts[i].getText());
            ++i;
        }
        return v;
    }

    public ListManager getAllWSDLServices() {
        ListManager wsdlServices_ = (ListManager)this.getPropertyAsObject("wsdlServices");
        if (wsdlServices_ == null) {
            this.initAllWSDLServices();
            wsdlServices_ = (ListManager)this.getPropertyAsObject("wsdlServices");
        }
        return wsdlServices_;
    }

    public ListManager getAllUDDIServices() {
        ListManager uddiServices_ = (ListManager)this.getPropertyAsObject("uddiServices");
        if (uddiServices_ == null) {
            this.initAllUDDIServices();
            uddiServices_ = (ListManager)this.getPropertyAsObject("uddiServices");
        }
        return uddiServices_;
    }

    private void initAllWSDLServices() {
        ListManager wsdlServices_ = new ListManager();
        Inspection inspection = this.wsilDoc_.getInspection();
        Service[] serviceList = inspection.getServices();
        int i = 0;
        while (i < serviceList.length) {
            String namespace;
            Description[] descList = serviceList[i].getDescriptions();
            if (descList.length >= 1 && (namespace = descList[0].getReferencedNamespace()) != null && namespace.equals(NAMESPACE_WSDL)) {
                WsilWsdlServiceElement wsdlServiceElement = new WsilWsdlServiceElement(namespace, this.getModel(), serviceList[i]);
                wsdlServiceElement.setBaseWsilURL(this.getWsilUrl());
                if (wsdlServiceElement.validateWSDLService()) {
                    wsdlServiceElement.setName(wsdlServiceElement.getWSDLServiceURL());
                    wsdlServices_.add(new ListElement((Object)wsdlServiceElement));
                }
            }
            ++i;
        }
        this.setPropertyAsObject("wsdlServices", wsdlServices_);
    }

    private void initAllUDDIServices() {
        ListManager uddiServices_ = new ListManager();
        Inspection inspection = this.wsilDoc_.getInspection();
        Service[] serviceList = inspection.getServices();
        Vector<WsilUddiServiceElement> uddiServiceElements = new Vector<WsilUddiServiceElement>();
        int i = 0;
        while (i < serviceList.length) {
            String namespace;
            Description[] descList = serviceList[i].getDescriptions();
            if (descList.length >= 1 && (namespace = descList[0].getReferencedNamespace()) != null && (namespace.equals(NAMESPACE_UDDI_V1) || namespace.equals(NAMESPACE_UDDI_V2))) {
                WsilUddiServiceElement uddiServiceElement = new WsilUddiServiceElement(namespace, this.getModel(), serviceList[i]);
                uddiServiceElement.setBaseWsilURL(this.getWsilUrl());
                if (uddiServiceElement.validateUDDIService()) {
                    uddiServiceElement.setName(uddiServiceElement.getName());
                    uddiServiceElements.add(uddiServiceElement);
                }
            }
            ++i;
        }
        this.refreshServiceDefinitionsFromRegistry(uddiServiceElements);
        Iterator it = uddiServiceElements.iterator();
        while (it.hasNext()) {
            uddiServices_.add(new ListElement(it.next()));
        }
        this.setPropertyAsObject("uddiServices", uddiServices_);
    }

    /*
     * Unable to fully structure code
     */
    public void refreshServiceDefinitionsFromRegistry(Vector uddiServiceElements) {
        inquiryAPIToServices = new HashMap<String, Vector<WsilUddiServiceElement>>();
        i = 0;
        while (i < uddiServiceElements.size()) {
            uddiServiceElement = (WsilUddiServiceElement)uddiServiceElements.get(i);
            inquiryAPI = uddiServiceElement.getUDDIServiceInquiryAPI();
            if (Validator.validateURL(inquiryAPI)) {
                services = (Vector<WsilUddiServiceElement>)inquiryAPIToServices.get(inquiryAPI);
                if (services == null) {
                    services = new Vector<WsilUddiServiceElement>();
                    inquiryAPIToServices.put(inquiryAPI, services);
                }
                services.add(uddiServiceElement);
            } else {
                uddiServiceElement.setServiceDefinition(null);
            }
            ++i;
        }
        it = inquiryAPIToServices.keySet().iterator();
        block7: while (it.hasNext()) {
            block16: {
                block17: {
                    block15: {
                        inquiryAPI = (String)it.next();
                        services = (Vector)inquiryAPIToServices.get(inquiryAPI);
                        try {
                            props = new Properties();
                            props.put("org.uddi4j.TransportClassName", "org.uddi4j.transport.ApacheAxisTransport");
                            proxy = new UDDIProxy(props);
                            proxy.setInquiryURL(new URL(inquiryAPI));
                            break block15;
                        }
                        catch (Throwable v0) {
                            j = 0;
                            ** while (j < services.size())
                        }
lbl-1000:
                        // 1 sources

                        {
                            uddiServiceElement = (WsilUddiServiceElement)services.get(j);
                            uddiServiceElement.setServiceDefinition(null);
                            ++j;
                            continue;
lbl36:
                            // 1 sources

                            continue block7;
                        }
                    }
                    serviceKeys = new Vector<String>();
                    j = 0;
                    while (j < services.size()) {
                        serviceKeys.add(((WsilUddiServiceElement)services.get(j)).getUDDIServiceKey());
                        ++j;
                    }
                    try {
                        businessServices = proxy.get_serviceDetail(serviceKeys).getBusinessServiceVector();
                        break block16;
                    }
                    catch (Exception v1) {
                        businessServices = new Vector<BusinessService>();
                        if (serviceKeys.size() <= 1) break block17;
                        k = 0;
                        ** while (k < serviceKeys.size())
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            businessServices.add((BusinessService)proxy.get_serviceDetail((String)serviceKeys.get(k)).getBusinessServiceVector().get(0));
                        }
                        catch (Exception v2) {
                            businessServices.add(null);
                        }
                        ++k;
                        continue;
lbl62:
                        // 1 sources

                        break block16;
                    }
                }
                businessServices.add(null);
            }
            k = 0;
            while (k < services.size()) {
                bs = (BusinessService)businessServices.get(k);
                uddiServiceElement = (WsilUddiServiceElement)services.get(k);
                uddiServiceElement.setServiceDefinition(bs);
                ++k;
            }
        }
    }

    public ListManager getAllWSILLinks() {
        ListManager wsilLinks_ = (ListManager)this.getPropertyAsObject("wsilLinks");
        if (wsilLinks_ == null) {
            this.initAllWSILLinks();
            wsilLinks_ = (ListManager)this.getPropertyAsObject("wsilLinks");
        }
        return wsilLinks_;
    }

    public ListManager getAllUDDILinks() {
        ListManager uddiLinks_ = (ListManager)this.getPropertyAsObject("uddiLinks");
        if (uddiLinks_ == null) {
            this.initAllUDDILinks();
            uddiLinks_ = (ListManager)this.getPropertyAsObject("uddiLinks");
        }
        return uddiLinks_;
    }

    private void initAllUDDILinks() {
        ListManager uddiLinks_ = new ListManager();
        Inspection inspection = this.wsilDoc_.getInspection();
        Link[] linkList = inspection.getLinks();
        Vector<WsilUddiBusinessElement> uddiBusinessElements = new Vector<WsilUddiBusinessElement>();
        int i = 0;
        while (i < linkList.length) {
            String namespace = linkList[i].getReferencedNamespace();
            if (namespace != null && (namespace.equals(NAMESPACE_UDDI_V1) || namespace.equals(NAMESPACE_UDDI_V2))) {
                WsilUddiBusinessElement uddiBusinessElement = new WsilUddiBusinessElement(namespace, this.getModel(), linkList[i]);
                uddiBusinessElement.setBaseWsilURL(this.getWsilUrl());
                if (uddiBusinessElement.validateUDDILink()) {
                    uddiBusinessElement.setName(uddiBusinessElement.getName());
                    uddiBusinessElements.add(uddiBusinessElement);
                }
            }
            ++i;
        }
        this.refreshServiceProvidersFromRegistry(uddiBusinessElements);
        Iterator it = uddiBusinessElements.iterator();
        while (it.hasNext()) {
            uddiLinks_.add(new ListElement(it.next()));
        }
        this.setPropertyAsObject("uddiLinks", uddiLinks_);
    }

    /*
     * Unable to fully structure code
     */
    public void refreshServiceProvidersFromRegistry(Vector uddiBusinessElements) {
        inquiryAPIToBusinesses = new HashMap<String, Vector<WsilUddiBusinessElement>>();
        i = 0;
        while (i < uddiBusinessElements.size()) {
            uddiBusinessElement = (WsilUddiBusinessElement)uddiBusinessElements.get(i);
            inquiryAPI = uddiBusinessElement.getUDDILinkInquiryAPI();
            if (Validator.validateURL(inquiryAPI)) {
                businesses = (Vector<WsilUddiBusinessElement>)inquiryAPIToBusinesses.get(inquiryAPI);
                if (businesses == null) {
                    businesses = new Vector<WsilUddiBusinessElement>();
                    inquiryAPIToBusinesses.put(inquiryAPI, businesses);
                }
                businesses.add(uddiBusinessElement);
            } else {
                uddiBusinessElement.setServiceProvider(null);
            }
            ++i;
        }
        it = inquiryAPIToBusinesses.keySet().iterator();
        block7: while (it.hasNext()) {
            block16: {
                block17: {
                    block15: {
                        inquiryAPI = (String)it.next();
                        businesses = (Vector)inquiryAPIToBusinesses.get(inquiryAPI);
                        try {
                            props = new Properties();
                            props.put("org.uddi4j.TransportClassName", "org.uddi4j.transport.ApacheAxisTransport");
                            proxy = new UDDIProxy(props);
                            proxy.setInquiryURL(new URL(inquiryAPI));
                            break block15;
                        }
                        catch (Exception v0) {
                            j = 0;
                            ** while (j < businesses.size())
                        }
lbl-1000:
                        // 1 sources

                        {
                            uddiBusinessElement = (WsilUddiBusinessElement)businesses.get(j);
                            uddiBusinessElement.setServiceProvider(null);
                            ++j;
                            continue;
lbl36:
                            // 1 sources

                            continue block7;
                        }
                    }
                    businessKeys = new Vector<String>();
                    j = 0;
                    while (j < businesses.size()) {
                        businessKeys.add(((WsilUddiBusinessElement)businesses.get(j)).getUDDILinkBusinessKey());
                        ++j;
                    }
                    try {
                        businessEntities = proxy.get_businessDetail(businessKeys).getBusinessEntityVector();
                        break block16;
                    }
                    catch (Exception v1) {
                        businessEntities = new Vector<BusinessEntity>();
                        if (businessKeys.size() <= 1) break block17;
                        k = 0;
                        ** while (k < businessKeys.size())
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            businessEntities.add((BusinessEntity)proxy.get_businessDetail((String)businessKeys.get(k)).getBusinessEntityVector().get(0));
                        }
                        catch (Exception v2) {
                            businessEntities.add(null);
                        }
                        ++k;
                        continue;
lbl62:
                        // 1 sources

                        break block16;
                    }
                }
                businessEntities.add(null);
            }
            k = 0;
            while (k < businesses.size()) {
                be = (BusinessEntity)businessEntities.get(k);
                uddiBusinessElement = (WsilUddiBusinessElement)businesses.get(k);
                uddiBusinessElement.setServiceProvider(be);
                ++k;
            }
        }
    }

    private void initAllWSILLinks() {
        ListManager wsilLinks_ = new ListManager();
        Inspection inspection = this.wsilDoc_.getInspection();
        Link[] linkList = inspection.getLinks();
        int i = 0;
        while (i < linkList.length) {
            String namespace = linkList[i].getReferencedNamespace();
            if (namespace != null && namespace.equals(NAMESPACE_WSIL_INSPECTION)) {
                WsilWsilLinkElement wsilLinkElement = new WsilWsilLinkElement(namespace, this.getModel(), linkList[i]);
                wsilLinkElement.setBaseWsilURL(this.getWsilUrl());
                if (wsilLinkElement.validateWSILLink()) {
                    wsilLinkElement.setName(wsilLinkElement.getWSILLinkLocation());
                    wsilLinks_.add(new ListElement((Object)wsilLinkElement));
                }
            }
            ++i;
        }
        this.setPropertyAsObject("wsilLinks", wsilLinks_);
    }
}

