/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup;

import java.sql.Connection;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;
import org.eclipse.wst.rdb.server.internal.ui.query.execute.QueryOutputHelper;
import org.eclipse.wst.rdb.server.internal.ui.util.resources.ResourceLoader;

public class SampleContentsAction
implements IViewActionDelegate,
IActionDelegate2 {
    private IStructuredSelection selection;
    private final String SQ = "'";
    private final String DQ = "\"";
    private String quote = "";

    public void init(IViewPart viewPart) {
        this.quote = "\"";
    }

    public void run(IAction action) {
        Connection connection = null;
        if (!this.selection.isEmpty()) {
            Iterator iter = this.selection.iterator();
            String selectString = "";
            Object selectedObj = iter.next();
            if (selectedObj instanceof Table) {
                if (connection == null) {
                    connection = ((ICatalogObject)selectedObj).getConnection();
                }
                Schema schema = ((Table)selectedObj).getSchema();
                Database database = schema.getDatabase();
                DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
                this.quote = databaseDefinition.getIdentifierQuoteString();
                selectString = String.valueOf(selectString) + "SELECT * FROM " + this.getFullyQualifiedName((Table)selectedObj);
            } else if (selectedObj instanceof Column) {
                if (connection == null) {
                    connection = ((ICatalogObject)selectedObj).getConnection();
                }
                String columnName = ((Column)selectedObj).getName();
                selectString = String.valueOf(selectString) + "SELECT DISTINCT " + this.wrapName(columnName) + " , COUNT(*) AS OCCURRENCE";
                selectString = String.valueOf(selectString) + " FROM " + this.getFullyQualifiedName(((Column)selectedObj).getTable());
                selectString = String.valueOf(selectString) + " GROUP BY " + this.wrapName(columnName);
                selectString = String.valueOf(selectString) + " ORDER BY " + this.wrapName(columnName);
            }
            QueryOutputHelper queryHelper = new QueryOutputHelper(selectString, connection);
            queryHelper.setObjectName(ResourceLoader.INSTANCE.queryString("_UI_SAMPLE_CONTENTS_OUTPUTVIEW_TITLE"));
            queryHelper.runQuery();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
        }
    }

    public void init(IAction action) {
        this.quote = "\"";
    }

    public void dispose() {
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    private String wrapName(String name) {
        if (this.quote.equals("'")) {
            return String.valueOf(this.quote) + name + this.quote;
        }
        return "\"" + name + "\"";
    }

    private String getFullyQualifiedName(Table table) {
        return String.valueOf(this.wrapName(table.getSchema().getName())) + "." + this.wrapName(table.getName());
    }
}

