/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.locator;

import java.io.IOException;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.web.locator.AbstractWebTaglibLocator;
import org.eclipse.jst.j2ee.internal.web.operations.WebPropertiesUtil;
import org.eclipse.jst.j2ee.internal.web.plugin.WebPlugin;
import org.eclipse.jst.j2ee.internal.web.taglib.ITaglibInfo;
import org.eclipse.jst.j2ee.internal.web.taglib.ITaglibRegistry;
import org.eclipse.jst.j2ee.internal.web.taglib.TLDDigester;
import org.eclipse.jst.j2ee.internal.web.taglib.TaglibInfo;
import org.eclipse.wst.web.internal.operation.ILibModule;

public class WebLibModuleTaglibLocator
extends AbstractWebTaglibLocator {
    public WebLibModuleTaglibLocator(IProject project) {
        super(project);
    }

    public ITaglibInfo[] search(IResource resource) {
        List libModuleTaglibs = this.calculateLibModuleTaglibs();
        return libModuleTaglibs.toArray(new ITaglibInfo[libModuleTaglibs.size()]);
    }

    protected List calculateLibModuleTaglibs() {
        ILibModule[] libModules = this.getLibModules();
        Vector<TaglibInfo> results = new Vector<TaglibInfo>();
        boolean addedJar = false;
        int i = 0;
        while (i < libModules.length) {
            ILibModule iLibModule = libModules[i];
            IProject prj = iLibModule.getProject();
            ITaglibRegistry registry = WebPlugin.getDefault().getTaglibRegistryManager().getTaglibRegistry(prj);
            if (registry != null) {
                ITaglibInfo[] javaTaglibs = registry.getTaglibs();
                int j = 0;
                while (j < javaTaglibs.length) {
                    TaglibInfo newTaglib;
                    ITaglibInfo iTaglibInfo = javaTaglibs[j];
                    if (iTaglibInfo.isInJar()) break;
                    IPath webProjectRelativePath = WebPropertiesUtil.getWebLibFolder(this.project).getProjectRelativePath();
                    IPath jarLocationPath = webProjectRelativePath.append(iLibModule.getJarName());
                    IPath jarName = jarLocationPath.removeFirstSegments(this.getServerRoot().segmentCount());
                    Path jarURI = new Path("/");
                    jarURI = jarURI.append(jarName);
                    int JSPVersion = this.getJSPVersion();
                    if (iTaglibInfo.isURIFromTLD() && (JSPVersion == 12 || JSPVersion == 20)) {
                        newTaglib = new TaglibInfo(prj, iTaglibInfo.getURI(), jarLocationPath, iTaglibInfo.getTLDLocation());
                        newTaglib.setIsLibModule(true);
                        newTaglib.setIsURIFromTLD(true);
                        results.add(newTaglib);
                    }
                    if (!addedJar && this.isTaglibTLD(iTaglibInfo.getTLDLocation())) {
                        String digesterJSPLevel;
                        TLDDigester digester;
                        newTaglib = new TaglibInfo(prj, jarURI.toString(), jarLocationPath, iTaglibInfo.getTLDLocation());
                        newTaglib.setIsLibModule(true);
                        newTaglib.setIsURIFromTLD(false);
                        boolean canAddTaglibTLD = true;
                        if (JSPVersion == 11) {
                            try {
                                digester = new TLDDigester(newTaglib.getTLDStream());
                                if (digester.getJSPLevel() == null || !digester.getJSPLevel().equals("1.1")) {
                                    canAddTaglibTLD = false;
                                }
                            }
                            catch (ZipException zipException) {
                            }
                            catch (IOException iOException) {
                            }
                            catch (CoreException coreException) {}
                        } else if (JSPVersion == 12) {
                            try {
                                digester = new TLDDigester(newTaglib.getTLDStream());
                                digesterJSPLevel = digester.getJSPLevel();
                                if (digesterJSPLevel == null || !digesterJSPLevel.equals("1.2") || !digesterJSPLevel.equals("1.1")) {
                                    canAddTaglibTLD = false;
                                }
                            }
                            catch (ZipException zipException) {
                            }
                            catch (IOException iOException) {
                            }
                            catch (CoreException coreException) {}
                        } else if (JSPVersion == 20) {
                            try {
                                digester = new TLDDigester(newTaglib.getTLDStream());
                                digesterJSPLevel = digester.getJSPLevel();
                                if (!(digesterJSPLevel != null && digesterJSPLevel.equals("2.0") && digesterJSPLevel.equals("1.2") && digesterJSPLevel.equals("1.1"))) {
                                    canAddTaglibTLD = false;
                                }
                            }
                            catch (ZipException zipException) {
                            }
                            catch (IOException iOException) {
                            }
                            catch (CoreException coreException) {}
                        }
                        if (canAddTaglibTLD) {
                            results.add(newTaglib);
                        }
                        addedJar = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return results;
    }

    protected ITaglibInfo[] searchFile(IFile file) {
        return new ITaglibInfo[0];
    }

    protected boolean isTaglibTLD(IPath tldPath) {
        return tldPath.lastSegment().equalsIgnoreCase("taglib.tld");
    }
}

