/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jst.j2ee.internal.web.archive.operations.ContextRootUpdateOperation;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebContentNameUpdateOperation;
import org.eclipse.jst.j2ee.internal.web.operations.ClasspathUtilities;
import org.eclipse.jst.j2ee.internal.web.operations.WebProjectInfo;
import org.eclipse.wst.common.frameworks.internal.operations.IHeadlessRunnableWithProgress;

public class WebProjectPropertiesUpdateOperation
implements IHeadlessRunnableWithProgress {
    protected WebProjectInfo webProjectInfo;

    public WebProjectPropertiesUpdateOperation(WebProjectInfo projectInfo) {
        this.webProjectInfo = projectInfo;
        this.webProjectInfo.getProject();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        String webContentName;
        IProject project = this.webProjectInfo.getProject();
        String contextRoot = this.webProjectInfo.getContextRoot();
        if (contextRoot != null) {
            new ContextRootUpdateOperation(project, contextRoot).run(monitor);
        }
        if ((webContentName = this.webProjectInfo.getWebContentName()) != null) {
            new WebContentNameUpdateOperation(project, webContentName).run(monitor);
        }
        this.webProjectInfo.getServletLevel();
        this.webProjectInfo.getJSPLevel();
        try {
            this.updateClassPathEntries(monitor);
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    protected IClasspathEntry[] getClasspathsFromWebProjectInfo(WebProjectInfo wpInfo) {
        IClasspathEntry[] wasClasspath = wpInfo.getWASClasspathEntries();
        IClasspathEntry[] serverJdkClasspath = wpInfo.getServerJDKClasspathEntries();
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>(wasClasspath.length + serverJdkClasspath.length);
        list.addAll(Arrays.asList(wasClasspath));
        list.addAll(Arrays.asList(serverJdkClasspath));
        ClasspathEntry[] ret = new ClasspathEntry[list.size()];
        return (IClasspathEntry[])list.toArray(ret);
    }

    protected IClasspathEntry[] getOldDefaultClasspath() {
        WebProjectInfo wpInfo = new WebProjectInfo();
        return this.getClasspathsFromWebProjectInfo(wpInfo);
    }

    protected IClasspathEntry[] getDefaultClasspath() {
        WebProjectInfo wpInfo = new WebProjectInfo();
        return this.getClasspathsFromWebProjectInfo(wpInfo);
    }

    protected void updateClassPathEntries(IProgressMonitor monitor) throws InvocationTargetException {
        IProject project = this.webProjectInfo.getProject();
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IClasspathEntry[] existingClasspath = javaProject.getRawClasspath();
                IClasspathEntry[] oldDefaultClasspath = this.getOldDefaultClasspath();
                IClasspathEntry[] defaultClasspath = this.getDefaultClasspath();
                IClasspathEntry[] newClasspath = ClasspathUtilities.removeClasspathEntries(existingClasspath, oldDefaultClasspath);
                newClasspath = ClasspathUtilities.addClasspathEntries(newClasspath, defaultClasspath);
                javaProject.setRawClasspath(newClasspath, monitor);
            }
        }
        catch (JavaModelException e) {
            throw new InvocationTargetException(e);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }
}

