/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.taglib;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.web.taglib.IDirTaglibInfo;
import org.eclipse.jst.j2ee.internal.web.taglib.TaglibInfo;

public class DirTaglibInfo
extends TaglibInfo
implements IDirTaglibInfo {
    private IContainer container;

    public DirTaglibInfo(IContainer container, String uri, IPath tldLocation) {
        super(container.getProject(), uri, tldLocation);
        this.container = container;
        this.setDirectoryEntry(true);
    }

    public IFile[] getTagFiles() {
        ArrayList<IResource> iFiles = new ArrayList<IResource>();
        try {
            IResource[] resources = this.container.members();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (resource.getType() == 1 && resource.getFileExtension().equalsIgnoreCase("tag")) {
                    iFiles.add(resource);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return iFiles.toArray(new IFile[iFiles.size()]);
    }

    public IContainer getDirectory() {
        return this.container;
    }

    public String[] getTags() {
        IFile[] tagFiles = this.getTagFiles();
        ArrayList<String> tagList = new ArrayList<String>();
        int i = 0;
        while (i < tagFiles.length) {
            IFile array_element = tagFiles[i];
            String filename = array_element.getName();
            String extn = new Path(array_element.getName()).getFileExtension();
            String tagname = filename.substring(0, filename.indexOf("." + extn));
            tagList.add(tagname);
            ++i;
        }
        return tagList.toArray(new String[tagList.size()]);
    }
}

