/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.taglib;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.j2ee.internal.web.taglib.ITaglibRegistry;
import org.eclipse.jst.j2ee.internal.web.taglib.ITaglibRegistryManager;
import org.eclipse.jst.j2ee.internal.web.taglib.registry.AbstractTaglibRegistry;
import org.eclipse.jst.j2ee.internal.web.taglib.registry.JavaTaglibRegistry;
import org.eclipse.jst.j2ee.internal.web.taglib.registry.WebTaglibRegistry;

public class TaglibRegistryManager
implements ITaglibRegistryManager {
    protected HashMap registries = new HashMap();
    protected IResourceChangeListener resourceListener;

    public TaglibRegistryManager() {
        this.initialize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ITaglibRegistry createNewRegistry(IProject project) {
        AbstractTaglibRegistry registry;
        block11: {
            registry = null;
            Object webEdit = null;
            try {
                block10: {
                    try {
                        if (project == null || !project.isAccessible()) break block10;
                        if (webEdit != null) {
                            registry = new WebTaglibRegistry(project);
                        } else if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                            registry = new JavaTaglibRegistry(project);
                        }
                    }
                    catch (CoreException coreException) {}
                }
                Object var4_6 = null;
                if (webEdit == null) break block11;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (webEdit != null) {
                    webEdit.dispose();
                }
                throw throwable;
            }
            webEdit.dispose();
        }
        if (registry != null) {
            this.registries.put(project, registry);
        }
        return registry;
    }

    protected void initialize() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.resourceListener = new ResourceChangeListener();
        workspace.addResourceChangeListener(this.resourceListener);
    }

    protected void resourceChanged(IResourceDelta delta) {
        if (delta.getResource() instanceof IProject) {
            return;
        }
        Collection registryCol = this.registries.values();
        Iterator iter = registryCol.iterator();
        while (iter.hasNext()) {
            ITaglibRegistry registry = (ITaglibRegistry)iter.next();
            if (delta.getResource().getProject() != registry.getProject()) continue;
            registry.processResourceChanged(delta);
        }
    }

    protected void removeTaglibRegistry(IProject project) {
        this.registries.remove(project);
    }

    public ITaglibRegistry getTaglibRegistry(IProject project) {
        ITaglibRegistry registry = (ITaglibRegistry)this.registries.get(project);
        if (registry == null) {
            registry = this.createNewRegistry(project);
        }
        return registry;
    }

    public void dispose() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener(this.resourceListener);
        this.registries = null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Collection regCol = this.registries.values();
        Iterator iter = regCol.iterator();
        while (iter.hasNext()) {
            ITaglibRegistry registry = (ITaglibRegistry)iter.next();
            buf.append("=== Registry for " + registry.getProject() + "===\n");
            buf.append(registry);
            buf.append("\n");
        }
        return buf.toString();
    }

    public boolean isTaglibRegistryExists(IProject project) {
        return this.registries.containsKey(project);
    }

    private class ResourceChangeListener
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getSource() instanceof IWorkspace) {
                IResourceDelta delta = event.getDelta();
                switch (event.getType()) {
                    case 1: {
                        if (delta == null) break;
                        try {
                            delta.accept((IResourceDeltaVisitor)this);
                        }
                        catch (CoreException coreException) {}
                        break;
                    }
                    case 2: 
                    case 4: {
                        TaglibRegistryManager.this.removeTaglibRegistry((IProject)event.getResource());
                    }
                }
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta != null) {
                TaglibRegistryManager.this.resourceChanged(delta);
                return true;
            }
            return false;
        }
    }
}

