/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.derby.catalog;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.definition.DataModelElementFactory;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.core.rte.RefreshManager;
import org.eclipse.wst.rdb.internal.derby.catalog.DerbyCatalogCheckConstraint;
import org.eclipse.wst.rdb.internal.derby.catalog.DerbyCatalogColumn;
import org.eclipse.wst.rdb.internal.derby.catalog.DerbyCatalogDatabase;
import org.eclipse.wst.rdb.internal.derby.catalog.DerbyCatalogForeignKey;
import org.eclipse.wst.rdb.internal.derby.catalog.DerbyCatalogIndex;
import org.eclipse.wst.rdb.internal.derby.catalog.DerbyCatalogPrimaryKey;
import org.eclipse.wst.rdb.internal.derby.catalog.DerbyCatalogSchema;
import org.eclipse.wst.rdb.internal.derby.catalog.DerbyCatalogTrigger;
import org.eclipse.wst.rdb.internal.models.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.wst.rdb.internal.models.sql.constraints.Constraint;
import org.eclipse.wst.rdb.internal.models.sql.constraints.ForeignKey;
import org.eclipse.wst.rdb.internal.models.sql.constraints.IncrementType;
import org.eclipse.wst.rdb.internal.models.sql.constraints.IndexMember;
import org.eclipse.wst.rdb.internal.models.sql.constraints.SQLConstraintsPackage;
import org.eclipse.wst.rdb.internal.models.sql.constraints.UniqueConstraint;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.PredefinedDataType;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.SQLDataType;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.ReferentialActionType;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.eclipse.wst.rdb.internal.models.sql.statements.SQLStatement;
import org.eclipse.wst.rdb.internal.models.sql.statements.SQLStatementDefault;
import org.eclipse.wst.rdb.internal.models.sql.statements.SQLStatementsPackage;
import org.eclipse.wst.rdb.internal.models.sql.tables.ActionGranularityType;
import org.eclipse.wst.rdb.internal.models.sql.tables.ActionTimeType;
import org.eclipse.wst.rdb.internal.models.sql.tables.BaseTable;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;
import org.eclipse.wst.rdb.internal.models.sql.tables.SQLTablesPackage;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;
import org.eclipse.wst.rdb.internal.models.sql.tables.impl.PersistentTableImpl;

public class DerbyCatalogTable
extends PersistentTableImpl
implements ICatalogObject {
    private static final long serialVersionUID = 3257854259579074868L;
    private boolean columnsLoaded = false;
    private boolean constraintLoaded = false;
    private boolean triggerLoaded = false;
    private boolean indexLoaded = false;

    public void refresh() {
        this.columnsLoaded = false;
        if (this.constraintLoaded) {
            super.getConstraints().clear();
            this.constraintLoaded = false;
        }
        if (this.indexLoaded) {
            super.getIndex().clear();
            this.indexLoaded = false;
        }
        this.triggerLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((DerbyCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getDatabase();
    }

    public EList getColumns() {
        if (!this.columnsLoaded) {
            this.loadColumns();
        }
        return this.columns;
    }

    public EList getConstraints() {
        if (!this.constraintLoaded) {
            this.loadConstraints();
        }
        return this.constraints;
    }

    public EList getTriggers() {
        if (!this.triggerLoaded) {
            this.loadTriggers();
        }
        return this.triggers;
    }

    public EList getIndex() {
        if (!this.indexLoaded) {
            this.loadIndexes();
        }
        return this.index;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 5) {
            this.getColumns();
        } else if (id == 2) {
            this.getConstraints();
        } else if (id == 11) {
            this.getIndex();
        } else if (id == 10) {
            this.getTriggers();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadColumns() {
        if (this.columnsLoaded) {
            return;
        }
        EList columnList = super.getColumns();
        Object[] list = columnList.toArray();
        columnList.clear();
        this.getConnection();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            DatabaseMetaData metaData = this.getConnection().getMetaData();
            ResultSet r = metaData.getColumns(null, this.getSchema().getName(), this.getName(), null);
            while (r.next()) {
                String nulls;
                Object column;
                String columnName = r.getString(4);
                Object element = DerbyCatalogSchema.findElement(list, columnName, SQLTablesPackage.eINSTANCE.getColumn());
                if (element != null) {
                    column = (Column)element;
                    ((ICatalogObject)element).refresh();
                } else {
                    column = new DerbyCatalogColumn();
                }
                column.setName(columnName);
                String remarks = r.getString(12);
                column.setDescription(remarks);
                String typeName = r.getString(6);
                DatabaseDefinition databaseDefinition = this.getDatabaseDefinition();
                PredefinedDataTypeDefinition typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition(typeName);
                if (typeDefinition != null) {
                    EStructuralFeature feature;
                    PredefinedDataType type = databaseDefinition.getPredefinedDataType(typeDefinition);
                    if (typeDefinition.isLengthSupported()) {
                        feature = type.eClass().getEStructuralFeature("length");
                        type.eSet(feature, (Object)new Integer(r.getInt(7)));
                    } else if (typeDefinition.isPrecisionSupported()) {
                        feature = type.eClass().getEStructuralFeature("precision");
                        type.eSet(feature, (Object)new Integer(r.getInt(7)));
                    }
                    if (typeDefinition.isScaleSupported()) {
                        feature = type.eClass().getEStructuralFeature("scale");
                        type.eSet(feature, (Object)new Integer(r.getInt(9)));
                    }
                    column.setContainedType((SQLDataType)type);
                }
                if ((nulls = r.getString(18)).equals("YES")) {
                    column.setNullable(true);
                } else {
                    column.setNullable(false);
                }
                columnList.add(column);
            }
            this.columnsLoaded = true;
            r.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadConstraints() {
        if (this.constraintLoaded) {
            return;
        }
        Connection connection = this.getConnection();
        if (connection == null) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            this.loadPrimaryKey(metaData);
            DerbyCatalogTable.loadForeignKey(connection, super.getConstraints(), (Table)this);
            DerbyCatalogTable.loadCheckConstraint(connection, super.getConstraints(), (Table)this);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        this.constraintLoaded = true;
        this.eSetDeliver(deliver);
    }

    private synchronized DerbyCatalogPrimaryKey loadPrimaryKey(DatabaseMetaData metaData) {
        DerbyCatalogPrimaryKey key = null;
        try {
            ResultSet r = metaData.getPrimaryKeys(null, this.getSchema().getName(), this.getName());
            RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase()).getDataModelElementFactory();
            KeyColumnCollection columns = new KeyColumnCollection((BaseTable)this);
            while (r.next()) {
                if (key == null) {
                    String name = r.getString(6);
                    key = new DerbyCatalogPrimaryKey();
                    key.setName(name);
                    super.getConstraints().add((Object)key);
                }
                String columnName = r.getString(4);
                int seq = r.getInt(5);
                columns.add(seq, columnName);
            }
            Iterator it = columns.iterator();
            while (it.hasNext()) {
                Column column = (Column)it.next();
                key.getMembers().add((Object)column);
            }
            r.close();
        }
        catch (Exception exception) {}
        return key;
    }

    private synchronized void loadReferenceForeignKey(DatabaseMetaData metaData, UniqueConstraint uk) {
        try {
            ResultSet r = metaData.getExportedKeys(null, this.getSchema().getName(), this.getName());
            RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase()).getDataModelElementFactory();
            ForeignKey fk = null;
            Table fkTable = null;
            String fkTableName = "";
            while (r.next()) {
                String fkSchema_Name = r.getString(6);
                String fkTable_Name = r.getString(7);
                if (!fkTableName.equals(fkTable_Name)) {
                    fkTable = this.getTable(fkSchema_Name, fkTable_Name);
                    fkTableName = fkTable_Name;
                    String fkName = r.getString(12);
                    fk = this.getForeignkey(fkSchema_Name, fkTable_Name, fkName);
                    fk.setUniqueConstraint(uk);
                    short updateRule = r.getShort(10);
                    switch (updateRule) {
                        case 0: {
                            fk.setOnUpdate(ReferentialActionType.CASCADE_LITERAL);
                            break;
                        }
                        case 1: {
                            fk.setOnUpdate(ReferentialActionType.RESTRICT_LITERAL);
                            break;
                        }
                        case 4: {
                            fk.setOnUpdate(ReferentialActionType.SET_DEFAULT_LITERAL);
                            break;
                        }
                        case 2: {
                            fk.setOnUpdate(ReferentialActionType.SET_NULL_LITERAL);
                            break;
                        }
                        default: {
                            fk.setOnUpdate(ReferentialActionType.NO_ACTION_LITERAL);
                        }
                    }
                    short deleteRule = r.getShort(11);
                    switch (deleteRule) {
                        case 0: {
                            fk.setOnDelete(ReferentialActionType.CASCADE_LITERAL);
                            break;
                        }
                        case 1: {
                            fk.setOnDelete(ReferentialActionType.RESTRICT_LITERAL);
                            break;
                        }
                        case 4: {
                            fk.setOnDelete(ReferentialActionType.SET_DEFAULT_LITERAL);
                            break;
                        }
                        case 2: {
                            fk.setOnDelete(ReferentialActionType.SET_NULL_LITERAL);
                            break;
                        }
                        default: {
                            fk.setOnDelete(ReferentialActionType.NO_ACTION_LITERAL);
                        }
                    }
                    short deferrability = r.getShort(14);
                    switch (deferrability) {
                        case 5: {
                            fk.setDeferrable(true);
                            fk.setInitiallyDeferred(true);
                            break;
                        }
                        case 6: {
                            fk.setDeferrable(true);
                            fk.setInitiallyDeferred(false);
                            break;
                        }
                        default: {
                            fk.setDeferrable(false);
                        }
                    }
                    ((BaseTable)fkTable).getConstraints().add((Object)fk);
                }
                String columnName = r.getString(8);
                Column column = DerbyCatalogTable.getColumn(fkTable, columnName);
                fk.getMembers().add((Object)column);
            }
            r.close();
        }
        catch (Exception exception) {}
    }

    public static void loadForeignKey(Connection connection, EList constraints, Table table) {
        try {
            String query = "SELECT CONSTRAINTNAME,DELETERULE,UPDATERULE FROM SYS.SYSCONSTRAINTS FK,SYS.SYSFOREIGNKEYS R, SYS.SYSTABLES T, SYS.SYSSCHEMAS S WHERE T.SCHEMAID=S.SCHEMAID AND S.SCHEMANAME='" + table.getSchema().getName() + "'" + " AND T.TABLEID= FK.TABLEID" + " AND T.TABLENAME='" + table.getName() + "'" + " AND FK.CONSTRAINTID=R.CONSTRAINTID";
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                DerbyCatalogForeignKey fk = new DerbyCatalogForeignKey();
                String fkName = r.getString("CONSTRAINTNAME");
                fk.setName(fkName);
                String updateRule = r.getString("UPDATERULE");
                if (updateRule.equals("S")) {
                    fk.setOnUpdate(ReferentialActionType.RESTRICT_LITERAL);
                } else {
                    fk.setOnUpdate(ReferentialActionType.NO_ACTION_LITERAL);
                }
                r.getString("DELETERULE");
                if (updateRule.equals("C")) {
                    fk.setOnDelete(ReferentialActionType.CASCADE_LITERAL);
                } else if (updateRule.equals("S")) {
                    fk.setOnDelete(ReferentialActionType.RESTRICT_LITERAL);
                } else if (updateRule.equals("U")) {
                    fk.setOnDelete(ReferentialActionType.SET_NULL_LITERAL);
                } else {
                    fk.setOnDelete(ReferentialActionType.NO_ACTION_LITERAL);
                }
                constraints.add((Object)fk);
            }
            r.close();
            s.close();
        }
        catch (Exception exception) {}
    }

    public static void loadCheckConstraint(Connection connection, EList constraints, Table table) {
        Database database = table.getSchema().getDatabase();
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
        databaseDefinition.getDataModelElementFactory();
        String query = "SELECT CONSTRAINTNAME,CHECKDEFINITION FROM SYS.SYSCONSTRAINTS A,SYS.SYSSCHEMAS B, SYS.SYSTABLES C, SYS.SYSCHECKS D WHERE A.TYPE='C' AND A.SCHEMAID=B.SCHEMAID AND B.SCHEMANAME='" + table.getSchema().getName() + "'" + " AND A.TABLEID= C.TABLEID" + " AND C.TABLENAME='" + table.getName() + "'" + " AND A.CONSTRAINTID=D.CONSTRAINTID";
        try {
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String check_name = r.getString("CONSTRAINTNAME");
                DerbyCatalogCheckConstraint check = new DerbyCatalogCheckConstraint();
                check.setName(check_name);
                constraints.add((Object)check);
            }
            r.close();
            s.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    private synchronized void loadTriggers() {
        if (this.triggerLoaded) {
            return;
        }
        EList triggerList = super.getTriggers();
        Object[] list = triggerList.toArray();
        triggerList.clear();
        Connection connection = this.getConnection();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            DataModelElementFactory factory = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase()).getDataModelElementFactory();
            Statement s = connection.createStatement();
            String query = "SELECT TRIGGERNAME, SCHEMANAME,EVENT,FIRINGTIME,TYPE,TRIGGERDEFINITION,REFERENCINGOLD,REFERENCINGNEW,OLDREFERENCINGNAME,NEWREFERENCINGNAME,REFERENCEDCOLUMNS FROM SYS.SYSTRIGGERS A, SYS.SYSTABLES B, SYS.SYSSCHEMAS C WHERE A.TABLEID=B.TABLEID AND B.TABLENAME='" + this.getName() + "'" + " AND A.SCHEMAID=C.SCHEMAID";
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String columns;
                boolean referencingNew;
                String granularity;
                DerbyCatalogTrigger trigger;
                EClass metaclass;
                String trigName = r.getString("TRIGGERNAME");
                Object element = DerbyCatalogSchema.findElement(list, trigName, metaclass = SQLTablesPackage.eINSTANCE.getTrigger());
                if (element != null) {
                    trigger = (DerbyCatalogTrigger)((Object)element);
                    ((ICatalogObject)element).refresh();
                } else {
                    trigger = new DerbyCatalogTrigger();
                    trigger.setName(trigName);
                }
                trigger.setName(trigName);
                String trigSchema = r.getString("SCHEMANAME");
                trigger.setSchema(this.getSchema(trigSchema));
                String trigTime = r.getString("FIRINGTIME");
                if (trigTime.equals("A")) {
                    trigger.setActionTime(ActionTimeType.AFTER_LITERAL);
                } else if (trigTime.equals("B")) {
                    trigger.setActionTime(ActionTimeType.BEFORE_LITERAL);
                } else {
                    if (!trigTime.equals("I")) continue;
                    trigger.setActionTime(ActionTimeType.INSTEADOF_LITERAL);
                }
                String trigEvent = r.getString("EVENT");
                if (trigEvent.equals("I")) {
                    trigger.setInsertType(true);
                }
                if (trigEvent.equals("D")) {
                    trigger.setDeleteType(true);
                }
                if (trigEvent.equals("U")) {
                    trigger.setUpdateType(true);
                }
                if ((granularity = r.getString("TYPE")).equals("S")) {
                    trigger.setActionGranularity(ActionGranularityType.STATEMENT_LITERAL);
                } else {
                    if (!granularity.equals("R")) continue;
                    trigger.setActionGranularity(ActionGranularityType.ROW_LITERAL);
                }
                boolean referencingOld = r.getBoolean("REFERENCINGOLD");
                if (referencingOld) {
                    trigger.setOldRow(r.getString("OLDREFERENCINGNAME"));
                }
                if (referencingNew = r.getBoolean("REFERENCINGNEW")) {
                    trigger.setNewRow(r.getString("NEWREFERENCINGNAME"));
                }
                if ((columns = r.getString("REFERENCEDCOLUMNS")) != null) {
                    EList updateColumns = trigger.getTriggerColumn();
                    EList columnList = this.getColumns();
                    columns = columns.substring(columns.indexOf("(") + 1, columns.indexOf(")"));
                    StringTokenizer tokenizer = new StringTokenizer(columns, ",");
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken().trim();
                        Column column = (Column)columnList.get(Integer.parseInt(token) - 1);
                        updateColumns.add((Object)column);
                    }
                }
                String text = r.getString("TRIGGERDEFINITION");
                SQLStatement body = (SQLStatement)factory.create(SQLStatementsPackage.eINSTANCE.getSQLStatementDefault());
                ((SQLStatementDefault)body).setSQL(text);
                trigger.getActionStatement().add((Object)body);
                triggerList.add((Object)trigger);
            }
            this.triggerLoaded = true;
            r.close();
            s.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadIndexes() {
        if (this.indexLoaded) {
            return;
        }
        EList indexList = super.getIndex();
        Connection connection = this.getConnection();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            DataModelElementFactory factory = this.getDatabaseDefinition().getDataModelElementFactory();
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet r = metaData.getIndexInfo(null, null, this.getName(), false, false);
            DerbyCatalogIndex index = null;
            String indexName = "";
            while (r.next()) {
                String column_name;
                String indName = r.getString(6);
                if (!indName.equals(indexName)) {
                    indexName = indName;
                    index = new DerbyCatalogIndex();
                    index.setName(indName);
                    String indSchema = r.getString(2);
                    index.setSchema(this.getSchema(indSchema));
                    index.setUnique(!r.getBoolean(4));
                    short type = r.getShort(7);
                    if (type == 1) {
                        index.setClustered(true);
                    }
                    indexList.add((Object)index);
                }
                if ((column_name = r.getString(9)) == null) continue;
                IndexMember member = (IndexMember)factory.create(SQLConstraintsPackage.eINSTANCE.getIndexMember());
                member.setColumn(DerbyCatalogTable.getColumn((Table)this, column_name));
                String order = r.getString(10);
                if (order.equals("A")) {
                    member.setIncrementType(IncrementType.ASC_LITERAL);
                } else if (order.equals("D")) {
                    member.setIncrementType(IncrementType.DESC_LITERAL);
                }
                index.getMembers().add((Object)member);
            }
            this.indexLoaded = true;
            r.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        this.eSetDeliver(deliver);
    }

    private UniqueConstraint getRefrencedUniqueConstraint(String pkSchema, String pkTable, String pkName) {
        BaseTable table = (BaseTable)this.getTable(pkSchema, pkTable);
        Iterator it = table.getConstraints().iterator();
        while (it.hasNext()) {
            Constraint constraint = (Constraint)it.next();
            if (!(constraint instanceof UniqueConstraint) || !constraint.getName().equals(pkName)) continue;
            return (UniqueConstraint)constraint;
        }
        return null;
    }

    private DatabaseDefinition getDatabaseDefinition() {
        Database d = this.getSchema().getDatabase();
        return RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(d);
    }

    static Column getColumn(Table table, String columnName) {
        Iterator it = table.getColumns().iterator();
        while (it.hasNext()) {
            Column c = (Column)it.next();
            if (!c.getName().equals(columnName)) continue;
            return c;
        }
        return null;
    }

    private Schema getSchema(String schemaName) {
        Schema s = this.getSchema();
        if (s.getName().equals(schemaName)) {
            return s;
        }
        Database d = s.getDatabase();
        Iterator it = d.getSchemas().iterator();
        while (it.hasNext()) {
            s = (Schema)it.next();
            if (!s.getName().equals(schemaName)) continue;
            return s;
        }
        DerbyCatalogSchema schema = new DerbyCatalogSchema();
        schema.setName(schemaName);
        schema.setDatabase(d);
        return schema;
    }

    private Table getTable(String schemaName, String tableName) {
        DerbyCatalogTable table;
        Schema schema = this.getSchema(schemaName);
        Iterator it = schema.getTables().iterator();
        while (it.hasNext()) {
            table = (Table)it.next();
            if (!table.getName().equals(tableName)) continue;
            return table;
        }
        table = new DerbyCatalogTable();
        table.setName(tableName);
        table.setSchema(schema);
        return table;
    }

    private ForeignKey getForeignkey(String schemaName, String tableName, String constraintName) {
        BaseTable table = (BaseTable)this.getTable(schemaName, tableName);
        Iterator it = table.getConstraints().iterator();
        while (it.hasNext()) {
            Constraint constraint = (Constraint)it.next();
            if (!constraint.getName().equals(constraintName)) continue;
            return (ForeignKey)constraint;
        }
        DerbyCatalogForeignKey fk = new DerbyCatalogForeignKey();
        fk.setName(constraintName);
        fk.setBaseTable(table);
        return fk;
    }

    private static class KeyColumnCollection {
        private Map keyMap = new TreeMap();
        private BaseTable table;

        public KeyColumnCollection(BaseTable table) {
            this.table = table;
        }

        public void add(int seq, String name) {
            Column column = this.getColumn(name);
            String key = "k" + seq;
            this.keyMap.put(key, column);
        }

        public Iterator iterator() {
            return this.keyMap.values().iterator();
        }

        private Column getColumn(String name) {
            Iterator it = this.table.getColumns().iterator();
            while (it.hasNext()) {
                Column column = (Column)it.next();
                if (!column.getName().equals(name)) continue;
                return column;
            }
            return null;
        }
    }
}

