/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.connection.internal.ui.filter;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.rdb.connection.internal.ui.util.resource.ResourceLoader;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IVirtualNode;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionFilter;
import org.eclipse.wst.rdb.internal.core.containment.ContainmentService;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;

public abstract class RDBFilterWizardPage
extends WizardPage
implements Listener {
    private static final ResourceLoader resource = ResourceLoader.INSTANCE;
    protected ISelection selection;
    private Button disableFilterCheckbox;
    private Button expressionRadioButton;
    private Button selectionRadioButton;
    private Group expressionGroup;
    private Group selectionGroup;
    private Label expressionLabel;
    private Combo expressionPredicate;
    private Text expressionField;
    private Combo selectionPredicate;
    protected Table selectionTable;
    private Button selectAllButton;
    private Button deselectAllButton;
    private String STARTS_WITH_TEXT;
    private String CONTAINS_TEXT;
    private String ENDS_WITH_TEXT;
    private String NOT_START_WITH_TEXT;
    private String NOT_CONTAIN_TEXT;
    private String NOT_END_WITH_TEXT;
    private String INCLUDE_ITEMS_TEXT;
    private String EXCLUDE_ITEMS_TEXT;
    private static String LIKE_PREDICATE_TEXT = "LIKE";
    private static String IN_PREDICATE_TEXT = "IN";
    private static String NOT_PREDICATE_TEXT = "NOT";
    protected boolean isSelectionListPopulated = false;
    private static String IDENTIFIER_DELIMITER = "'";
    private String DEFAULT_MESSAGE = resource.queryString("_UI_DESCRIPTION_FILTER");
    private static final String SELECTION_ONLY_MESSAGE = resource.queryString("_UI_DESCRIPTION_SELECTION_ONLY");
    private boolean hideExpressionOption = false;

    protected RDBFilterWizardPage(String pageName) {
        super(pageName);
        this.setMessage(this.DEFAULT_MESSAGE);
    }

    protected RDBFilterWizardPage(String pageName, String title, ImageDescriptor titleImage, ISelection sel) {
        super(pageName, title, titleImage);
        this.selection = sel;
        this.setMessage(this.DEFAULT_MESSAGE);
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (source == this.disableFilterCheckbox) {
            this.enableFilterSpecificationControls(!this.disableFilterCheckbox.getSelection());
        } else if (source == this.expressionRadioButton) {
            this.enableFilterSpecificationControls(true);
        } else if (source == this.selectAllButton) {
            this.setAllTableItemsChecked(true);
        } else if (source == this.deselectAllButton) {
            this.setAllTableItemsChecked(false);
        }
        this.setPageComplete(this.validatePage());
    }

    private void setAllTableItemsChecked(boolean checked) {
        TableItem[] tableItems = this.selectionTable.getItems();
        int tableItemCount = tableItems.length;
        int index = 0;
        while (index < tableItemCount) {
            tableItems[index].setChecked(checked);
            ++index;
        }
    }

    private void enableExpressionGroupControls(boolean isEnabled) {
        if (!this.hideExpressionOption) {
            this.expressionGroup.setEnabled(isEnabled);
            this.expressionLabel.setEnabled(isEnabled);
            this.expressionPredicate.setEnabled(isEnabled);
            this.expressionField.setEnabled(isEnabled);
        }
    }

    private void enableSelectionGroupControls(boolean isEnabled) {
        this.selectionGroup.setEnabled(isEnabled);
        this.selectionPredicate.setEnabled(isEnabled);
        this.selectionTable.setEnabled(isEnabled);
        this.selectAllButton.setEnabled(isEnabled);
        this.deselectAllButton.setEnabled(isEnabled);
        TableItem[] tableItems = this.selectionTable.getItems();
        int tableItemCount = tableItems.length;
        int index = 0;
        while (index < tableItemCount) {
            tableItems[index].setGrayed(!isEnabled);
            ++index;
        }
        if (isEnabled && !this.isSelectionListPopulated) {
            this.populateSelectionTable();
        }
    }

    private void enableFilterSpecificationControls(boolean isEnabled) {
        if (!this.hideExpressionOption) {
            if (isEnabled) {
                this.expressionRadioButton.setEnabled(true);
                this.selectionRadioButton.setEnabled(true);
                if (this.expressionRadioButton.getSelection()) {
                    this.enableSelectionGroupControls(false);
                    this.enableExpressionGroupControls(true);
                } else {
                    this.enableExpressionGroupControls(false);
                    this.enableSelectionGroupControls(true);
                }
            } else {
                this.enableExpressionGroupControls(false);
                this.enableSelectionGroupControls(false);
                this.expressionRadioButton.setEnabled(false);
                this.selectionRadioButton.setEnabled(false);
            }
        } else {
            this.enableSelectionGroupControls(isEnabled);
        }
    }

    public void createControl(Composite parent) {
        this.createControl(parent, false);
    }

    public void createControl(Composite parent, boolean hideExpressionOption) {
        this.hideExpressionOption = hideExpressionOption;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 5;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        GridData gd = null;
        if (hideExpressionOption) {
            this.DEFAULT_MESSAGE = SELECTION_ONLY_MESSAGE;
            this.setMessage(this.DEFAULT_MESSAGE);
        }
        if (!hideExpressionOption) {
            this.expressionRadioButton = new Button(composite, 16);
            this.expressionRadioButton.setText(resource.queryString("_UI_RADIO_BUTTON_EXPRESSION"));
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.expressionRadioButton.setLayoutData((Object)gd);
            this.expressionGroup = new Group(composite, 0);
            layout = new GridLayout();
            layout.numColumns = 3;
            layout.verticalSpacing = 5;
            this.expressionGroup.setLayout((Layout)layout);
            gd = new GridData(768);
            gd.verticalAlignment = 1;
            this.expressionGroup.setLayoutData((Object)gd);
            this.expressionLabel = new Label((Composite)this.expressionGroup, 0);
            this.expressionLabel.setText(resource.queryString("_UI_LABEL_EXPRESSION"));
            gd = new GridData();
            this.expressionLabel.setLayoutData((Object)gd);
            this.expressionPredicate = new Combo((Composite)this.expressionGroup, 8);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.expressionPredicate.setLayoutData((Object)gd);
            this.STARTS_WITH_TEXT = resource.queryString("_UI_COMBO_STARTS_WITH");
            this.CONTAINS_TEXT = resource.queryString("_UI_COMBO_CONTAINS");
            this.ENDS_WITH_TEXT = resource.queryString("_UI_COMBO_ENDS_WITH");
            this.NOT_START_WITH_TEXT = resource.queryString("_UI_COMBO_NOT_START_WITH");
            this.NOT_CONTAIN_TEXT = resource.queryString("_UI_COMBO_NOT_CONTAIN");
            this.NOT_END_WITH_TEXT = resource.queryString("_UI_COMBO_NOT_END_WITH");
            this.expressionPredicate.add(this.STARTS_WITH_TEXT);
            this.expressionPredicate.add(this.CONTAINS_TEXT);
            this.expressionPredicate.add(this.ENDS_WITH_TEXT);
            this.expressionPredicate.add(this.NOT_START_WITH_TEXT);
            this.expressionPredicate.add(this.NOT_CONTAIN_TEXT);
            this.expressionPredicate.add(this.NOT_END_WITH_TEXT);
            this.expressionField = new Text((Composite)this.expressionGroup, 2048);
            gd = new GridData(768);
            this.expressionField.setLayoutData((Object)gd);
            this.selectionRadioButton = new Button(composite, 16);
            this.selectionRadioButton.setText(resource.queryString("_UI_RADIO_BUTTON_SELECTION"));
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.selectionRadioButton.setLayoutData((Object)gd);
        }
        this.selectionGroup = new Group(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 5;
        this.selectionGroup.setLayout((Layout)layout);
        gd = new GridData(1808);
        this.selectionGroup.setLayoutData((Object)gd);
        this.selectionPredicate = new Combo((Composite)this.selectionGroup, 8);
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalSpan = 2;
        this.selectionPredicate.setLayoutData((Object)gd);
        this.INCLUDE_ITEMS_TEXT = resource.queryString("_UI_COMBO_INCLUDE_ITEMS");
        this.EXCLUDE_ITEMS_TEXT = resource.queryString("_UI_COMBO_EXCLUDE_ITEMS");
        this.selectionPredicate.add(this.INCLUDE_ITEMS_TEXT);
        this.selectionPredicate.add(this.EXCLUDE_ITEMS_TEXT);
        this.selectionTable = new Table((Composite)this.selectionGroup, 2080);
        gd = new GridData(1808);
        this.selectionTable.setLayoutData((Object)gd);
        Composite buttonComposite = new Composite((Composite)this.selectionGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 5;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(1042));
        this.selectAllButton = new Button(buttonComposite, 0);
        this.selectAllButton.setText(resource.queryString("_UI_BUTTON_SELECT_ALL"));
        this.selectAllButton.setLayoutData((Object)new GridData(770));
        this.deselectAllButton = new Button(buttonComposite, 0);
        this.deselectAllButton.setText(resource.queryString("_UI_BUTTON_DESELECT_ALL"));
        this.deselectAllButton.setLayoutData((Object)new GridData(770));
        this.disableFilterCheckbox = new Button(composite, 32);
        this.disableFilterCheckbox.setText(resource.queryString("_UI_CHECKBOX_DISABLE_FILTER"));
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.disableFilterCheckbox.setLayoutData((Object)gd);
        this.initializeDialogUnits((Control)composite);
        this.setPageComplete(this.validatePage());
        this.setControl((Control)composite);
        this.disableFilterCheckbox.addListener(13, (Listener)this);
        if (!hideExpressionOption) {
            this.expressionRadioButton.addListener(13, (Listener)this);
            this.selectionRadioButton.addListener(13, (Listener)this);
            this.expressionField.addListener(24, (Listener)this);
        }
        this.selectionTable.addListener(13, (Listener)this);
        this.selectionPredicate.addListener(13, (Listener)this);
        this.selectAllButton.addListener(13, (Listener)this);
        this.deselectAllButton.addListener(13, (Listener)this);
        this.disableFilterCheckbox.setSelection(false);
        if (!hideExpressionOption) {
            this.expressionRadioButton.setSelection(true);
            this.expressionPredicate.select(this.expressionPredicate.indexOf(this.STARTS_WITH_TEXT));
            this.selectionPredicate.select(this.selectionPredicate.indexOf(this.INCLUDE_ITEMS_TEXT));
            this.enableSelectionGroupControls(false);
        } else {
            this.selectionPredicate.select(this.selectionPredicate.indexOf(this.INCLUDE_ITEMS_TEXT));
        }
        this.initializeValues();
        this.validatePage();
    }

    protected void initializeValues() {
        this.isSelectionListPopulated = false;
        this.selectionTable.removeAll();
        ConnectionFilter connFilter = this.getConnectionFilter();
        if (connFilter != null) {
            this.disableFilterCheckbox.setSelection(false);
            String predicate = connFilter.getPredicate();
            if (!this.hideExpressionOption && this.isPredicateAnExpression(predicate)) {
                this.expressionRadioButton.setSelection(true);
                this.selectionRadioButton.setSelection(false);
                this.expressionPredicate.select(this.expressionPredicate.indexOf(this.findExpressionPredicate(predicate)));
                this.expressionField.setText(this.findExpressionValue(predicate));
                this.enableFilterSpecificationControls(true);
            } else {
                if (!this.hideExpressionOption) {
                    this.selectionRadioButton.setSelection(true);
                    this.expressionRadioButton.setSelection(false);
                }
                if (this.isPredicateNegated(predicate)) {
                    this.selectionPredicate.select(this.selectionPredicate.indexOf(this.EXCLUDE_ITEMS_TEXT));
                }
                this.populateSelectionTable();
                this.selectSelectionFilterItems(this.findSelectionFilterItems(predicate));
                this.enableFilterSpecificationControls(true);
            }
        } else {
            this.disableFilterCheckbox.setSelection(true);
            this.enableFilterSpecificationControls(false);
        }
    }

    private String[] findSelectionFilterItems(String filterPredicate) {
        Object[] filterItems = new String[]{};
        if (filterPredicate != null) {
            String[] predicateSubStrings = filterPredicate.split(IDENTIFIER_DELIMITER);
            int predicateSubStringsCount = predicateSubStrings.length;
            Vector<String> filterItemCollection = new Vector<String>();
            int index = 1;
            while (index < predicateSubStringsCount - 1) {
                filterItemCollection.add(predicateSubStrings[index]);
                ++index;
            }
            filterItems = new String[filterItemCollection.size()];
            filterItemCollection.copyInto(filterItems);
        }
        return filterItems;
    }

    private void selectSelectionFilterItems(String[] filterItems) {
        TableItem[] tableItems = this.selectionTable.getItems();
        Hashtable<String, TableItem> tableItemsCollection = new Hashtable<String, TableItem>();
        int tableItemsCount = tableItems.length;
        int index = 0;
        while (index < tableItemsCount) {
            tableItemsCollection.put(tableItems[index].getText(), tableItems[index]);
            ++index;
        }
        int filterItemsCount = filterItems.length;
        int index2 = 0;
        while (index2 < filterItemsCount) {
            Object tableItem = tableItemsCollection.get(filterItems[index2]);
            if (tableItem != null) {
                ((TableItem)tableItem).setChecked(true);
            }
            ++index2;
        }
    }

    private boolean isPredicateAnExpression(String filterPredicate) {
        boolean isExpression = false;
        if (filterPredicate != null && filterPredicate.split(IDENTIFIER_DELIMITER)[0].indexOf(LIKE_PREDICATE_TEXT) != -1) {
            isExpression = true;
        }
        return isExpression;
    }

    private boolean isPredicateNegated(String filterPredicate) {
        boolean isNegated = false;
        if (filterPredicate != null && filterPredicate.split(IDENTIFIER_DELIMITER)[0].indexOf(NOT_PREDICATE_TEXT) != -1) {
            isNegated = true;
        }
        return isNegated;
    }

    private String findExpressionValue(String filterPredicate) {
        String expressionValue = filterPredicate.split(IDENTIFIER_DELIMITER)[1];
        if (expressionValue.startsWith("%")) {
            expressionValue = expressionValue.substring(1);
        }
        if (expressionValue.endsWith("%")) {
            expressionValue = expressionValue.substring(0, expressionValue.length() - 1);
        }
        return expressionValue;
    }

    private String findExpressionPredicate(String filterPredicate) {
        String expressionValue;
        String expressionPredicate = this.CONTAINS_TEXT;
        boolean isNotLike = false;
        boolean startsWithPercentSign = false;
        boolean endsWithPercentSign = false;
        if (filterPredicate.startsWith(NOT_PREDICATE_TEXT)) {
            isNotLike = true;
        }
        if ((expressionValue = filterPredicate.split(IDENTIFIER_DELIMITER)[1]).startsWith("%")) {
            startsWithPercentSign = true;
        }
        if (expressionValue.endsWith("%")) {
            endsWithPercentSign = true;
        }
        if (startsWithPercentSign && endsWithPercentSign) {
            expressionPredicate = isNotLike ? this.NOT_CONTAIN_TEXT : this.CONTAINS_TEXT;
        } else if (startsWithPercentSign) {
            expressionPredicate = isNotLike ? this.NOT_END_WITH_TEXT : this.ENDS_WITH_TEXT;
        } else if (endsWithPercentSign) {
            expressionPredicate = isNotLike ? this.NOT_START_WITH_TEXT : this.STARTS_WITH_TEXT;
        }
        return expressionPredicate;
    }

    protected boolean validatePage() {
        boolean isValid = true;
        if (!this.disableFilterCheckbox.getSelection()) {
            if (!this.hideExpressionOption && this.expressionRadioButton.getSelection()) {
                if (this.expressionField.getText().length() == 0) {
                    this.setMessage(resource.queryString("_UI_MESSAGE_CRITERIA_REQUIRED"));
                    this.setErrorMessage(null);
                    isValid = false;
                } else if (this.expressionField.getText().indexOf(IDENTIFIER_DELIMITER) > -1 || this.expressionField.getText().indexOf(34) > -1) {
                    this.setErrorMessage(resource.queryString("_UI_MESSAGE_NO_QUOTES"));
                    this.setMessage(this.DEFAULT_MESSAGE);
                    isValid = false;
                }
            } else {
                TableItem[] items = this.selectionTable.getItems();
                int itemCount = items.length;
                boolean isItemSelected = false;
                int index = 0;
                while (index < itemCount) {
                    if (items[index].getChecked()) {
                        isItemSelected = true;
                        break;
                    }
                    ++index;
                }
                if (!isItemSelected) {
                    this.setMessage(resource.queryString("_UI_MESSAGE_SELECTION_REQUIRED"));
                    this.setErrorMessage(null);
                    isValid = false;
                }
            }
        }
        if (isValid) {
            this.setMessage(this.DEFAULT_MESSAGE);
            this.setErrorMessage(null);
        }
        return isValid;
    }

    public String getPredicate() {
        String predicate = "";
        if (this.isFilterSpecified()) {
            if (!this.hideExpressionOption && this.expressionRadioButton.getSelection()) {
                String selectedPredicate = this.expressionPredicate.getItem(this.expressionPredicate.getSelectionIndex());
                String cleanedString = this.expressionField.getText().trim();
                if (selectedPredicate.equals(this.STARTS_WITH_TEXT)) {
                    predicate = String.valueOf(LIKE_PREDICATE_TEXT) + " " + IDENTIFIER_DELIMITER + cleanedString + "%" + IDENTIFIER_DELIMITER;
                } else if (selectedPredicate.equals(this.NOT_START_WITH_TEXT)) {
                    predicate = String.valueOf(NOT_PREDICATE_TEXT) + " " + LIKE_PREDICATE_TEXT + " " + IDENTIFIER_DELIMITER + cleanedString + "%" + IDENTIFIER_DELIMITER;
                } else if (selectedPredicate.equals(this.CONTAINS_TEXT)) {
                    predicate = String.valueOf(LIKE_PREDICATE_TEXT) + " " + IDENTIFIER_DELIMITER + "%" + cleanedString + "%" + IDENTIFIER_DELIMITER;
                } else if (selectedPredicate.equals(this.NOT_CONTAIN_TEXT)) {
                    predicate = String.valueOf(NOT_PREDICATE_TEXT) + " " + LIKE_PREDICATE_TEXT + " " + IDENTIFIER_DELIMITER + "%" + cleanedString + "%" + IDENTIFIER_DELIMITER;
                } else if (selectedPredicate.equals(this.ENDS_WITH_TEXT)) {
                    predicate = String.valueOf(LIKE_PREDICATE_TEXT) + " " + IDENTIFIER_DELIMITER + "%" + cleanedString + IDENTIFIER_DELIMITER;
                } else if (selectedPredicate.equals(this.NOT_END_WITH_TEXT)) {
                    predicate = String.valueOf(NOT_PREDICATE_TEXT) + " " + LIKE_PREDICATE_TEXT + " " + IDENTIFIER_DELIMITER + "%" + cleanedString + IDENTIFIER_DELIMITER;
                }
            } else {
                String itemList = "";
                TableItem[] items = this.selectionTable.getItems();
                Vector<TableItem> selectedItemsCollection = new Vector<TableItem>();
                int itemCount = items.length;
                int index = 0;
                while (index < itemCount) {
                    if (items[index].getChecked()) {
                        selectedItemsCollection.add(items[index]);
                    }
                    ++index;
                }
                Object[] selectedItems = new TableItem[selectedItemsCollection.size()];
                selectedItemsCollection.copyInto(selectedItems);
                int selectedItemCount = selectedItems.length;
                if (selectedItemCount > 0) {
                    itemList = String.valueOf(itemList) + IDENTIFIER_DELIMITER + selectedItems[0].getText() + IDENTIFIER_DELIMITER;
                    int index2 = 1;
                    while (index2 < selectedItemCount) {
                        itemList = String.valueOf(itemList) + ", " + IDENTIFIER_DELIMITER + selectedItems[index2].getText() + IDENTIFIER_DELIMITER;
                        ++index2;
                    }
                    predicate = String.valueOf(IN_PREDICATE_TEXT) + "(" + itemList + ")";
                    if (this.selectionPredicate.getItem(this.selectionPredicate.getSelectionIndex()).equals(this.EXCLUDE_ITEMS_TEXT)) {
                        predicate = String.valueOf(NOT_PREDICATE_TEXT) + " " + predicate;
                    }
                }
            }
        }
        return predicate;
    }

    public boolean isFilterSpecified() {
        return !this.disableFilterCheckbox.getSelection();
    }

    public boolean isIncludeSelected() {
        return this.selectionPredicate.getItem(this.selectionPredicate.getSelectionIndex()).equals(this.INCLUDE_ITEMS_TEXT);
    }

    private EObject getParentEObject(Object current) {
        while (!(current instanceof EObject) && (current = ((IVirtualNode)current).getParent()) != null) {
        }
        return (EObject)current;
    }

    protected void populateSelectionTable() {
        if (this.selection != null) {
            Object sel = ((StructuredSelection)this.selection).getFirstElement();
            this.selectionTable.removeAll();
            if (sel instanceof IVirtualNode) {
                ContainmentService containmentService = RDBCorePlugin.getDefault().getContainmentService();
                EObject schema = this.getParentEObject(sel);
                Collection viewsCollection = containmentService.getContainedDisplayableElements(schema, ((IVirtualNode)sel).getGroupID());
                Iterator views = viewsCollection.iterator();
                while (views.hasNext()) {
                    TableItem tableItem = new TableItem(this.selectionTable, 0);
                    tableItem.setText(((SQLObject)views.next()).getName());
                }
                this.isSelectionListPopulated = true;
            }
        }
    }

    protected abstract ConnectionFilter getConnectionFilter();
}

