/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.connection.internal.ui.filter;

import java.util.Iterator;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.rdb.connection.internal.ui.filter.RDBFilterWizardPage;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionFilter;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionFilterImpl;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;

public class SchemaFilterWizardPage
extends RDBFilterWizardPage {
    private ConnectionInfo connectionInfo;

    public SchemaFilterWizardPage(String pageName) {
        super(pageName);
    }

    protected ConnectionFilter getConnectionFilter() {
        ConnectionFilter connFilter = null;
        if (this.connectionInfo != null) {
            connFilter = this.connectionInfo.getFilter("DatatoolsSchemaFilterPredicate");
        }
        return connFilter;
    }

    protected void populateSelectionTable() {
        this.selectionTable.removeAll();
        if (this.connectionInfo != null) {
            Iterator schemas = this.connectionInfo.getSharedDatabase().getSchemas().iterator();
            while (schemas.hasNext()) {
                TableItem tableItem = new TableItem(this.selectionTable, 0);
                tableItem.setText(((SQLObject)schemas.next()).getName());
            }
            this.isSelectionListPopulated = true;
        }
    }

    public void setConnectionInfo(ConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
        this.initializeValues();
    }

    public void applyFilter() {
        if (this.connectionInfo != null) {
            if (!this.isFilterSpecified()) {
                this.connectionInfo.removeFilter("DatatoolsSchemaFilterPredicate");
            } else {
                ConnectionFilterImpl connFilter = new ConnectionFilterImpl();
                connFilter.setPredicate(this.getPredicate());
                this.connectionInfo.addFilter("DatatoolsSchemaFilterPredicate", (ConnectionFilter)connFilter);
            }
        }
    }
}

