/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.operation.extensionui;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.internal.ActionExpression;
import org.eclipse.wst.common.frameworks.internal.operation.extensionui.SlaveDescriptor;
import org.eclipse.wst.common.frameworks.internal.operation.extensionui.WTPOperationDataModelUICreator;
import org.eclipse.wst.common.frameworks.internal.ui.WTPCommonUIResourceHandler;

public class MasterDescriptor
extends SlaveDescriptor {
    public static final String MASTER_OPERATION = "masterOperation";
    public static final String ATT_EXTENDED_OPERATION_ID = "extendedGenericId";
    public static final String SELECTION_ENABLEMENT = "selectionEnablement";
    private static final String ATT_POPULATOR_CLASS = "populatorClass";
    private static final String ATT_ALWAYS_EXECUTE = "alwaysExecute";
    private ActionExpression enablement;
    private String extendedOperationId;
    private WTPOperationDataModelUICreator creator;
    private boolean alwaysExecute;

    public MasterDescriptor(IConfigurationElement element) {
        super(element);
        this.init();
    }

    private void init() {
        IConfigurationElement[] elements;
        this.extendedOperationId = this.getElement().getAttribute(ATT_EXTENDED_OPERATION_ID);
        if (this.extendedOperationId == null) {
            Logger.getLogger().log((Object)WTPCommonUIResourceHandler.getString("MasterDescriptor_UI_0", new Object[]{ATT_EXTENDED_OPERATION_ID}));
        }
        if (Boolean.valueOf(this.getElement().getAttribute(ATT_ALWAYS_EXECUTE)).booleanValue()) {
            this.alwaysExecute = true;
        }
        if ((elements = this.getElement().getChildren(SELECTION_ENABLEMENT)).length == 1) {
            this.enablement = new ActionExpression(elements[0]);
        } else {
            Logger.getLogger().log((Object)WTPCommonUIResourceHandler.getString("MasterDescriptor_ERROR_2"));
        }
    }

    public String getExtendedOperationId() {
        return this.extendedOperationId;
    }

    public boolean isEnabledFor(IStructuredSelection selection) {
        if (this.getEnablement() == null) {
            return true;
        }
        boolean result = false;
        Iterator itr = selection.iterator();
        while (itr.hasNext()) {
            result = this.getEnablement().isEnabledFor(itr.next());
            if (result) break;
        }
        return result;
    }

    public WTPOperationDataModelUICreator getCreator() {
        if (this.creator == null) {
            try {
                this.creator = (WTPOperationDataModelUICreator)this.getElement().createExecutableExtension(ATT_POPULATOR_CLASS);
            }
            catch (CoreException e) {
                Logger.getLogger().logError((Throwable)e);
            }
        }
        return this.creator;
    }

    protected ActionExpression getEnablement() {
        return this.enablement;
    }

    public boolean isAlwaysExecute() {
        return this.alwaysExecute;
    }
}

