/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.navigator.internal.ui.workingsets;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.ICommonWorkingSetProvider;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class CommonWorkingSetProviderDescriptor {
    private IConfigurationElement configElement;
    public static final String ATT_CLASS = "class";
    private String className;

    public CommonWorkingSetProviderDescriptor(IConfigurationElement aConfigElement) throws WorkbenchException {
        this.configElement = aConfigElement;
        this.init();
    }

    void init() throws WorkbenchException {
        this.className = this.configElement.getAttribute(ATT_CLASS);
        if (this.className == null || this.className.length() == 0) {
            throw new WorkbenchException("Missing attribute: class in workingSetProviders extension: " + this.configElement.getDeclaringExtension().getUniqueIdentifier());
        }
    }

    public String getClassName() {
        return this.className;
    }

    public ICommonWorkingSetProvider createWorkingSetProvider() {
        if (this.className == null) {
            return null;
        }
        ICommonWorkingSetProvider result = null;
        try {
            result = (ICommonWorkingSetProvider)WorkbenchPlugin.createExtension((IConfigurationElement)this.configElement, (String)ATT_CLASS);
        }
        catch (CoreException exception) {
            WorkbenchPlugin.log((String)("Unable to create common working set provider: " + this.className), (IStatus)exception.getStatus());
        }
        return result;
    }
}

