/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.hyperlink;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.URLHyperlink;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.html.ui.internal.hyperlink.ExternalFileHyperlink;
import org.eclipse.wst.html.ui.internal.hyperlink.WorkspaceFileHyperlink;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.util.StringUtils;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMNamespaceHelper;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class XMLHyperlinkDetector
implements IHyperlinkDetector {
    private final String NO_NAMESPACE_SCHEMA_LOCATION = "noNamespaceSchemaLocation";
    private final String SCHEMA_LOCATION = "schemaLocation";
    private final String XMLNS = "xmlns";
    private final String XSI_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private final String HTTP_PROTOCOL = "http://";

    XMLHyperlinkDetector() {
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IDocument document;
        Node currentNode;
        ArrayList<IHyperlink> hyperlinks = new ArrayList<IHyperlink>(0);
        if (region != null && textViewer != null && (currentNode = this.getCurrentNode(document = textViewer.getDocument(), region.getOffset())) != null) {
            IRegion hyperlinkRegion;
            IHyperlink hyperlink;
            String uriString = null;
            if (currentNode.getNodeType() == 10) {
                uriString = this.getURIString(currentNode, document);
            } else if (currentNode.getNodeType() == 1) {
                Attr currentAttr = this.getCurrentAttrNode(currentNode, region.getOffset());
                if (currentAttr != null && !this.isValidURI(uriString = this.getURIString(currentAttr, document))) {
                    currentAttr = null;
                }
                if (currentAttr == null && (currentAttr = this.getLinkableAttr((Element)currentNode)) != null) {
                    uriString = this.getURIString(currentAttr, document);
                }
                currentNode = currentAttr;
            }
            if (uriString != null && currentNode != null && this.isValidURI(uriString) && (hyperlink = this.createHyperlink(uriString, hyperlinkRegion = this.getHyperlinkRegion(currentNode), document, currentNode)) != null) {
                hyperlinks.add(hyperlink);
            }
        }
        if (hyperlinks.size() == 0) {
            return null;
        }
        return hyperlinks.toArray(new IHyperlink[0]);
    }

    private IHyperlink createHyperlink(String uriString, IRegion hyperlinkRegion, IDocument document, Node node) {
        Object link = null;
        if (uriString != null) {
            String temp = uriString.toLowerCase();
            if (temp.startsWith("http://")) {
                link = new URLHyperlink(hyperlinkRegion, uriString);
            } else {
                IFile file = this.getFile(uriString);
                if (file != null && file.exists()) {
                    link = new WorkspaceFileHyperlink(hyperlinkRegion, file);
                } else {
                    File externalFile = new File(uriString);
                    link = new ExternalFileHyperlink(hyperlinkRegion, externalFile);
                }
            }
        }
        return link;
    }

    private IRegion getHyperlinkRegion(Node node) {
        Region hyperRegion = null;
        if (node != null) {
            short nodeType = node.getNodeType();
            if (nodeType == 10) {
                IDOMNode docNode = (IDOMNode)node;
                hyperRegion = new Region(docNode.getStartOffset(), docNode.getEndOffset() - docNode.getStartOffset());
            } else if (nodeType == 2) {
                IDOMAttr att = (IDOMAttr)node;
                int regOffset = att.getValueRegionStartOffset();
                int regLength = att.getValueRegion().getTextLength();
                String attValue = att.getValueRegionText();
                if (StringUtils.isQuoted((String)attValue)) {
                    ++regOffset;
                    regLength -= 2;
                }
                hyperRegion = new Region(regOffset, regLength);
            }
        }
        return hyperRegion;
    }

    protected String getURIString(Node node, IDocument document) {
        String resolvedURI = null;
        String baseLoc = null;
        String publicId = null;
        String systemId = null;
        short nodeType = node.getNodeType();
        if (nodeType == 10) {
            baseLoc = this.getBaseLocation(document);
            publicId = ((DocumentType)node).getPublicId();
            systemId = ((DocumentType)node).getSystemId();
        } else if (nodeType == 2) {
            Attr attrNode = (Attr)node;
            baseLoc = this.getBaseLocation(document);
            String attrName = attrNode.getName();
            String attrValue = attrNode.getValue();
            attrValue = StringUtils.strip((String)attrValue);
            String prefix = DOMNamespaceHelper.getPrefix((String)attrName);
            String unprefixedName = DOMNamespaceHelper.getUnprefixedName((String)attrName);
            if ("xmlns".equals(prefix) || "xmlns".equals(unprefixedName)) {
                publicId = attrValue;
                systemId = this.getLocationHint(attrNode.getOwnerElement(), publicId);
            } else if ("http://www.w3.org/2001/XMLSchema-instance".equals(DOMNamespaceHelper.getNamespaceURI((Node)attrNode)) && "schemaLocation".equals(unprefixedName)) {
                StringTokenizer st = new StringTokenizer(attrValue);
                publicId = st.hasMoreTokens() ? st.nextToken() : null;
                systemId = st.hasMoreTokens() ? st.nextToken() : null;
            } else {
                systemId = attrValue;
            }
        }
        resolvedURI = this.resolveURI(baseLoc, publicId, systemId);
        return resolvedURI;
    }

    private IFile getFile(String fileString) {
        IFile file = null;
        if (fileString != null) {
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(fileString));
            int i = 0;
            while (i < files.length && file == null) {
                if (files[i].exists()) {
                    file = files[i];
                }
                ++i;
            }
        }
        return file;
    }

    private boolean isLinkableAttr(Attr attr, CMElementDeclaration cmElement) {
        CMAttributeDeclaration attrDecl;
        String attrName = attr.getName();
        String prefix = DOMNamespaceHelper.getPrefix((String)attrName);
        String unprefixedName = DOMNamespaceHelper.getUnprefixedName((String)attrName);
        if ("xmlns".equals(prefix) || "xmlns".equals(unprefixedName)) {
            return true;
        }
        if ("http://www.w3.org/2001/XMLSchema-instance".equals(DOMNamespaceHelper.getNamespaceURI((Node)attr)) && ("schemaLocation".equals(unprefixedName) || "noNamespaceSchemaLocation".equals(unprefixedName))) {
            return true;
        }
        return cmElement != null && (attrDecl = (CMAttributeDeclaration)cmElement.getAttributes().getNamedItem(attrName)) != null && attrDecl.getAttrType() != null && "URI".equals(attrDecl.getAttrType().getDataTypeName());
    }

    private Attr getLinkableAttr(Element element) {
        CMElementDeclaration ed = this.getCMElementDeclaration(element);
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Attr att = (Attr)attrs.item(i);
            if (this.isLinkableAttr(att, ed)) {
                return att;
            }
            ++i;
        }
        return null;
    }

    private CMElementDeclaration getCMElementDeclaration(Element element) {
        CMElementDeclaration ed = null;
        ModelQuery mq = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
        if (mq != null) {
            ed = mq.getCMElementDeclaration(element);
        }
        return ed;
    }

    private Attr getCurrentAttrNode(Node node, int offset) {
        if (node instanceof IndexedRegion && ((IndexedRegion)node).contains(offset) && node.hasAttributes()) {
            NamedNodeMap attrs = node.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                IndexedRegion attRegion = (IndexedRegion)attrs.item(i);
                if (attRegion.contains(offset)) {
                    return (Attr)attrs.item(i);
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Node getCurrentNode(IDocument document, int offset) {
        IndexedRegion inode;
        block6: {
            inode = null;
            IStructuredModel sModel = null;
            try {
                sModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
                inode = sModel.getIndexedRegion(offset);
                if (inode == null) {
                    inode = sModel.getIndexedRegion(offset - 1);
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (sModel != null) {
                    sModel.releaseFromRead();
                }
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (sModel == null) break block6;
            }
            sModel.releaseFromRead();
        }
        if (inode instanceof Node) {
            return (Node)inode;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private String getBaseLocation(IDocument document) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 163->166)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isValidURI(String uriString) {
        boolean isValid = false;
        if (uriString != null) {
            String tempString = uriString.toLowerCase();
            if (tempString.startsWith("http://")) {
                isValid = true;
            } else {
                File file = new File(uriString);
                try {
                    URI uri = new URI(uriString);
                    file = new File(uri);
                }
                catch (URISyntaxException uRISyntaxException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                isValid = file.exists();
            }
        }
        return isValid;
    }

    private String resolveURI(String baseLocation, String publicId, String systemId) {
        if (baseLocation == null && publicId == null && systemId == null) {
            return null;
        }
        return URIResolverPlugin.createResolver().resolve(baseLocation, publicId, systemId);
    }

    private String getLocationHint(Element elementNode, String namespaceURI) {
        Attr schemaLocNode = elementNode.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
        if (schemaLocNode != null) {
            StringTokenizer st = new StringTokenizer(schemaLocNode.getValue());
            while (st.hasMoreTokens()) {
                String systemId;
                String publicId = st.hasMoreTokens() ? st.nextToken() : null;
                String string = systemId = st.hasMoreTokens() ? st.nextToken() : null;
                if (!namespaceURI.equalsIgnoreCase(publicId)) continue;
                return systemId;
            }
        }
        return null;
    }
}

