/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.breakpointproviders;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.debug.core.IJavaStratumLineBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jst.jsp.ui.internal.JSPUIMessages;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.breakpoint.IBreakpointProvider;

public class JavaStratumBreakpointProvider
implements IBreakpointProvider,
IExecutableExtension {
    private String fClassPattern = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public IStatus addBreakpoint(IDocument document, IEditorInput input, int editorLineNumber, int offset) throws CoreException {
        int pos = this.getValidPosition(document, editorLineNumber);
        Status status = null;
        if (pos >= 0) {
            IResource res = this.getResourceFromInput(input);
            if (res != null) {
                IJavaStratumLineBreakpoint point = JDIDebugModel.createStratumBreakpoint((IResource)res, (String)"JSP", (String)res.getName(), null, (String)this.getClassPattern(), (int)editorLineNumber, (int)pos, (int)pos, (int)0, (boolean)true, null);
                if (point == null) {
                    status = new Status(4, "org.eclipse.jst.jsp.ui", 4, "unsupported input type", null);
                }
            } else if (input instanceof IStorageEditorInput) {
                res = ResourcesPlugin.getWorkspace().getRoot();
                String id = input.getName();
                if (input instanceof IStorageEditorInput && ((IStorageEditorInput)input).getStorage() != null) {
                    id = ((IStorageEditorInput)input).getStorage().getFullPath().toString();
                }
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("org.eclipse.wst.sse.ui.extensions.breakpoint.path", id);
                IJavaStratumLineBreakpoint point = JDIDebugModel.createStratumBreakpoint((IResource)res, (String)"JSP", (String)input.getName(), null, (String)this.getClassPattern(), (int)editorLineNumber, (int)pos, (int)pos, (int)0, (boolean)true, attributes);
                if (point == null) {
                    status = new Status(4, "org.eclipse.jst.jsp.ui", 4, "unsupported input type", null);
                }
            }
        }
        if (status == null) {
            status = new Status(0, "org.eclipse.jst.jsp.ui", 0, JSPUIMessages.OK, null);
        }
        return status;
    }

    private String getClassPattern() {
        return this.fClassPattern;
    }

    public IResource getResource(IEditorInput input) {
        return this.getResourceFromInput(input);
    }

    private IResource getResourceFromInput(IEditorInput input) {
        IResource resource;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)input.getAdapter((Class)clazz)) == null) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            resource = (IResource)input.getAdapter((Class)clazz2);
        }
        return resource;
    }

    private int getValidPosition(IDocument idoc, int editorLineNumber) {
        int result = -1;
        if (idoc != null) {
            int startOffset = 0;
            int endOffset = 0;
            try {
                IRegion line = idoc.getLineInformation(editorLineNumber - 1);
                startOffset = line.getOffset();
                endOffset = Math.max(line.getOffset(), line.getOffset() + line.getLength());
                String lineText = idoc.get(startOffset, endOffset - startOffset).trim();
                if (lineText.equals("") || lineText.equals("{") || lineText.equals("}") || lineText.equals("<%")) {
                    result = -1;
                } else {
                    ITypedRegion[] partitions = null;
                    partitions = idoc.computePartitioning(startOffset, endOffset - startOffset);
                    int i = 0;
                    while (i < partitions.length) {
                        String type = partitions[i].getType();
                        if (type == "org.eclipse.jst.jsp.SCRIPT.JAVA" || type == "org.eclipse.jst.jsp.JSP_DIRECTIVE") {
                            result = partitions[i].getOffset();
                        }
                        ++i;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                result = -1;
            }
        }
        return result;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data != null && data instanceof String && data.toString().length() > 0) {
            this.fClassPattern = (String)data;
        }
    }

    public void setSourceEditingTextTools(ISourceEditingTextTools tools) {
    }
}

